/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.servlet;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.servlet.Servlet;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.soda.dk.device.servlet.DeviceServlet;
import org.eclipse.soda.dk.device.servlet.DeviceServletContext;
import org.eclipse.soda.dk.device.servlet.service.DeviceServletService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testagent.service.TestSynchronizationService;
import org.eclipse.soda.dk.testcontroller.service.TestRunListenerService;
import org.eclipse.soda.dk.testcontroller.service.TestSessionService;
import org.eclipse.soda.dk.testmanager.service.ScriptRunListenerService;
import org.eclipse.soda.dk.testmanager.service.TestManagerService;
import org.eclipse.soda.dk.testmanager.service.TestScriptService;
import org.eclipse.soda.dk.testmanager.servlet.DeviceTestManagerServletContext;
import org.eclipse.soda.dk.testmanager.servlet.HeaderValue;
import org.eclipse.soda.dk.testmanager.servlet.MimeMultiPart;
import org.eclipse.soda.dk.testmanager.servlet.MimePart;
import org.eclipse.soda.dk.testmanager.servlet.TestControl;
import org.eclipse.soda.dk.testmanager.servlet.TestReport;

public class DeviceTestManagerServlet
extends DeviceServlet
implements DeviceServletService,
Servlet {
    private static final long serialVersionUID = -6781984721787178138L;
    public static final int STREAM_CLOSED = 7250;
    public static final int INVALID_HEADER = 7251;
    public static final int FAILED_TO_RUN_SCRIPT = 7252;
    public static final int EXPECTED_ENCODING = 7253;
    public static final int RECEIVED_ENCODING = 7254;
    public static final int ENDING_SCRIPT_ACTION = 7256;
    public static final int ERROR_EXECUTING_ACTION = 7257;
    public static final int STARTING_SCRIPT_ACTION = 7258;
    public static final int CONFIG_CHANGES = 7259;
    public static final int TESTS = 7260;
    public static final int TEST_CASES = 7261;
    public static final int TEST_COMPLETED = 7262;
    public static final int ERROR_RUNNING_SCRIPT = 7263;
    public static final int UNTITLED = 7264;
    public static final int RUNNING_TEST_SCRIPT = 7265;
    public static final int ERROR_IN_TEST = 7266;
    public static final int TEST_FAILED = 7267;
    public static final int ERROR_IN_TEST_RUN = 7268;
    public static final int RUNNING = 7269;
    public static ResourceBundle DefaultResourceBundle;
    private TestManagerService testManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.testmanager.servlet.DeviceTestManagerServletResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz);
    }

    private static String replaceAll(String str, String find, String replace) {
        int pos = 0;
        int lastpos = 0;
        int len = find.length();
        StringBuffer b = new StringBuffer();
        while ((pos = str.indexOf(find, pos)) >= 0) {
            b.append(str.substring(lastpos, pos));
            b.append(replace);
            lastpos = pos += len;
        }
        b.append(str.substring(lastpos));
        return b.toString();
    }

    public DeviceServletContext createContext(HttpServletRequest request, HttpServletResponse response) {
        DeviceTestManagerServletContext context = new DeviceTestManagerServletContext(request, response, this.getServletAlias());
        return context;
    }

    private void handleAbortAction(DeviceServletContext context) {
        TestControl testControl;
        HttpSession session = context.getRequest().getSession();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.soda.dk.testmanager.servlet.TestControl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((testControl = (TestControl)session.getValue(clazz.getName())) != null) {
            testControl.finished();
        }
        context.template("ok");
    }

    private void handleCancelAction(DeviceServletContext context) {
        TestControl testControl;
        HttpSession session = context.getRequest().getSession();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.soda.dk.testmanager.servlet.TestControl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((testControl = (TestControl)session.getValue(clazz.getName())) != null) {
            testControl.confirmRequest(false);
        }
        context.template("ok");
    }

    private void handleConfirmAction(DeviceServletContext context) {
        TestControl testControl;
        HttpSession session = context.getRequest().getSession();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.soda.dk.testmanager.servlet.TestControl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((testControl = (TestControl)session.getValue(clazz.getName())) != null) {
            testControl.confirmRequest(true);
        }
        context.template("ok");
    }

    private void handleNextRequestAction(DeviceServletContext context) {
        block9: {
            TestControl testControl;
            HttpSession session = context.getRequest().getSession();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.soda.dk.testmanager.servlet.TestControl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((testControl = (TestControl)session.getValue(clazz.getName())) != null) {
                try {
                    TestControl.Request request = testControl.waitForNextEvent();
                    if (request != null) {
                        context.addEntity("Prompt", (Object)DeviceTestManagerServlet.escape((String)request.prompt));
                        context.addEntity("TestName", (Object)DeviceTestManagerServlet.escape((String)request.testName));
                        context.template("requestspec");
                        break block9;
                    }
                    this.sendHttpError(context, 205);
                }
                catch (InterruptedException interruptedException) {
                    this.sendHttpError(context, 205);
                }
            } else {
                this.sendHttpError(context, 400);
            }
        }
    }

    private void handleRunAction(DeviceServletContext context) {
        MimeMultiPart parser = new MimeMultiPart(context.getRequest(), context.getResponse());
        if ("multipart/form-data".equalsIgnoreCase(parser.getContentType())) {
            try {
                MimePart part;
                while ((part = parser.getNextPart()) != null) {
                    TestScriptService testScript = this.testManager.parse(part.getReader());
                    String header = part.getHeader("content-disposition");
                    if (header != null) {
                        HeaderValue contentDisposition = new HeaderValue(header);
                        String fileName = contentDisposition.getAttribute("filename");
                        testScript.getAttributes().put("url", fileName);
                    }
                    TestControl testControl = new TestControl();
                    TestSessionService testSession = this.testManager.createTestSession((TestSynchronizationService)testControl);
                    testControl.setTestSession(testSession);
                    HttpSession session = context.getRequest().getSession();
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.soda.dk.testmanager.servlet.TestControl");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    session.putValue(clazz.getName(), (Object)testControl);
                    TestReport testReport = new TestReport();
                    testSession.addGlobalTestRunListener((TestRunListenerService)testReport);
                    Class<?> clazz2 = class$2;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("org.eclipse.soda.dk.testmanager.servlet.TestReport");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    session.putValue(clazz2.getName(), (Object)testReport);
                    testScript.run(testSession, (ScriptRunListenerService)testReport, true);
                    context.template("testframeset");
                }
            }
            catch (Exception e) {
                this.sendErrorPage(context, DefaultResourceBundle.getString(Integer.toString(7252)), e.toString());
            }
        } else {
            Object[] parms = new Object[]{parser.getContentType()};
            this.sendErrorPage(context, DefaultResourceBundle.getString(Integer.toString(7253)), Nls.format((String)DefaultResourceBundle.getString(Integer.toString(7254)), (Object[])parms));
        }
        try {
            ServletInputStream in = context.getRequest().getInputStream();
            byte[] data = new byte[1024];
            while (in.available() > 0) {
                in.read(data);
            }
        }
        catch (IOException iOException) {}
    }

    private void processAction(DeviceServletContext context) {
        String action = context.getRequest().getParameter("action");
        if (action == null) {
            this.sendSelectionPage(context);
        } else if ("run".equals(action)) {
            this.handleRunAction(context);
        } else if ("abort".equals(action)) {
            this.handleAbortAction(context);
        } else if ("confirm".equals(action)) {
            this.handleConfirmAction(context);
        } else if ("cancel".equals(action)) {
            this.handleCancelAction(context);
        } else if ("nextrequest".equals(action)) {
            this.handleNextRequestAction(context);
        } else {
            this.sendHttpError(context, 400);
        }
    }

    private void processBottomFrame(DeviceServletContext context) {
        context.template("framebegin");
        context.template("end");
    }

    private void processControlFrame(DeviceServletContext context) {
        context.template("framebegin");
        context.template("controlframe");
        context.template("frameend");
    }

    private void processLogFrame(DeviceServletContext context) {
        TestReport testReport;
        context.getResponse().setHeader("pragma", "no-cache");
        context.template("framebegin");
        context.template("logbegin");
        HttpSession session = context.getRequest().getSession();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.soda.dk.testmanager.servlet.TestReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((testReport = (TestReport)session.getValue(clazz.getName())) != null) {
            try {
                TestControl testControl;
                TestReport.Event event;
                while ((event = testReport.waitForNextEvent()) != null) {
                    String timestamp = Nls.formatTimestamp((long)event.timestamp.getTime());
                    context.addEntity("Timestamp", (Object)timestamp);
                    context.addEntity("Message", (Object)DeviceTestManagerServlet.escape((String)event.message));
                    context.addEntity("Class", (Object)(event.error ? "error" : "normal"));
                    if (event.detail != null) {
                        String htmlDetail = DeviceTestManagerServlet.replaceAll(DeviceTestManagerServlet.escape((String)event.detail), "\n", "<br>\n");
                        context.addEntity("Detail", (Object)htmlDetail);
                        context.template("logdetail");
                    } else {
                        context.template("logline");
                    }
                    context.getResponse().getWriter().flush();
                }
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.soda.dk.testmanager.servlet.TestControl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((testControl = (TestControl)session.getValue(clazz2.getName())) != null) {
                    testControl.finished();
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        context.template("logend");
        context.template("frameend");
    }

    public void processRequest(DeviceServletContext context) {
        if (context.getPath().length() > 0) {
            this.sendHttpError(context, 404);
            return;
        }
        String frame = context.getRequest().getParameter("frame");
        if (frame == null) {
            this.processAction(context);
        } else if (frame.equals("top")) {
            this.processTopFrame(context);
        } else if (frame.equals("bottom")) {
            this.processBottomFrame(context);
        } else if (frame.equals("control")) {
            this.processControlFrame(context);
        } else if (frame.equals("log")) {
            this.processLogFrame(context);
        } else {
            this.sendHttpError(context, 400);
        }
    }

    private void processTopFrame(DeviceServletContext context) {
        context.template("begin");
        context.template("frameend");
    }

    private void sendErrorPage(DeviceServletContext context, String errorMessage, String errorDetail) {
        context.template("begin");
        context.template("warning");
        context.addEntity("ErrorMessage", (Object)DeviceTestManagerServlet.escape((String)errorMessage));
        context.addEntity("ErrorDetail", (Object)DeviceTestManagerServlet.escape((String)errorDetail));
        context.template("error");
        context.template("end");
    }

    private void sendHttpError(DeviceServletContext context, int errorCode) {
        try {
            context.getResponse().sendError(errorCode);
        }
        catch (IOException iOException) {}
    }

    private void sendSelectionPage(DeviceServletContext context) {
        context.template("begin");
        context.template("warning");
        context.template("testselectionform");
        context.template("end");
    }

    public void setTestManager(TestManagerService testManager) {
        this.testManager = testManager;
    }
}

