/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.agent.gen.model;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.agent.gen.model.AbstractAgentGenerator;
import org.eclipse.soda.devicekit.agent.gen.model.elements.AgentModelElement;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.AgentElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.model.java.JavaFileModel;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class AgentGenerator
extends AbstractAgentGenerator {
    private AgentElement agentElement;
    private AgentModelElement agentModelElement;
    private JavaFileModel agentModel;
    private String modelName;
    private String modelPackage;

    public AgentGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
        this.otherManifestFiles = new Hashtable();
    }

    public AgentGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Hashtable methodProperties) {
        super(model, generatedInfo, methodProperties);
    }

    protected void codeBAConfigurationAdvisorField(IType baType) {
        String value = null;
        String fieldType = DkUtilities.stripPackage("com.ibm.witt.robe.edge.configuration.service.FactoryConfigurationAdvisor");
        String comment = this.getBAConfigurationAdvisorFieldComment();
        this.codeField(baType, "configurationAdvisor", fieldType, 8L, comment, value);
    }

    private void codeBACreateAdvisorMethod(IType baType) {
        String returnType = DeviceKitUtilities.stripPackage("org.eclipse.soda.sat.base.framework.interfaces.IManagedServiceFactoryAdvisor");
        this.fBundleActivatorModel.addImport("org.eclipse.soda.sat.base.framework.interfaces.IManagedServiceFactoryAdvisor");
        String contents = this.getBACreateAdvisorMethodContents();
        String comment = this.getBACreateAdvisorMethodComment();
        this.codeMethod(baType, "createAdvisor", comment, returnType, 4L, contents);
    }

    private void codeBACreateExportedServicesMethod(IType baType) {
        String contents = this.getBACreateExportedServicesMethodContents();
        String comment = this.getBACreateExportedServicesMethodComment();
        this.codeMethod(baType, "createExportedServices", comment, "void", 4L, contents);
    }

    private void codeBADestroyExportedServicesMethod(IType baType) {
        String contents = this.getBADestroyExportedServicesMethodContents();
        String comment = this.getBADestroyExportedServicesMethodComment();
        this.codeMethod(baType, "destroyExportedServices", comment, "void", 4L, contents);
    }

    protected void codeBAFields(IType baType) {
        this.codeBAConfigurationAdvisorField(baType);
        super.codeBAFields(baType);
    }

    private void codeBAGetImportedServiceNamesMethod(IType baType) {
        String contents = this.getBAGetImportedServiceNamesMethodContents();
        String comment = this.getBAGetImportedServiceNamesMethodComment();
        this.codeMethod(baType, "getImportedServiceNames", comment, "String[]", 4L, contents);
    }

    protected void codeBAMethods(IType baType) {
        this.codeBACreateAdvisorMethod(baType);
        this.codeBACreateExportedServicesMethod(baType);
        this.codeBADestroyExportedServicesMethod(baType);
        this.codeBAgetEdgeConfigurationServiceMethod(baType);
        this.codeBAGetImportedServiceNamesMethod(baType);
    }

    private void codeBAgetEdgeConfigurationServiceMethod(IType baType) {
        String returnType = DkUtilities.stripPackage("com.ibm.witt.robe.edge.configuration.service.EdgeConfigurationService");
        this.fBundleActivatorModel.addImport("com.ibm.witt.robe.edge.configuration.service.EdgeConfigurationService");
        String contents = this.getBAGetEdgeConfigurationServiceMethodContents();
        String comment = this.getBAGetEdgeConfigurationServiceMethodComment();
        this.codeMethod(baType, "getEdgeConfigurationService", comment, returnType, 4L, contents);
    }

    protected void codeConstructors(IType agent) {
        this.codeOneArgConstructor(agent);
    }

    protected void codeCreateModelMethod(IType agent) {
        String returnType = DkUtilities.stripPackage("com.ibm.kimono.abstractreader.IRfidReader");
        this.agentModel.addImport("com.ibm.kimono.abstractreader.IRfidReader");
        String contents = this.getCreateModelMethodContents();
        KeyValuePair arg = new KeyValuePair(DkUtilities.stripPackage("java.util.Dictionary"), "properties");
        this.agentModel.addImport("java.util.Dictionary");
        this.codeMethod(agent, "createModel", "Creates the model.", returnType, 1L, contents, new KeyValuePair[]{arg}, null);
    }

    protected void codeMethods(IType agent) {
        this.codeConstructors(agent);
        this.codeCreateModelMethod(agent);
    }

    protected void codeOneArgConstructor(IType agent) {
        String methodName = this.getMainClassName();
        String returnType = null;
        String comment = "Agent " + methodName + ".";
        KeyValuePair arg = new KeyValuePair(DkUtilities.stripPackage("java.util.Dictionary"), "properties");
        this.agentModel.addImport("java.util.Dictionary");
        this.codeMethod(agent, methodName, comment, returnType, 1L, "super(properties);\n", new KeyValuePair[]{arg}, null);
    }

    protected IType createAgentType() throws Exception {
        String agentPackage = this.getMainPackage();
        String agentName = this.getMainClassName();
        this.agentModel = new JavaFileModel(agentName);
        this.agentModel.setComment(this.getCopyright());
        this.agentModel.setPackage(agentPackage);
        this.agentModel.addImport(this.getServiceFqn());
        IType agent = this.createClass(this.agentModel, agentPackage, agentName, this.getSourceFolderName());
        agent.setIdentifiers(1L);
        agent.setComment(this.getMainClassComment());
        String superClass = this.agentElement.getSuperClass();
        this.agentModel.addImport(superClass);
        superClass = DeviceKitUtilities.stripPackage(superClass);
        agent.setSuperClass(superClass);
        agent.addSuperInterface(this.getServiceClass());
        String[] interfaces = this.getImplementedInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            agent.addSuperInterface(DkUtilities.stripPackage(interfaces[i]));
            this.agentModel.addImport(interfaces[i]);
            ++i;
        }
        this.agentModel.addImport(this.getServiceFqn());
        return agent;
    }

    private IType createBundleActivatorType() throws Exception {
        String baName = this.getBundleActivatorClass();
        String baPackage = this.getBundleActivatorPackage();
        this.fBundleActivatorModel = new JavaFileModel(baName);
        this.fBundleActivatorModel.setComment(this.getCopyright());
        this.fBundleActivatorModel.setPackage(baPackage);
        IType baType = this.createClass(this.fBundleActivatorModel, baPackage, baName, this.getSourceFolderName());
        String baSuperClass = this.getBASuperClass();
        baType.setSuperClass(DeviceKitUtilities.stripPackage(baSuperClass));
        this.fBundleActivatorModel.addImport(baSuperClass);
        baType.setComment(this.getBundleActivatorComment());
        return baType;
    }

    public void generate() throws Exception {
        super.generate();
        this.generateOtherFiles();
    }

    protected void generateBundleActivatorClass() throws Exception {
        IType baType = this.createBundleActivatorType();
        this.codeBAFields(baType);
        this.codeBAMethods(baType);
        this.generateCustomBundleActivatorItems();
    }

    protected void generateSpecificClass() throws Exception {
        IType agent = this.createAgentType();
        this.codeMethods(agent);
        this.generateCustomMainItems();
    }

    protected AgentElement getAgentElement() {
        if (this.agentElement != null) {
            return this.agentElement;
        }
        return this.getAgentElement(this.getRootElement());
    }

    protected AgentElement getAgentElement(TagElement parent) {
        Vector children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (2001 == ((TagElement)children.elementAt(i)).getTagCode()) {
                return (AgentElement)children.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    private String getBAConfigurationAdvisorFieldComment() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("Define the configuration advisor (");
        buffer.append(DkUtilities.stripPackage("com.ibm.witt.robe.edge.configuration.service.FactoryConfigurationAdvisor"));
        buffer.append(") field.\n");
        return buffer.toString();
    }

    private String getBACreateAdvisorMethodComment() {
        String service = DeviceKitUtilities.stripPackage("org.eclipse.soda.sat.base.framework.interfaces.IManagedServiceFactoryAdvisor");
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("Create advisor and return the ");
        buffer.append(service);
        buffer.append(" result.\n");
        buffer.append("@return\tResults of the create advisor (<code>");
        buffer.append(service);
        buffer.append("</code>) value.\n");
        return buffer.toString();
    }

    private String getBACreateAdvisorMethodContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("return new ");
        buffer.append(this.getCreationAdvisorClass());
        this.fBundleActivatorModel.addImport(this.getCreationAdvisorFqn());
        buffer.append("();\n");
        return buffer.toString();
    }

    private String getBACreateExportedServicesMethodComment() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("Create exported services.\n");
        buffer.append("@see\t\t#destroyExportedServices()");
        return buffer.toString();
    }

    private String getBACreateExportedServicesMethodContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(DkUtilities.stripPackage("com.ibm.witt.robe.edge.configuration.service.EdgeConfigurationService"));
        buffer.append(" edgeConfiguration = getEdgeConfigurationService();\n");
        buffer.append("configurationAdvisor = new ");
        buffer.append(this.getConfigurationAdvisorClass());
        this.fBundleActivatorModel.addImport(this.getConfigurationAdvisorFqn());
        buffer.append("();\n");
        buffer.append("edgeConfiguration.registerFactory(configurationAdvisor);\n");
        buffer.append("super.createExportedServices();\n");
        return buffer.toString();
    }

    private String getBADestroyExportedServicesMethodComment() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("Destroy exported services.\n");
        buffer.append("@see\t\t#createExportedServices()");
        return buffer.toString();
    }

    private String getBADestroyExportedServicesMethodContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(DkUtilities.stripPackage("com.ibm.witt.robe.edge.configuration.service.EdgeConfigurationService"));
        buffer.append(" edgeConfiguration = getEdgeConfigurationService();\n");
        buffer.append("edgeConfiguration.unregisterFactory(configurationAdvisor);\n");
        buffer.append("super.destroyExportedServices();\n");
        return buffer.toString();
    }

    private String getBAGetEdgeConfigurationServiceMethodComment() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("Gets the edge configuration service value.\n");
        buffer.append("@return\tThe edge configuration service (<code>");
        buffer.append(DkUtilities.stripPackage("com.ibm.witt.robe.edge.configuration.service.EdgeConfigurationService"));
        buffer.append("</code>) value.\n");
        return buffer.toString();
    }

    private String getBAGetEdgeConfigurationServiceMethodContents() {
        String service = DkUtilities.stripPackage("com.ibm.witt.robe.edge.configuration.service.EdgeConfigurationService");
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("return (");
        buffer.append(service);
        buffer.append(") ");
        buffer.append("getImportedService");
        buffer.append('(');
        buffer.append(service);
        buffer.append(".SERVICE_NAME);\n");
        return buffer.toString();
    }

    private String getBAGetImportedServiceNamesMethodComment() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("Gets the imported service names (String[]) value.\n");
        buffer.append("@return\tThe imported service names (<code>String[]</code>) value.\n");
        return buffer.toString();
    }

    private String getBAGetImportedServiceNamesMethodContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("return new String[] { ");
        buffer.append(DeviceKitUtilities.stripPackage("com.ibm.witt.robe.edge.configuration.service.EdgeConfigurationService"));
        buffer.append(".SERVICE_NAME");
        buffer.append(" };\n");
        return buffer.toString();
    }

    protected String getBASuperClass() {
        return "org.eclipse.soda.sat.base.framework.ManagedServiceFactoryBundleActivator";
    }

    protected String getBundleActivatorClass() {
        String mainClass = this.getMainClassName();
        return String.valueOf(mainClass) + "Factory";
    }

    protected String getBundleActivatorComment() {
        StringBuffer buffer = new StringBuffer(64);
        String desc = this.getMainElement().getDescription();
        if (desc != null) {
            buffer.append(desc);
            if (!desc.trim().endsWith(".")) {
                buffer.append('.');
            }
            buffer.append("\n\n ");
        }
        buffer.append("<p>The agent bundle activator class creates and registers the " + this.getMainClassName() + " agent.\n");
        buffer.append(this.getCommonClassComment());
        return buffer.toString();
    }

    protected String getBundleActivatorFqn() {
        return String.valueOf(this.getBundleActivatorPackage()) + '.' + this.getBundleActivatorClass();
    }

    protected String getBundleActivatorPackage() {
        String mainPackage = this.getMainPackage();
        return String.valueOf(mainPackage) + ".factory";
    }

    protected String getConfigurationAdvisorClass() {
        String mainClass = this.getMainClassName();
        return String.valueOf(mainClass) + "ConfigurationAdvisor";
    }

    protected String getConfigurationAdvisorFqn() {
        return String.valueOf(this.getConfigurationAdvisorPackage()) + '.' + this.getConfigurationAdvisorClass();
    }

    protected String getConfigurationAdvisorPackage() {
        return this.getBundleActivatorPackage();
    }

    protected String getConstantsPackage() {
        return String.valueOf(this.getMainPackage()) + '.' + "constants";
    }

    protected String getCreateModelMethodContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("// TODO Auto-generated method stub\n");
        buffer.append("return ");
        if (this.getModelName() != null) {
            buffer.append("new ");
            buffer.append(this.getModelName());
            buffer.append("(");
            buffer.append("properties");
            buffer.append(")");
            this.agentModel.addImport(this.getModelFqn());
        } else {
            buffer.append("null");
        }
        buffer.append(";\n");
        return buffer.toString();
    }

    protected String getCreationAdvisorClass() {
        String mainClass = this.getMainClassName();
        return String.valueOf(mainClass) + "CreationAdvisor";
    }

    protected String getCreationAdvisorFqn() {
        return String.valueOf(this.getCreationAdvisorPackage()) + '.' + this.getCreationAdvisorClass();
    }

    protected String getCreationAdvisorPackage() {
        return this.getBundleActivatorPackage();
    }

    protected String[] getImplementedInterfaces() {
        return new String[0];
    }

    protected String getMainClassComment() {
        StringBuffer buffer = new StringBuffer(64);
        String desc = this.getMainElement().getDescription();
        if (desc != null) {
            buffer.append(desc);
            if (!desc.trim().endsWith(".")) {
                buffer.append('.');
            }
            buffer.append("\n\n ");
        }
        buffer.append(this.getCommonClassComment());
        return buffer.toString();
    }

    public JavaFileModel getMainModel() {
        return this.agentModel;
    }

    protected String getManifestBundleName() {
        return super.getManifestBundleName();
    }

    protected Vector getManifestExportPackages() {
        Vector result = super.getManifestExportPackages();
        result.add(this.getMainPackage());
        result.add(this.getServicePackage());
        result.add(this.getConstantsPackage());
        String modelPackage = this.getModelPackage();
        if (modelPackage != null) {
            result.add(modelPackage);
        }
        return result;
    }

    protected String getModelFqn() {
        String modelPackage = this.getModelPackage();
        String modelName = this.getModelName();
        if (modelName != null && modelPackage != null) {
            return String.valueOf(modelPackage) + '.' + modelName;
        }
        return null;
    }

    protected String getModelName() {
        return this.modelName;
    }

    protected String getModelPackage() {
        return this.modelPackage;
    }

    protected void initialize() {
        this.agentElement = this.getAgentElement();
        this.setMainTagElement(this.agentElement);
        String className = DeviceKitUtilities.getClassNameFromTagElement(this.agentElement);
        this.setMainClassName(className);
        this.setPackageBase(this.agentElement.getPackageBase());
        this.setMainPackage(DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase()));
        Vector models = this.agentElement.getAllChildrenWithTagCode(2003);
        if (models.size() > 0) {
            this.agentModelElement = (AgentModelElement)models.get(0);
            this.setModelName(this.agentModelElement.getId());
            String modelPackage = DeviceKitUtilities.getPackageFromClassName(this.getModelName(), this.getPackageBase());
            this.setModelPackage(modelPackage);
        }
    }

    public Vector save() throws Exception {
        Vector superResult = super.save();
        Vector<Object> result = new Vector<Object>();
        this.agentModel.setSaver(this.getSaver());
        Object agent = this.agentModel.save();
        if (agent != null) {
            result.addElement(agent);
        }
        return DeviceKitUtilities.mergeVectors(result, superResult);
    }

    protected void setModelName(String modelName) {
        this.modelName = modelName;
    }

    protected void setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
    }
}

