/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.agent.gen.model;

import java.util.Vector;
import org.eclipse.soda.devicekit.agent.gen.model.AgentTestGenerator;
import org.eclipse.soda.devicekit.agent.gen.model.elements.AgentModelElement;
import org.eclipse.soda.devicekit.agent.gen.model.elements.AgentModelTestElement;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.AgentElement;
import org.eclipse.soda.devicekit.generator.model.elements.AgentTestElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class AgentModelTestGenerator
extends AgentTestGenerator {
    private String modelName;
    private String modelPackage;
    private AgentModelElement agentModelElement;

    public AgentModelTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    protected void codeCreateModelMethod(IType agentTest) {
        String comment = this.getCreateModelMethodComment();
        String returnType = DkUtilities.stripPackage("com.ibm.kimono.abstractreader.AbstractRfidReader");
        this.getAgentTestModel().addImport("com.ibm.kimono.abstractreader.AbstractRfidReader");
        String contents = this.getCreateModelMethodContents();
        KeyValuePair arg = new KeyValuePair(DkUtilities.stripPackage("java.util.Dictionary"), "properties");
        this.getAgentTestModel().addImport("java.util.Dictionary");
        this.codeMethod(agentTest, "createModel", comment, returnType, 1L, contents, new KeyValuePair[]{arg}, null);
    }

    protected void codeMethods(IType agentTest) {
        this.codeConstructors(agentTest);
        this.codeMainMethod(agentTest);
        this.codeCreateDeviceMethod(agentTest);
        this.codeCreateModelMethod(agentTest);
    }

    public AgentModelElement getAgentModelElement() {
        return this.agentModelElement;
    }

    protected String getCreateModelMethodComment() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("Create the model and return the ");
        buffer.append(DkUtilities.stripPackage("com.ibm.kimono.abstractreader.AbstractRfidReader"));
        buffer.append(" result.\n");
        buffer.append('\n');
        buffer.append("@return\tResults of the create model (<code>");
        buffer.append(DkUtilities.stripPackage("com.ibm.kimono.abstractreader.AbstractRfidReader"));
        buffer.append("</code>) value.\n");
        buffer.append('\n');
        buffer.append("@param properties\tThe properties (<code>Dictionary</code>) parameter.\n");
        return buffer.toString();
    }

    protected String getCreateModelMethodContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("return new ");
        buffer.append(this.getModelName());
        this.getAgentTestModel().addImport(this.getModelFqn());
        buffer.append("(properties);\n");
        return buffer.toString();
    }

    protected String[] getImplementedInterfaces() {
        return new String[]{"com.ibm.kimono.abstractreader.RfidReaderListener"};
    }

    protected String getManifestBundleName() {
        return this.getMainClassName();
    }

    protected String getManifestDescription() {
        return this.getMainClassName();
    }

    protected String getModelFqn() {
        return String.valueOf(this.getModelPackage()) + '.' + this.getModelPackage();
    }

    protected String getModelName() {
        return this.modelName;
    }

    protected String getModelPackage() {
        return this.modelPackage;
    }

    protected String getSuperClass() {
        return "com.ibm.kimono.reader.test.KimonoReaderTest";
    }

    protected void initialize() {
        Vector models;
        AgentTestElement element = this.getAgentTestElement();
        this.setAgentTestElement(element);
        Vector modelTests = element.getAllChildrenWithTagCode(2004);
        if (modelTests.size() <= 0) {
            return;
        }
        AgentModelTestElement mainElement = (AgentModelTestElement)modelTests.get(0);
        this.setMainTagElement(mainElement);
        AgentElement agentElement = this.getAgentElement();
        if (agentElement != null && (models = agentElement.getAllChildrenWithTagCode(2003)).size() > 0) {
            this.setAgentModelElement((AgentModelElement)models.get(0));
            this.setModelName(this.getAgentModelElement().getId());
            String modelPackage = DeviceKitUtilities.getPackageFromClassName(this.getModelName(), this.getPackageBase());
            this.setModelPackage(modelPackage);
            String className = String.valueOf(this.getAgentModelElement().getId()) + "Test";
            this.setMainClassName(className);
            this.setPackageBase(element.getPackageBase());
            this.setMainPackage(DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase()));
        }
    }

    public void setAgentModelElement(AgentModelElement element) {
        this.agentModelElement = element;
    }

    protected void setModelName(String modelName) {
        this.modelName = modelName;
    }

    protected void setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
    }
}

