/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.agent.gen.model;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.agent.gen.model.AbstractAgentGenerator;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.AgentElement;
import org.eclipse.soda.devicekit.generator.model.elements.AgentTestElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.model.java.JavaFileModel;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class AgentTestGenerator
extends AbstractAgentGenerator {
    private AgentElement agentElement;
    private AgentTestElement agentTestElement;
    private JavaFileModel agentTestModel;
    private boolean hasModel = false;

    public AgentTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    public AgentTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Hashtable methodProperties) {
        super(model, generatedInfo, methodProperties);
    }

    protected void codeConstructors(IType agentTest) {
        this.codeDefaultConstructor(agentTest);
        this.codeOneArgConstructor(agentTest);
    }

    protected void codeCreateAgentMethod(IType agentTest) {
        String comment = this.getCreateAgentMethodComment();
        String returnType = DkUtilities.stripPackage("com.ibm.kimono.abstractreaderagent.AbstractReaderAgent");
        this.agentTestModel.addImport("com.ibm.kimono.abstractreaderagent.AbstractReaderAgent");
        String contents = this.getCreateAgentMethodContents();
        KeyValuePair arg = new KeyValuePair(DkUtilities.stripPackage("java.util.Dictionary"), "properties");
        this.agentTestModel.addImport("java.util.Dictionary");
        this.codeMethod(agentTest, "createAgent", comment, returnType, 1L, contents, new KeyValuePair[]{arg}, null);
    }

    protected void codeCreateDeviceMethod(IType agentTest) {
        String comment = this.getCreateDeviceMethodComment();
        String returnType = DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        String contents = this.getCreateDeviceMethodContents();
        this.codeMethod(agentTest, "createDevice", comment, returnType, 1L, contents);
    }

    protected void codeDefaultConstructor(IType agentTest) {
        String methodName = this.getMainClassName();
        String returnType = null;
        String comment = this.getDefaultConstructorComment();
        this.codeMethod(agentTest, methodName, comment, returnType, 1L, "super();\n");
    }

    protected void codeFields(IType agentTest) {
    }

    protected void codeMainMethod(IType agentTest) {
        String[] comment = new String[]{"Main method to run tests in a standalone mode.", " ", "@param\targs\tThe args (<code>String[]</code>) parameter."};
        String contents = this.getMainMethodContents();
        KeyValuePair parameter = new KeyValuePair("String[]", "args");
        this.codeMethod(agentTest, "main", comment, "void", 17L, contents, new KeyValuePair[]{parameter}, null);
    }

    protected void codeMethods(IType agentTest) {
        this.codeConstructors(agentTest);
        this.codeMainMethod(agentTest);
        this.codeCreateDeviceMethod(agentTest);
        this.codeCreateAgentMethod(agentTest);
    }

    protected void codeOneArgConstructor(IType agentTest) {
        String methodName = this.getMainClassName();
        String returnType = null;
        String comment = this.getOneArgConstructorComment();
        KeyValuePair arg = new KeyValuePair("String", "name");
        this.codeMethod(agentTest, methodName, comment, returnType, 1L, "super(name);\n", new KeyValuePair[]{arg}, null);
    }

    protected IType createAgentTestType() throws Exception {
        String agentTestPackage = this.getMainPackage();
        String agentTestName = this.getMainClassName();
        IType agent = this.createClass(this.agentTestModel, agentTestPackage, agentTestName, this.getSourceFolderName());
        agent.setIdentifiers(1L);
        agent.setComment(this.getMainClassComment());
        String superClass = this.getSuperClass();
        this.agentTestModel.addImport(superClass);
        superClass = DeviceKitUtilities.stripPackage(superClass);
        agent.setSuperClass(superClass);
        this.agentTestModel.addImport(this.getServiceFqn());
        String serviceName = DeviceKitUtilities.stripPackage(this.getServiceClass());
        agent.addSuperInterface(serviceName);
        String[] interfaces = this.getImplementedInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            agent.addSuperInterface(DkUtilities.stripPackage(interfaces[i]));
            this.agentTestModel.addImport(interfaces[i]);
            ++i;
        }
        return agent;
    }

    protected AgentElement findAgentElement() {
        AgentTestElement agentTestElement = this.getAgentTestElement();
        Vector result = agentTestElement.getAllChildrenWithTagCode(2001);
        if (result != null && result.size() > 0) {
            return (AgentElement)result.get(0);
        }
        return null;
    }

    protected void generateSpecificClass() throws Exception {
        IType agentTest = this.createAgentTestType();
        this.codeFields(agentTest);
        this.codeMethods(agentTest);
        this.generateCustomMainItems();
    }

    protected AgentElement getAgentElement() {
        if (this.agentElement == null) {
            this.agentElement = this.findAgentElement();
        }
        return this.agentElement;
    }

    private String getAgentFqn() {
        AgentElement element = this.getAgentElement();
        String className = DeviceKitUtilities.getClassNameFromTagElement(element);
        String packageName = DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase());
        return String.valueOf(packageName) + '.' + className;
    }

    protected AgentTestElement getAgentTestElement() {
        if (this.agentTestElement != null) {
            return this.agentTestElement;
        }
        return this.getAgentTestElement(this.getRootElement());
    }

    protected AgentTestElement getAgentTestElement(TagElement parent) {
        Vector children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (2002 == ((TagElement)children.elementAt(i)).getTagCode()) {
                return (AgentTestElement)children.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public JavaFileModel getAgentTestModel() {
        return this.agentTestModel;
    }

    protected String getBASuperClass() {
        return "";
    }

    protected String getCreateAgentMethodComment() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("Create the model and return the ");
        buffer.append(DkUtilities.stripPackage("com.ibm.kimono.abstractreaderagent.AbstractReaderAgent"));
        buffer.append(" result.\n");
        buffer.append("@return\tResults of the create model (<code>");
        buffer.append(DkUtilities.stripPackage("com.ibm.kimono.abstractreaderagent.AbstractReaderAgent"));
        buffer.append("</code>) value.\n");
        buffer.append("@param properties\tThe properties (<code>Dictionary</code>) parameter.\n");
        return buffer.toString();
    }

    protected String getCreateAgentMethodContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("return new ");
        String agentType = this.getAgentFqn();
        buffer.append(DkUtilities.stripPackage(agentType));
        this.agentTestModel.addImport(agentType);
        buffer.append("(properties);\n");
        return buffer.toString();
    }

    protected String getCreateDeviceMethodComment() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("Create the device and return the ");
        buffer.append(DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE));
        buffer.append(" result.\n");
        buffer.append("@return\tResults of the create model (<code>");
        buffer.append(DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE));
        buffer.append("</code>) value.\n");
        buffer.append("@see\t\t#getDevice()\n");
        buffer.append("@see\t\t#setDevice(");
        buffer.append(DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE));
        buffer.append(")\n");
        return buffer.toString();
    }

    protected String getCreateDeviceMethodContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("return new ");
        String device = this.getDeviceType();
        this.agentTestModel.addImport(device);
        buffer.append(DkUtilities.stripPackage(device));
        buffer.append("();\n");
        return buffer.toString();
    }

    protected String getDefaultConstructorComment() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("Constructs an instance of this class from the specified name parameter.\n");
        buffer.append("@see\t\t#");
        buffer.append(this.getMainClassName());
        buffer.append("()\n");
        return buffer.toString();
    }

    protected MainTagElement getDeviceElement() {
        AgentElement agentElement = this.getAgentElement();
        Vector devices = agentElement.getAllChildrenWithTagCode(8);
        if (devices != null && devices.size() > 0) {
            return (MainTagElement)devices.get(0);
        }
        return null;
    }

    protected String getDeviceType() {
        MainTagElement deviceElement = this.getDeviceElement();
        if (deviceElement != null) {
            return deviceElement.getId();
        }
        return null;
    }

    protected String[] getImplementedInterfaces() {
        return new String[0];
    }

    protected String getMainClassComment() {
        StringBuffer buffer = new StringBuffer(64);
        String desc = this.getMainElement().getDescription();
        if (desc != null) {
            buffer.append(desc);
            if (!desc.trim().endsWith(".")) {
                buffer.append('.');
            }
            buffer.append("\n\n ");
        }
        buffer.append(this.getCommonClassComment());
        return buffer.toString();
    }

    private String getMainMethodContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("final ");
        String testClassName = this.getMainClassName();
        buffer.append(testClassName);
        buffer.append(" test = new ");
        buffer.append(testClassName);
        buffer.append("();\n");
        buffer.append("test.test();\n");
        buffer.append("System.exit(0);\n");
        return buffer.toString();
    }

    public JavaFileModel getMainModel() {
        return this.agentTestModel;
    }

    protected Vector getManifestExportPackages() {
        Vector<String> result = new Vector<String>();
        result.add(this.getMainPackage());
        result.add(this.getServicePackage());
        return result;
    }

    protected String getOneArgConstructorComment() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("Constructs an instance of this class.\n");
        buffer.append("@param\tname\tThe name (<code>String</code>) parameter.\n");
        buffer.append("@see\t\t#");
        buffer.append(this.getMainClassName());
        buffer.append("(String)\n");
        return buffer.toString();
    }

    protected String getSuperClass() {
        return this.agentTestElement.getSuperClass();
    }

    public boolean hasModel() {
        return this.hasModel;
    }

    protected void initialize() {
        this.setAgentTestElement(this.getAgentTestElement());
        this.setMainTagElement(this.agentTestElement);
        String className = DeviceKitUtilities.getClassNameFromTagElement(this.agentTestElement);
        this.setMainClassName(className);
        this.setPackageBase(this.agentTestElement.getPackageBase());
        this.setMainPackage(DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase()));
        AgentElement agentElement = this.getAgentElement();
        if (agentElement != null) {
            Vector models = agentElement.getAllChildrenWithTagCode(2003);
            Vector modelTests = this.agentTestElement.getAllChildrenWithTagCode(2004);
            if (models.size() > 0 && modelTests.size() > 0) {
                this.hasModel = true;
            }
            this.getDeviceElement();
        }
        String agentTestPackage = this.getMainPackage();
        String agentTestName = this.getMainClassName();
        this.agentTestModel = new JavaFileModel(agentTestName);
        this.agentTestModel.setComment(this.getCopyright());
        this.agentTestModel.setPackage(agentTestPackage);
        this.agentTestModel.addImport(this.getServiceFqn());
    }

    public Vector save() throws Exception {
        Vector superResult = super.save();
        Vector<Object> result = new Vector<Object>();
        if (this.agentTestModel != null) {
            this.agentTestModel.setSaver(this.getSaver());
            Object agent = this.agentTestModel.save();
            if (agent != null) {
                result.addElement(agent);
            }
            DeviceKitUtilities.mergeVectors(result, superResult);
        }
        return result;
    }

    protected void setAgentTestElement(AgentTestElement element) {
        this.agentTestElement = element;
    }
}

