/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.ant;

import java.io.File;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.soda.devicekit.generator.GeneratorPlugin;
import org.eclipse.soda.devicekit.generator.ant.DkJunitAntGenerator;
import org.eclipse.soda.devicekit.generator.ant.JUnitSaver;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitEclipseUtilities;
import org.eclipse.soda.devicekit.util.DkmlReferenceResolver;

public class DkAntGenerator {
    private IJavaProject project;
    private IFile dkmlFile;

    public DkAntGenerator(IJavaProject project, IFile dkmlFile) {
        this.project = project;
        this.dkmlFile = dkmlFile;
    }

    private String fixSlashes(String string) {
        if (string == null) {
            return string;
        }
        String tstring = string.replace('/', File.separatorChar);
        tstring = tstring.replace('\\', File.separatorChar);
        return tstring;
    }

    public void generate() {
        if (this.dkmlFile == null || !this.dkmlFile.exists() || this.project == null || !this.project.exists()) {
            return;
        }
        DeviceKitTagModel model = this.getTagModel();
        int type = this.getModelType(model);
        DkJunitAntGenerator generator = new DkJunitAntGenerator(model, this.project.getElementName(), type);
        generator.setClassPath(this.getClassPath(this.project));
        String ivehome = this.getIveHome(this.project);
        generator.setIveHome(ivehome);
        generator.generate();
        generator.setSaver(new JUnitSaver(this.project));
        try {
            generator.save();
        }
        catch (Exception exception) {}
    }

    private String[] getClassPath(IJavaProject project) {
        try {
            Vector<String> classpath = new Vector<String>();
            IClasspathEntry[] cp = project.getRawClasspath();
            int i = 0;
            while (i < cp.length) {
                switch (cp[i].getEntryKind()) {
                    case 2: {
                        String projectPath = this.getProjectPath(cp[i]);
                        if (projectPath == null || classpath.contains(projectPath)) break;
                        classpath.addElement(projectPath);
                        break;
                    }
                    case 1: {
                        String libraryPath = cp[i].getPath().toOSString();
                        if (classpath.contains(libraryPath)) break;
                        classpath.addElement(libraryPath);
                        break;
                    }
                    case 4: {
                        String variablePath = this.getVariablePath(cp[i]);
                        if (variablePath == null || classpath.contains(variablePath)) break;
                        classpath.addElement(variablePath);
                        break;
                    }
                    case 3: {
                        String sourcePath = this.getProjectPath(cp[i]);
                        if (classpath.contains(sourcePath)) break;
                        classpath.addElement(sourcePath);
                        break;
                    }
                    case 5: {
                        String containerPath = cp[i].getPath().toOSString();
                        if (classpath.contains(containerPath)) break;
                        classpath.addElement(containerPath);
                    }
                }
                ++i;
            }
            Object[] result = new String[classpath.size()];
            classpath.copyInto(result);
            return result;
        }
        catch (JavaModelException javaModelException) {
            return new String[0];
        }
    }

    private String getIveHome(IJavaProject project) {
        try {
            return JavaRuntime.getVMInstall((IJavaProject)project).getInstallLocation().toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int getModelType(DeviceKitTagModel model) {
        Vector tests = model.getRoot().getAllChildrenWithTagCode(10);
        if (tests.size() > 0) {
            TagElement te = (TagElement)tests.elementAt(0);
            if (te.getAllChildrenWithTagCode(9).size() > 0) {
                return 9;
            }
            if (te.getAllChildrenWithTagCode(8).size() > 0) {
                return 8;
            }
        }
        return -1;
    }

    private String getProjectPath(IClasspathEntry entry) {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("../");
            IPath path = entry.getPath().uptoSegment(1);
            IProject refproject = GeneratorPlugin.getWorkspace().getRoot().getProject(path.toString());
            IJavaProject refJproject = DeviceKitEclipseUtilities.getJavaProjectFromProject(refproject);
            if (refJproject != null && refJproject.exists()) {
                IPath refoutput = refJproject.getOutputLocation();
                String projOutput = refoutput.toString();
                if (projOutput.startsWith("/") || projOutput.startsWith("\\")) {
                    projOutput = projOutput.substring(1);
                }
                buffer.append(this.fixSlashes(projOutput));
                return buffer.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Vector getReferencedFiles(IFile file) throws Exception {
        try {
            DkmlReferenceResolver resolver = new DkmlReferenceResolver(file);
            return resolver.getReferences();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private DeviceKitTagModel getTagModel() {
        DeviceKitTagModel model = null;
        try {
            model = new DeviceKitTagModel(this.dkmlFile.getContents(), this.getReferencedFiles(this.dkmlFile));
            model.build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }

    private String getVariablePath(IClasspathEntry entry) {
        IPath segment = entry.getPath().uptoSegment(1);
        String var = segment.toOSString();
        if (var.startsWith("/") || var.startsWith("\\")) {
            var = var.substring(1);
        }
        if (var.equals("JRE_LIB")) {
            return this.handleJRELib(JavaCore.getClasspathVariable((String)var), entry);
        }
        IPath path = JavaCore.getClasspathVariable((String)var);
        if (path != null) {
            String[] segments = entry.getPath().segments();
            StringBuffer result = new StringBuffer();
            result.append(path.toOSString());
            result.append(File.separator);
            int i = 1;
            while (i < segments.length) {
                if (i > 1) {
                    result.append(File.separator);
                }
                result.append(segments[i]);
                ++i;
            }
            return this.fixSlashes(result.toString());
        }
        return null;
    }

    private String handleJRELib(IPath path, IClasspathEntry entry) {
        if (path != null) {
            String[] segments = path.segments();
            StringBuffer result = new StringBuffer();
            result.append(path.getDevice());
            boolean replaceNext = false;
            int i = 0;
            while (i < segments.length) {
                result.append(File.separator);
                if (replaceNext) {
                    result.append("jclMax");
                    replaceNext = false;
                } else if (segments[i].equals("lib")) {
                    replaceNext = true;
                    result.append(segments[i]);
                } else {
                    result.append(segments[i]);
                }
                ++i;
            }
            return result.toString();
        }
        return null;
    }
}

