/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.ant;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.soda.devicekit.generator.GeneratorPlugin;
import org.eclipse.soda.devicekit.generator.model.ant.AntModel;
import org.eclipse.soda.devicekit.generator.model.ant.IAntTarget;
import org.eclipse.soda.devicekit.generator.model.ant.IAntTask;

public class DkmlAntScriptGenerator {
    private File antFile;
    private String[] projects;
    private List dkmlFiles;
    private List targets;

    public DkmlAntScriptGenerator(String[] projects, File antFile) {
        this.projects = projects;
        this.antFile = antFile;
        this.dkmlFiles = new ArrayList();
        this.targets = new ArrayList();
    }

    private void findCmlFilesInContainer(IContainer project) throws CoreException {
        IResource[] resources = project.members();
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IContainer) {
                this.findCmlFilesInContainer((IContainer)resources[i]);
            } else if ("xml".equals(resources[i].getFileExtension())) {
                this.dkmlFiles.add(resources[i]);
            }
            ++i;
        }
    }

    private void findCmlFilesInProject(String projectName) throws CoreException {
        IProject project = GeneratorPlugin.getWorkspace().getRoot().getProject(projectName);
        project.exists();
        this.findCmlFilesInContainer((IContainer)project);
    }

    public void generate() throws Exception {
        AntModel model = new AntModel(this.antFile.getName(), "generate");
        model.setBaseDir("..");
        model.setDefaultTarget("generate");
        IAntTarget generateCml = model.createAntTarget("generate");
        int i = 0;
        while (i < this.projects.length) {
            this.getGenerateProjects(model, this.projects[i]);
            ++i;
        }
        i = 0;
        while (i < this.targets.size()) {
            String targetName = (String)this.targets.get(i);
            IAntTask task = generateCml.createAntTask("antcall");
            task.addAttribute("target", "generate-dkml");
            task = task.createAntTask("param");
            task.addAttribute("name", "srcProject");
            task.addAttribute("value", targetName);
            ++i;
        }
        IAntTarget generate = model.createAntTarget("generate-dkml");
        IAntTask task = generate.createAntTask("dkmlgenerate");
        task.addAttribute("srcProject", "${srcProject}");
        String contents = model.getContents();
        FileWriter fw = new FileWriter(this.antFile);
        fw.write(contents.toCharArray());
        fw.close();
        model.save();
    }

    private void getGenerateProjects(AntModel model, String project) throws Exception {
        if (this.hasCmlFiles(project)) {
            this.targets.add(project);
        }
    }

    private boolean hasCmlFiles(String projectName) throws CoreException {
        this.dkmlFiles = new ArrayList();
        this.findCmlFilesInProject(projectName);
        return this.dkmlFiles.size() > 0;
    }
}

