/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.ant;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.soda.devicekit.generator.model.IGeneratorModel;
import org.eclipse.soda.devicekit.generator.model.ant.AntModel;
import org.eclipse.soda.devicekit.generator.save.IFileSaver;

public class JUnitSaver
implements IFileSaver {
    private IJavaProject project;

    public JUnitSaver(IJavaProject project) {
        this.project = project;
    }

    private IFolder getSaveFolder() {
        try {
            IResource[] resources = this.project.getProject().members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFolder && resources[i].getName().toLowerCase().indexOf("junit") > 0) {
                    return (IFolder)resources[i];
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public Object organize(IGeneratorModel object) throws Exception {
        return null;
    }

    public Object save(IGeneratorModel object) throws Exception {
        if (object instanceof AntModel) {
            return this.save((AntModel)object);
        }
        return null;
    }

    public Object save(AntModel model) throws Exception {
        IFolder folder = this.getSaveFolder();
        if (folder != null) {
            IFile file = folder.getFile(model.getFileName());
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream(model.getContents().getBytes()), false, null);
            } else {
                file.setContents((InputStream)new ByteArrayInputStream(model.getContents().getBytes()), false, true, null);
            }
            return file;
        }
        return null;
    }
}

