/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.build;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.soda.devicekit.generator.constants.BundleIds;
import org.eclipse.soda.devicekit.generator.model.AbstractDkGenerator;
import org.eclipse.soda.devicekit.generator.model.IGeneratorModel;
import org.eclipse.soda.devicekit.generator.save.IFileSaver;
import org.eclipse.soda.devicekit.util.CoreUtility;
import org.eclipse.soda.devicekit.util.SortedArrayList;
import org.osgi.framework.Bundle;

public class BuildModel
implements IGeneratorModel {
    private IFileSaver buildSaver;
    private AbstractDkGenerator generator;
    private Properties buildProperties = new Properties();

    public BuildModel(AbstractDkGenerator generator) {
        this.generator = generator;
    }

    public void addAdditionalBundles(String bundleId) {
        Object object = this.buildProperties.get("additional.bundles");
        if (object instanceof List) {
            ((List)object).add(bundleId);
        } else {
            SortedArrayList value = new SortedArrayList();
            value.add(bundleId);
            this.buildProperties.put("additional.bundles", value);
        }
    }

    public void addBinIncludes(String source) {
    }

    public void addOutput(String source) {
    }

    public void addPackage(String packageName) {
        block8: {
            try {
                String bundleIds = BundleIds.getString(packageName);
                if (bundleIds != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(bundleIds, ", ");
                    while (stringTokenizer.hasMoreTokens()) {
                        this.addAdditionalBundles(stringTokenizer.nextToken());
                    }
                } else {
                    Bundle bundle = Platform.getBundle((String)packageName);
                    if (bundle != null) {
                        this.addAdditionalBundles(packageName);
                        return;
                    }
                    IPackageFragment packageFragment = CoreUtility.getPackage(packageName);
                    if (packageFragment != null) {
                        String bundleId = packageFragment.getJavaProject().getElementName();
                        this.addAdditionalBundles(bundleId);
                    }
                }
            }
            catch (Exception exception) {
                Bundle bundle = Platform.getBundle((String)packageName);
                if (bundle != null) {
                    this.addAdditionalBundles(packageName);
                    return;
                }
                IPackageFragment packageFragment = CoreUtility.getPackage(packageName);
                if (packageFragment == null) break block8;
                String bundleId = packageFragment.getJavaProject().getElementName();
                this.addAdditionalBundles(bundleId);
            }
        }
    }

    public void addPackages(List packages) {
        Iterator iterator = packages.iterator();
        while (iterator.hasNext()) {
            try {
                String packageName = String.valueOf(iterator.next());
                this.addPackage(packageName);
            }
            catch (Exception exception) {}
        }
    }

    public void addSource(String source) {
    }

    public void addSrcIncludes(String source) {
    }

    public List getAdditionalBundles() {
        return (List)this.buildProperties.get("additional.bundles");
    }

    public Properties getBuildProperties() {
        return this.buildProperties;
    }

    public IFileSaver getBuildSaver() {
        return this.buildSaver;
    }

    public String getContents() {
        return null;
    }

    public Map getTemplateVariables() {
        if (this.generator == null) {
            return new HashMap();
        }
        return this.generator.getTemplateVariables();
    }

    public void merge(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object value = map.get(key);
            Object currentValue = this.buildProperties.get(key);
            if (currentValue == null) {
                this.buildProperties.put(key, value);
                continue;
            }
            if (!(currentValue instanceof List)) continue;
            List currentList = (List)currentValue;
            if (value instanceof List) {
                List valueList = (List)value;
                currentList.addAll(valueList);
                continue;
            }
            StringTokenizer tokenizer = new StringTokenizer(String.valueOf(value), ",");
            while (tokenizer.hasMoreTokens()) {
                currentList.add(tokenizer.nextToken());
            }
        }
    }

    public Object save() throws Exception {
        if (this.buildSaver != null) {
            return this.buildSaver.save(this);
        }
        return null;
    }

    public void setBuildProperties(Properties buildProperties) {
        this.buildProperties = buildProperties;
    }

    public void setBuildSaver(IFileSaver buildSaver) {
        this.buildSaver = buildSaver;
    }
}

