/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.html;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitTagConstants;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.CommandElement;
import org.eclipse.soda.devicekit.generator.model.elements.ControlItem;
import org.eclipse.soda.devicekit.generator.model.elements.DataElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.MeasurementElement;
import org.eclipse.soda.devicekit.generator.model.elements.ProfileElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.template.TemplateInputStream;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class ExternalHtmlGenerator
implements Comparator {
    protected TagElement element;
    protected IFile dkmlFile;
    protected DeviceKitTagModel dkFileModel;
    public HashMap variables = new HashMap();
    protected PrintWriter printWriter = null;
    protected StringWriter stringWriter = new StringWriter(4096);
    static /* synthetic */ Class class$0;

    public int compare(Object o1, Object o2) {
        String e1 = ((TagElement)o1).getExternalId();
        String e2 = ((TagElement)o2).getExternalId();
        if (e1 != null && e2 != null) {
            return e1.compareTo(e2);
        }
        return 0;
    }

    public ExternalHtmlGenerator(TagElement element, DeviceKitTagModel dkFileModel, IFile dkmlFile) {
        this.element = element;
        this.dkFileModel = dkFileModel;
        this.dkmlFile = dkmlFile;
    }

    public void addVariable(String key, String value) {
        this.getVariables().put(key, value);
    }

    public StringWriter createStringWriter() {
        return new StringWriter(40960);
    }

    public boolean generate() {
        ProfileElement mainElement;
        Vector parents;
        if (this.element instanceof ProfileElement && (parents = (mainElement = (ProfileElement)this.element).getAllChildrenWithTagCode(83)).size() == 0) {
            IProject project = this.dkmlFile.getProject();
            IFolder folder = project.getFolder("doc");
            if (!folder.exists()) {
                try {
                    folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            this.addCommonVariables(mainElement);
            this.template("external.txt");
            String mainDescription = mainElement.getDescription();
            if (mainDescription != null) {
                this.println("<p>");
                this.println(mainDescription);
                this.println("</p>");
            }
            this.template("table.txt");
            String name = this.element.getId();
            List list = this.getControlElements(mainElement);
            ControlItem[] elements = new ControlItem[list.size()];
            elements = list.toArray(elements);
            Arrays.sort(elements, this);
            int i = 0;
            while (i < elements.length) {
                ControlItem element = elements[i];
                StringBuffer baseName = new StringBuffer(1024);
                baseName.append("<i><a href=\"#prefix\">prefix</a>/</i><b>");
                baseName.append(element.getExternalId());
                baseName.append("</b>");
                this.println("\t<tr>");
                this.print("\t<td valign=\"top\">");
                this.print(baseName.toString());
                this.println("</td>");
                this.print("\t<td valign=\"top\">");
                String ctype = "";
                int rowspan = 2;
                if (element instanceof MeasurementElement) {
                    MeasurementElement measurementElement = (MeasurementElement)element;
                    ctype = ((MeasurementElement)element).getMeasurementType();
                    if (measurementElement.isExecuteRead()) {
                        ++rowspan;
                    }
                    if (measurementElement.isExecuteWrite()) {
                        ++rowspan;
                    }
                } else if (element instanceof CommandElement) {
                    ControlItem commandElement = element;
                    ctype = commandElement.getAttribute("type");
                }
                if (ctype == null) {
                    ctype = "";
                }
                this.print(ctype);
                this.println("</td>");
                this.print("\t<td valign=\"top\" rowspan=\"");
                this.print(String.valueOf(rowspan));
                this.print("\">");
                String description = element.getDescription();
                if (description == null) {
                    description = "";
                }
                this.print(description);
                this.println("</td>");
                this.println("\t</tr>");
                int type = element.getTagCode();
                switch (type) {
                    case 1: 
                    case 19: {
                        this.generateChild(element, baseName.toString(), description, "execute", ctype);
                        break;
                    }
                    case 2: {
                        MeasurementElement measurementElement = (MeasurementElement)element;
                        this.generateChild(element, baseName.toString(), description, "get", "");
                        if (measurementElement.isExecuteRead()) {
                            this.generateChild(element, baseName.toString(), description, "read", "");
                        }
                        if (!measurementElement.isExecuteWrite()) break;
                        this.generateChild(element, baseName.toString(), description, "write", ctype);
                        break;
                    }
                    case 3: {
                        this.generateChild(element, baseName.toString(), description, "trigger", ctype);
                    }
                }
                this.println("\t<tr/>");
                ++i;
            }
            this.println("\t</table>");
            this.template("table.txt");
            List dlist = this.getDataElements(mainElement);
            DataElement[] delements = new DataElement[dlist.size()];
            delements = dlist.toArray(delements);
            Arrays.sort(delements, this);
            int i2 = 0;
            while (i2 < delements.length) {
                DataElement element = delements[i2];
                String externalId = element.getExternalId();
                if (externalId != null) {
                    this.println("\t<tr>");
                    this.print("\t<td valign=\"top\">");
                    this.print(element.getExternalId());
                    this.println("</td>");
                    String ctype = element.getAttribute("type");
                    this.print("<td>");
                    if (ctype == null) {
                        ctype = "";
                    }
                    this.print(ctype);
                    this.print("<td>");
                    String description = element.getDescription();
                    if (description == null) {
                        description = "";
                    }
                    this.print(description);
                    this.println("</td>");
                    this.println("\t</tr>");
                }
                ++i2;
            }
            this.template("end.txt");
            IFile file = folder.getFile(String.valueOf(name) + "External.html");
            this.save(file, this.getStringWriter());
        }
        return true;
    }

    protected void generateChild(TagElement element2, String baseName, String description, String operation, String type) {
        this.println("\t<tr>");
        this.print("\t<td valign=\"top\">");
        this.print(baseName);
        this.print('/');
        this.print("<a href=\"#");
        this.print(operation);
        this.println("\">");
        this.print(operation);
        this.println("</a></td>");
        this.print("\t<td valign=\"top\">");
        this.print(type);
        this.print("</td>");
        this.println("\t</tr>");
    }

    public IFile getDkmlFile() {
        return this.dkmlFile;
    }

    public TagElement getElement() {
        return this.element;
    }

    public PrintWriter getPrintWriter() {
        if (this.printWriter == null) {
            this.stringWriter = this.createStringWriter();
            this.printWriter = new PrintWriter(this.stringWriter);
        }
        return this.printWriter;
    }

    public StringWriter getStringWriter() {
        return this.stringWriter;
    }

    public HashMap getVariables() {
        return this.variables;
    }

    public void print(char character) {
        this.getPrintWriter().print(character);
    }

    public void print(String string) {
        this.getPrintWriter().print(string);
    }

    public void println(String string) {
        this.getPrintWriter().println(string);
    }

    public void save(IFile file, StringWriter writer) {
        String name = file.getName();
        try {
            String data = writer.getBuffer().toString();
            if (data != null) {
                ByteArrayInputStream source = new ByteArrayInputStream(data.getBytes());
                if (file.exists()) {
                    file.setContents((InputStream)source, true, true, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            writer.close();
            this.stringWriter = null;
            this.printWriter = null;
        }
        catch (Exception exception) {
            System.out.println(name);
            System.out.println(exception);
            exception.printStackTrace(System.out);
        }
    }

    public void setDkmlFile(IFile dkmlFile) {
        this.dkmlFile = dkmlFile;
    }

    public void setElement(TagElement element) {
        this.element = element;
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    public void setStringWriter(StringWriter stringWriter) {
        this.stringWriter = stringWriter;
    }

    public void setVariables(HashMap variables) {
        this.variables = variables;
    }

    protected void addCommonVariables(MainTagElement element) {
        this.variables.put("Name", element.getId());
        this.variables.put("provider", element.getProvider());
        this.variables.put("vendors", element.getVendors());
        this.variables.put("vendor", element.getVendor());
        this.variables.put("year", Integer.toString(Calendar.getInstance().get(1)));
        this.variables.put("years", Integer.toString(Calendar.getInstance().get(1)));
    }

    protected List getControlElements(MainTagElement mainElement) {
        Vector<TagElement> results = new Vector<TagElement>();
        Vector elements = mainElement.getAllChildrenWithTagCodes(new int[]{1, 19, 2, 3, 4}, false);
        int i = 0;
        while (i < elements.size()) {
            TagElement element = (TagElement)elements.elementAt(i);
            String id = element.getId();
            if (id != null && id.length() > 0 && (element.getTagCode() == 1 || element.getTagCode() == 19 || element.getTagCode() == 2 || element.getTagCode() == 3 || element.getTagCode() == 4 && !element.isMessageClassElement())) {
                results.addElement(element);
            }
            ++i;
        }
        return results;
    }

    protected List getDataElements(MainTagElement mainElement) {
        Vector elements = mainElement.getAllChildrenWithTagCodes(new int[]{76}, DeviceKitTagConstants.ALL_PARENT_CONTROLS);
        return elements;
    }

    public void template(String template) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.html.ExternalHtmlGenerator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            InputStream stream = clazz.getResourceAsStream(template);
            String templateData = DeviceKitUtilities.getStringFromStream(stream);
            TemplateInputStream tis = new TemplateInputStream(new ByteArrayInputStream(templateData.getBytes()));
            tis.setEntities(this.getVariables());
            this.println(DeviceKitUtilities.getStringFromStream(tis));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

