/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.html;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class PackageHtmlGenerator {
    private IPackageFragment packageFragment;
    private Hashtable map = new Hashtable();

    public PackageHtmlGenerator(IPackageFragment packageFragment) {
        this.setPackageFragment(packageFragment);
    }

    public void generate() {
        Map map = GeneratorTemplates.getTemplateVariables(-1);
        map.put("package", this.getPackageFragment().getElementName());
        StringBuffer buffer = new StringBuffer();
        map.put("contents", buffer.toString());
        this.getPackageFragment().getResource().getRawLocation();
        IJavaProject javaProject = this.getJavaProject();
        String name = String.valueOf(this.getPackageFragment().getResource().getProjectRelativePath().toPortableString()) + "/package.html";
        IFile file = javaProject.getProject().getFile(name);
        map.put("project", javaProject.getElementName());
        String contents = GeneratorTemplates.getPackageHtml(map);
        this.save(file, contents);
    }

    public IJavaProject getJavaProject() {
        return this.getJavaProject((IJavaElement)this.getPackageFragment());
    }

    public IJavaProject getJavaProject(IJavaElement javaElement) {
        if (javaElement instanceof IJavaProject || javaElement == null) {
            return (IJavaProject)javaElement;
        }
        return this.getJavaProject(javaElement.getParent());
    }

    public Hashtable getMap() {
        return this.map;
    }

    public IPackageFragment getPackageFragment() {
        return this.packageFragment;
    }

    public void save(IFile file, String data) {
        try {
            if (data != null) {
                ByteArrayInputStream source = new ByteArrayInputStream(data.getBytes());
                if (file.exists()) {
                    InputStream stream = file.getContents();
                    String oldContents = DeviceKitUtilities.getStringFromStream(stream);
                    stream.close();
                    if (!oldContents.equals(data)) {
                        file.setContents((InputStream)source, true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                } else {
                    file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setMap(Hashtable map) {
        this.map = map;
    }

    public void setPackageFragment(IPackageFragment packageFragment) {
        this.packageFragment = packageFragment;
    }
}

