/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.internal.model.xml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.soda.devicekit.generator.internal.model.xml.KeyPair;
import org.eclipse.soda.devicekit.generator.internal.print.xml.XmlElementPrinter;
import org.eclipse.soda.devicekit.generator.model.xml.IXmlElement;

public class XmlElement
implements IXmlElement {
    private String data;
    private String tag;
    private List attributes;
    private List elements;
    private List comments;

    public XmlElement(String tag) {
        this.tag = tag;
        this.attributes = new ArrayList();
        this.elements = new ArrayList();
        this.comments = new ArrayList();
    }

    public void addAttribute(String name, String value) {
        if (!this.hasAttribute(name)) {
            List attributes = this.getAttributes();
            KeyPair pair = new KeyPair(name, value);
            attributes.add(pair);
        }
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    public void addComments(String[] comments) {
        int i = 0;
        while (i < comments.length) {
            this.addComment(comments[i]);
            ++i;
        }
    }

    public IXmlElement addElement(String tag) {
        XmlElement element = new XmlElement(tag);
        this.getElements().add(element);
        return element;
    }

    public String getAttributeValue(String name) {
        List attributes = this.getAttributes();
        int i = 0;
        while (i < attributes.size()) {
            KeyPair pair = (KeyPair)attributes.get(i);
            if (pair.getKey().equals(name)) {
                return pair.getValue();
            }
            ++i;
        }
        return null;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public List getComments() {
        return this.comments;
    }

    public String getData() {
        return this.data;
    }

    public List getElements() {
        return this.elements;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean hasAttribute(String name) {
        String value = this.getAttributeValue(name);
        return value != null;
    }

    public String print() {
        return this.print(0);
    }

    public String print(int indentation) {
        return new XmlElementPrinter(this, indentation).getContents();
    }

    public void setComments(List comments) {
        this.comments = comments;
    }

    public void setData(String data) {
        this.data = data;
    }
}

