/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.internal.print.ant;

import java.util.Vector;
import org.eclipse.soda.devicekit.generator.internal.print.ant.AntPrinter;
import org.eclipse.soda.devicekit.generator.internal.print.ant.AntPropertyPrinter;
import org.eclipse.soda.devicekit.generator.internal.print.ant.AntTargetPrinter;
import org.eclipse.soda.devicekit.generator.internal.print.ant.AntTaskPrinter;
import org.eclipse.soda.devicekit.generator.model.ant.AntModel;
import org.eclipse.soda.devicekit.generator.model.ant.IAntElement;
import org.eclipse.soda.devicekit.generator.model.ant.IAntProperty;
import org.eclipse.soda.devicekit.generator.model.ant.IAntTarget;
import org.eclipse.soda.devicekit.generator.model.ant.IAntTask;

public class AntFilePrinter
extends AntPrinter {
    private AntModel model;

    public AntFilePrinter(AntModel model) {
        this.model = model;
    }

    protected AntModel getModel() {
        return this.model;
    }

    public void print() {
        this.printXmlHeader();
        this.printStartProject();
        this.printBody();
        this.printEndProject();
    }

    protected void printBody() {
        Vector elements = this.getModel().getElements();
        int i = 0;
        while (i < elements.size()) {
            if (i > 0) {
                this.printNewLine();
            }
            IAntElement element = (IAntElement)elements.elementAt(i);
            switch (element.getElementType()) {
                case 0: {
                    this.printProperty((IAntProperty)element);
                    break;
                }
                case 2: {
                    this.printTarget((IAntTarget)element);
                    break;
                }
                case 1: {
                    this.printTask((IAntTask)element);
                }
            }
            ++i;
        }
    }

    protected void printEndProject() {
        this.decrementIndent();
        this.printIndentation();
        this.printNewLine();
        this.endTag("project");
    }

    protected void printProperty(IAntProperty property) {
        AntPropertyPrinter printer = new AntPropertyPrinter(this.getCurrentIndentenation(), false, property);
        this.print(printer.getContents());
    }

    protected void printStartProject() {
        this.printIndentation();
        this.startTag("project");
        String defaultTarget = this.getModel().getDefaultTarget();
        String name = this.getModel().getProjectName();
        String baseDir = this.getModel().getBaseDir();
        if (name != null) {
            this.printAttribute("name", name);
        }
        this.printAttribute("default", defaultTarget);
        if (baseDir != null) {
            this.printAttribute("basedir", baseDir);
        }
        this.endTag();
        this.incrementIndent();
    }

    protected void printTarget(IAntTarget target) {
        AntTargetPrinter printer = new AntTargetPrinter(this.getCurrentIndentenation(), target);
        this.print(printer.getContents());
    }

    protected void printTask(IAntTask task) {
        AntTaskPrinter printer = new AntTaskPrinter(this.getCurrentIndentenation(), task);
        this.print(printer.getContents());
    }
}

