/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.internal.print.java;

import org.eclipse.soda.devicekit.generator.internal.print.java.JavaPrinter;
import org.eclipse.soda.devicekit.generator.model.java.IField;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.generator.utilty.NLSUtil;

public class FieldPrinter
extends JavaPrinter {
    private IField fField;

    public FieldPrinter(IField field) {
        this(field, 0);
    }

    public FieldPrinter(IField field, int indentation) {
        super(indentation);
        this.fField = field;
        this.printField();
    }

    protected void printField() {
        if (this.fField.getComment() != null && this.fField.getComment().length > 0) {
            this.printJavaDocComment(this.fField.getComment());
        }
        this.printFieldDeclaration();
    }

    private void printFieldDeclaration() {
        this.printWithIndent(this.fField.getIdentifiers());
        this.print(this.fField.getType());
        this.printSpace();
        this.print(this.fField.getName());
        String value = this.fField.getValue();
        if (value != null && value.trim().length() > 0) {
            this.printEquals();
            String[] valArray = DkUtilities.convertStringToArray(this.fField.getValue());
            if (valArray.length == 1) {
                this.print(this.fField.getValue());
                if (!this.fField.getValue().endsWith(";")) {
                    this.printEndStatement();
                }
                this.print(NLSUtil.printNLSS(this.fField.getValue()));
            } else {
                this.printNewLine();
                this.incrementIndent();
                int i = 0;
                while (i < valArray.length) {
                    this.printWithIndent(valArray[i]);
                    if (i == valArray.length - 1 && !valArray[i].endsWith(";")) {
                        this.printEndStatement();
                    }
                    this.print(NLSUtil.printNLSS(valArray[i]));
                    if (i < valArray.length - 1) {
                        this.printNewLine();
                    }
                    ++i;
                }
                this.decrementIndent();
            }
        } else {
            this.printEndStatement();
        }
        this.printNewLine();
    }
}

