/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.internal.print.java;

import org.eclipse.soda.devicekit.generator.internal.print.java.JavaPrinter;
import org.eclipse.soda.devicekit.generator.model.java.IJavaElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.save.java.JavaElementSorter;

public class TypePrinter
extends JavaPrinter {
    private IType fType;

    public TypePrinter(IType type) {
        this(type, 0);
    }

    public TypePrinter(IType type, int indentation) {
        super(indentation);
        this.fType = type;
        this.printType();
    }

    protected void printType() {
        if (this.fType.getComment() != null) {
            this.printJavaDocComment(this.fType.getComment());
        }
        this.printTypeDeclaration();
        this.printStartBlock();
        this.incrementIndent();
        this.printTypeBody();
        this.decrementIndent();
        this.printNewLine();
        this.printIndentation();
        this.printEndBlock();
    }

    private void printTypeBody() {
        this.printTypeInnerTypes();
        this.printTypeFields();
        this.printTypeMethods();
    }

    private void printTypeDeclaration() {
        this.printWithIndent(this.fType.getIdentifiers());
        if (this.fType.isClass()) {
            this.print("class");
        } else {
            this.print("interface");
        }
        this.printSpace();
        this.print(this.fType.getName());
        this.printSpace();
        if (this.fType.isClass() && this.fType.getSuperclass() != null) {
            this.print("extends");
            this.printSpace();
            this.print(this.fType.getSuperclass());
        }
        if (this.fType.getSuperInterfaces() != null && this.fType.getSuperInterfaces().length > 0) {
            this.printSpace();
            if (this.fType.isClass()) {
                this.print("implements");
            } else {
                this.print("extends");
            }
            String[] interfaces = this.fType.getSuperInterfaces();
            int lastComma = interfaces.length - 2;
            this.printSpace();
            int i = 0;
            while (i < interfaces.length) {
                this.printSpace();
                this.print(interfaces[i]);
                if (i <= lastComma) {
                    this.printComma();
                }
                ++i;
            }
        }
    }

    private void printTypeFields() {
        IJavaElement[] fields = this.fType.getFields();
        fields = new JavaElementSorter(this.fType.getSortOrder()).sort(fields);
        int i = 0;
        while (i < fields.length) {
            this.printNewLine();
            this.print(fields[i].print(this.getCurrentIndentenation()));
            ++i;
        }
    }

    private void printTypeInnerTypes() {
        IType[] types = this.fType.getTypes();
        int i = 0;
        while (i < types.length) {
            this.printNewLine();
            this.print(types[i].print(this.getCurrentIndentenation()));
            ++i;
        }
    }

    private void printTypeMethods() {
        IJavaElement[] constructors = this.fType.getConstructors();
        constructors = new JavaElementSorter(this.fType.getSortOrder()).sort(constructors);
        if (this.fType.isClass()) {
            int i = 0;
            while (i < constructors.length) {
                this.printNewLine();
                this.print(constructors[i].print(this.getCurrentIndentenation()));
                ++i;
            }
        }
        IJavaElement[] methods = this.fType.getNonConstructorMethods();
        methods = new JavaElementSorter(this.fType.getSortOrder()).sort(methods);
        int i = 0;
        while (i < methods.length) {
            this.printNewLine();
            this.print(methods[i].print(this.getCurrentIndentenation()));
            ++i;
        }
    }
}

