/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.internal.tools;

import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import org.eclipse.soda.devicekit.generator.internal.tools.Generate;
import org.eclipse.soda.devicekit.generator.utilty.SortedSet;

public class GenerateTemplateFiles
extends Generate {
    private String pluginId = "";
    private SortedSet set = new SortedSet();

    public static void main(String[] args) {
        GenerateTemplateFiles generateTemplateFiles = new GenerateTemplateFiles();
        generateTemplateFiles.process();
    }

    protected File getDestdir() {
        return new File("templates");
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public boolean isIcon(String name) {
        return name.endsWith(".gif") || name.endsWith(".jpg") || name.endsWith(".jpeg");
    }

    public void process() {
        File file = new File("templates-directory");
        File[] list = file.listFiles();
        int i = 0;
        while (i < list.length) {
            this.processMain(list[i]);
            ++i;
        }
    }

    public void processDirectory(File file, String prefix) {
        String name = file.getName();
        if (!"CVS".equals(name)) {
            System.out.println("directory " + name);
            File[] list = file.listFiles();
            int i = 0;
            while (i < list.length) {
                if (list[i].isDirectory()) {
                    String nameNew = list[i].getName();
                    String newPrefix = prefix.length() == 0 ? String.valueOf(nameNew) + '/' : String.valueOf(prefix) + nameNew + '/';
                    this.processDirectory(list[i], newPrefix);
                } else {
                    this.processFile(list[i], prefix);
                }
                ++i;
            }
        }
    }

    public void processFile(File file, String prefix) {
        String name = file.getName();
        String fullName = String.valueOf(prefix) + name;
        this.set.add(fullName);
        if (this.isIcon(name)) {
            return;
        }
        this.println("");
        this.print("\t<template name=\"");
        this.print(name);
        this.println("\"");
        this.println("\t\tdescription=\"%Templates.plugin\"");
        this.print("\t\tid=\"");
        this.print(this.getPluginId());
        this.print('/');
        this.print(fullName);
        this.println("\"");
        this.println("\t\tcontext=\"org.eclipse.soda.devicekit.generator.templates.contexttype\">");
        this.print("<![CDATA[");
        try {
            FileInputStream fin = new FileInputStream(file);
            String data = new String(this.readData(fin));
            char[] dataChar = data.toCharArray();
            int i = 0;
            while (i < dataChar.length) {
                char character = dataChar[i];
                if (character == '%') {
                    this.print("${percent}");
                } else {
                    this.print(character);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.println("]]>");
        this.println("\t</template>");
    }

    public void processFileList(SortedSet list) {
        this.println("");
        this.print("\t<template name=\"");
        this.print("");
        this.println("\"");
        this.println("\t\tdescription=\"%Templates.plugin\"");
        this.print("\t\tid=\"");
        this.print(this.getPluginId());
        this.println("\"");
        this.println("\t\tcontext=\"org.eclipse.soda.devicekit.generator.templates.contexttype\">");
        this.print("<![CDATA[");
        try {
            Enumeration enumeration = list.elements();
            boolean first = true;
            while (enumeration.hasMoreElements()) {
                if (!first) {
                    this.print(',');
                } else {
                    first = false;
                }
                this.print(String.valueOf(enumeration.nextElement()));
            }
            this.println("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.println("]]>");
        this.println("\t</template>");
    }

    public void processMain(File file) {
        String name = file.getName();
        if (!"CVS".equals(name)) {
            System.out.println("main " + file.getName());
            this.set = new SortedSet();
            StringBuffer buffer = new StringBuffer(4096);
            buffer.append("org.eclipse.soda.devicekit.generator.templates.");
            buffer.append(name.replace('-', '.'));
            this.setPluginId(buffer.toString());
            this.printXmlHeader();
            this.println("<templates>");
            this.processDirectory(file, "");
            this.processFileList(this.set);
            String outputName = String.valueOf(name) + ".xml";
            this.println("</templates>");
            this.save(outputName, this.getStringWriter());
        }
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }
}

