/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.manifest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Manifest;
import org.eclipse.soda.devicekit.generator.GeneratorPlugin;
import org.eclipse.soda.devicekit.generator.manifest.ManifestPrinter;
import org.eclipse.soda.devicekit.generator.model.IGeneratorModel;
import org.eclipse.soda.devicekit.generator.save.IFileSaver;
import org.eclipse.soda.devicekit.generator.util.DeviceKitEclipseUtilities;

public class ManifestModel
implements IGeneratorModel {
    private boolean isAbstract;
    private Hashtable keys;
    private IFileSaver fSaver;
    protected Properties pluginProperties = new Properties();
    private HashMap exportedPackages = new HashMap();
    private HashMap requiredBundle = new HashMap();
    private String vendors;

    public ManifestModel() {
        this.keys = new Hashtable();
    }

    protected Enumeration getKeys() {
        return this.keys.keys();
    }

    public String[] getKeyMultiValue(String key) {
        Object value = this.keys.get(key);
        if (value != null) {
            String[] castedValue = (String[])value;
            return castedValue;
        }
        return null;
    }

    public Vector getKeyMultiValueAsVector(String key) {
        Vector<String> vectorResult = new Vector<String>();
        String[] result = this.getKeyMultiValue(key);
        if (result == null) {
            return vectorResult;
        }
        int i = 0;
        while (i < result.length) {
            vectorResult.add(result[i]);
            ++i;
        }
        return vectorResult;
    }

    private void addKeyMultiValue(String key, String value) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        String[] currItems = this.getKeyMultiValue(key);
        if (currItems == null) {
            this.setKeyMultiValue(key, new String[]{value});
        } else {
            int i = 0;
            while (i < currItems.length) {
                if (currItems[i].equals(value)) {
                    return;
                }
                ++i;
            }
            String[] newValue = new String[currItems.length + 1];
            System.arraycopy(currItems, 0, newValue, 0, currItems.length);
            newValue[newValue.length - 1] = value;
            this.setKeyMultiValue(key, newValue);
        }
    }

    private void setKeyMultiValue(String key, String[] value) {
        this.keys.put(key, value);
    }

    public void addCategory(String category) {
        this.addKeyMultiValue("Bundle-Category", category);
    }

    public void addExportedPackage(String exportedPackage) {
        String texportedPackage = exportedPackage;
        if (!this.exportedPackages.containsKey(texportedPackage)) {
            this.exportedPackages.put(texportedPackage, texportedPackage);
            String version = this.getVersion();
            if (texportedPackage != null && version != null) {
                if (version.endsWith(".qualifier")) {
                    version = version.substring(0, version.length() - 10);
                }
                texportedPackage = GeneratorPlugin.useEclipse32Names() ? String.valueOf(texportedPackage) + "; version=\"" + version + '\"' : String.valueOf(texportedPackage) + "; specification-version=" + version;
            }
            this.addKeyMultiValue("Export-Package", texportedPackage);
        }
    }

    public void addExportedService(String exportedService) {
        this.addKeyMultiValue("Export-Service", exportedService);
    }

    public void addImportPackage(String importedPackage) {
        if (!importedPackage.startsWith("java.")) {
            String last = DeviceKitEclipseUtilities.stripPackage(importedPackage);
            if (Character.isUpperCase(last.charAt(0))) {
                throw new RuntimeException(importedPackage);
            }
            if (this.exportedPackages.get(importedPackage) == null) {
                this.addKeyMultiValue("Import-Package", importedPackage);
            }
        }
    }

    public void addRequiredBundle(String bundleId) {
        if (this.exportedPackages.get(bundleId) == null) {
            this.addKeyMultiValue("Require-Bundle", String.valueOf(bundleId) + ";resolution:=optional");
        }
    }

    public void addImportService(String importedService) {
        this.addKeyMultiValue("Import-Service", importedService);
    }

    public String[] getKeysArray() {
        Set set = this.keys.keySet();
        int size = set.size();
        Object[] list = new String[size];
        list = set.toArray(list);
        Arrays.sort(list);
        return list;
    }

    public String[] getKeyValue(String key) {
        Object o;
        if (key != null && (o = this.keys.get(key)) != null) {
            if (o instanceof String[]) {
                return this.getKeyMultiValue(key);
            }
            return new String[]{(String)o};
        }
        return null;
    }

    public String getBundleActivator() {
        String[] result = this.getKeyValue("Bundle-Activator");
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public String getBundleName() {
        String[] result = this.getKeyValue("Bundle-Name");
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public String getSymbolicBundleName() {
        String[] result = this.getKeyValue("Bundle-SymbolicName");
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public Vector getCategories() {
        return this.getKeyMultiValueAsVector("Bundle-Category");
    }

    public String getCopyright() {
        String[] result = this.getKeyValue("Bundle-Copyright");
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public String getContents() {
        return new ManifestPrinter(this).getContents();
    }

    public Properties getPluginProperties() {
        this.pluginProperties.put("description", this.getDescription());
        this.pluginProperties.put("name", this.getBundleName());
        this.pluginProperties.put("copyright", this.getCopyright());
        return this.pluginProperties;
    }

    public String getDescription() {
        String[] result = this.getKeyValue("Bundle-Description");
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public Vector getExportedPackages() {
        return this.getKeyMultiValueAsVector("Export-Package");
    }

    public Vector getExportedServices() {
        if (this.isAbstract) {
            return new Vector();
        }
        return this.getKeyMultiValueAsVector("Export-Service");
    }

    public Vector getImportedPackages() {
        return this.getKeyMultiValueAsVector("Import-Package");
    }

    public Vector getImportedServices() {
        return this.getKeyMultiValueAsVector("Import-Service");
    }

    public String getVendor() {
        String[] result = this.getKeyValue("Bundle-Vendor");
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public String getVendors() {
        if (this.vendors != null) {
            return this.vendors;
        }
        return this.getVendor();
    }

    public String getVersion() {
        String[] result = this.getKeyValue("Bundle-Version");
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public Object save() throws Exception {
        if (this.fSaver != null) {
            return this.fSaver.save(this);
        }
        return null;
    }

    public Object organize() throws Exception {
        if (this.fSaver != null) {
            return this.fSaver.organize(this);
        }
        return null;
    }

    public void setBundleActivator(String bundleActivator) {
        this.setKeyValue("Bundle-Activator", bundleActivator);
    }

    public void setBundleName(String bundleName) {
        this.setKeyValue("Bundle-Name", bundleName);
    }

    public void setSymbolicBundleName(String bundleName) {
        this.setKeyValue("Bundle-SymbolicName", bundleName);
    }

    public void setCopyright(String copyright) {
        this.setKeyValue("Bundle-Copyright", copyright);
    }

    public void setDescription(String description) {
        if (description == null) {
            this.setKeyValue("Bundle-Description", "");
        } else {
            int index = description.indexOf(46);
            if (index < 0) {
                this.setKeyValue("Bundle-Description", description);
            } else {
                this.setKeyValue("Bundle-Description", description.substring(0, index));
            }
        }
    }

    public void setSaver(IFileSaver saver) {
        this.fSaver = saver;
    }

    public void setVendor(String vendor) {
        this.setKeyValue("Bundle-Vendor", vendor);
    }

    public void setVersion(String version) {
        this.setKeyValue("Bundle-Version", version);
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setKeyValue(String key, String value) {
        if (key != null && value != null) {
            this.keys.put(key, value);
        }
    }

    public Manifest getManifest() throws IOException {
        Manifest manifest;
        block2: {
            ByteArrayInputStream stream = null;
            try {
                String contents = this.getContents();
                stream = new ByteArrayInputStream(contents.getBytes());
                manifest = new Manifest(stream);
                Object var3_4 = null;
                if (stream == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var3_5 = null;
                    if (stream == null) break block3;
                    ((InputStream)stream).close();
                    stream = null;
                }
                throw throwable;
            }
            ((InputStream)stream).close();
            stream = null;
        }
        return manifest;
    }

    public void setBundleLocalization(String bndleLocalization) {
        this.setKeyValue("Bundle-Localization", bndleLocalization);
    }

    public String getBundleLocalization() {
        String[] result = this.getKeyValue("Bundle-Localization");
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public HashMap getRequiredBundle() {
        return this.requiredBundle;
    }

    public void setRequiredBundle(HashMap requiredBundle) {
        this.requiredBundle = requiredBundle;
    }

    public void setVendors(String vendors) {
        this.vendors = vendors;
    }
}

