/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.manifest;

import java.util.Arrays;
import org.eclipse.soda.devicekit.generator.manifest.ManifestModel;
import org.eclipse.soda.devicekit.generator.print.Printer;

public class ManifestPrinter
extends Printer {
    private ManifestModel fModel;

    public ManifestPrinter(ManifestModel model) {
        this.fModel = model;
        this.printManifest();
    }

    protected ManifestModel getModel() {
        return this.fModel;
    }

    private void printKeyValuePair(String key, String[] value) {
        if (value != null && value.length > 0 && value[0].trim().length() > 0) {
            Arrays.sort(value);
            this.print(key);
            this.print(':');
            int i = 0;
            while (i < value.length) {
                if (i != 0) {
                    this.println(',');
                }
                this.print(' ');
                this.print(value[i]);
                ++i;
            }
            this.println();
        }
    }

    private void printKeys() {
        String[] keys = this.fModel.getKeysArray();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            if (!"Export-Service".equals(key) && !"Import-Service".equals(key)) {
                if ("Bundle-Copyright".equals(key) || "Bundle-Description".equals(key) || "Bundle-Name".equals(key) || "Bundle-Vendor".equals(key)) {
                    String pvalue = "%" + key.toLowerCase().replace('-', '.');
                    this.printKeyValuePair(key, new String[]{pvalue});
                } else {
                    String[] value = this.fModel.getKeyValue(key);
                    this.printKeyValuePair(key, value);
                }
            }
            ++i;
        }
    }

    protected void printManifest() {
        this.println("Manifest-Version: 1.0");
        this.printKeys();
    }
}

