/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.messageanalyzer;

import org.eclipse.soda.devicekit.generator.messageanalyzer.ControlMessage;
import org.eclipse.soda.devicekit.generator.messageanalyzer.MessageStatus;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class ControlMessageAnalyzer {
    private static final int ON = 1;
    private static final int OFF = 0;
    private int longMessage;
    private int careAboutLength;
    private double singlePercent;
    private double bound = 0.1;
    private ControlMessage[] messages;
    private MessageStatus ms;

    public ControlMessageAnalyzer(ControlMessage[] messages, int careAboutLength) {
        this.messages = messages;
        this.careAboutLength = careAboutLength;
        this.ms = new MessageStatus();
    }

    public MessageStatus analyze() {
        this.longMessage = this.getLongestMessage();
        if (this.careAboutLength > this.longMessage) {
            this.careAboutLength = this.longMessage;
        }
        this.careAboutLength *= 8;
        this.analyzeMessageLength();
        this.analyzeMessageBytes();
        return this.ms;
    }

    private void analyzeMessageBits(int[] bitCount) {
        System.out.println("\n\n");
        if (this.singlePercent > this.bound) {
            this.bound = this.singlePercent;
        }
        int i = 0;
        while (i < this.messages.length) {
            ControlMessage cm = this.messages[i];
            int[] bits = cm.getBits();
            int byteCount = 0;
            int byteMultiplier = bits.length / 8;
            double cutOffPercent = 0.2222222222222222 * (double)byteMultiplier;
            int j = 0;
            while (j < bitCount.length) {
                if (j % 8 == 0 && j > 0) {
                    int byteIndex;
                    int byteWeight;
                    double percent = 0.0;
                    if (byteCount > 0) {
                        percent = new Integer(byteCount).doubleValue() / 36.0;
                    }
                    if ((percent = (double)(byteWeight = bits.length / 8 - (byteIndex = j / 8)) * percent) > cutOffPercent) {
                        System.out.println("Message " + cm.getControlId() + " byte position " + (j - 1) / 8 + "(" + cm.getCommonLengthBytes()[(j - 1) / 8] + ")" + " seems to be invalid.");
                    }
                    byteCount = 0;
                }
                int weight = 8 - j % 8;
                if (bitCount[j] != this.messages.length && bitCount[j] > 0) {
                    double percentOn = new Integer(bitCount[j]).doubleValue() / (double)this.messages.length;
                    if (bits[j] == 0) {
                        if (100.0 - percentOn <= this.bound && j < this.careAboutLength && j / 8 < this.messages[i].getByteLength()) {
                            byteCount += weight;
                        }
                    } else if (percentOn <= this.bound && j < this.careAboutLength && j / 8 < this.messages[i].getByteLength()) {
                        byteCount += weight;
                    }
                }
                ++j;
            }
            ++i;
        }
        System.out.println("\n\n");
    }

    private void analyzeMessageBytes() {
        int[] bitList = new int[this.longMessage * 8];
        int i = 0;
        while (i < bitList.length) {
            bitList[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.messages.length) {
            byte[] bytes = this.messages[i].getBytes();
            if (bytes.length < this.longMessage) {
                bytes = DeviceKitUtilities.growByteArray(bytes, this.longMessage, (byte)0);
            }
            this.messages[i].setCommonLengthBytes(bytes);
            int j = 0;
            while (j < bytes.length) {
                byte curr = bytes[j];
                int k = 0;
                while (k < 8) {
                    if ((curr & 0x80) == 128) {
                        this.messages[i].setBit(j * 8 + k, 1);
                        bitList[j * 8 + k] = bitList[j * 8 + k] + 1;
                    } else {
                        this.messages[i].setBit(j * 8 + k, 0);
                    }
                    curr = (byte)(curr << 1);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.analyzeMessageBits(bitList);
    }

    private void analyzeMessageLength() {
        int offset;
        this.ms.setMaxLength(this.longMessage);
        int[] lengths = new int[this.longMessage];
        int i = 0;
        while (i < lengths.length) {
            lengths[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.messages.length) {
            offset = this.messages[i].getByteLength();
            int n = offset - 1;
            int n2 = lengths[n] + 1;
            lengths[n] = n2;
            lengths[offset - 1] = n2;
            ++i;
        }
        if (this.messages.length > 0) {
            this.singlePercent = 1.0 / (double)this.messages.length;
            if (this.singlePercent > this.bound) {
                this.bound = this.singlePercent;
            }
        } else {
            this.singlePercent = 0.0;
        }
        i = 0;
        while (i < this.messages.length) {
            offset = this.messages[i].getByteLength();
            double dOffset = new Integer(lengths[offset - 1]).doubleValue();
            double percentage = dOffset / (double)this.messages.length;
            this.messages[i].setLengthPercentage(percentage);
            this.ms.addLengthStatus(offset - 1, percentage);
            if (percentage <= this.bound) {
                this.ms.addLengthOffender(this.messages[i].getLengthPercentage(), this.messages[i]);
            }
            ++i;
        }
    }

    private int getLongestMessage() {
        int lm = -1;
        int i = 0;
        while (i < this.messages.length) {
            if (this.messages[i].getByteLength() > lm) {
                lm = this.messages[i].getByteLength();
            }
            ++i;
        }
        return lm;
    }
}

