/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.soda.devicekit.generator.GeneratorPlugin;
import org.eclipse.soda.devicekit.generator.build.BuildModel;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.constants.Types;
import org.eclipse.soda.devicekit.generator.manifest.ManifestModel;
import org.eclipse.soda.devicekit.generator.metadata.DeviceKitMetaDataException;
import org.eclipse.soda.devicekit.generator.metadata.MetaDataUtility;
import org.eclipse.soda.devicekit.generator.metadata.model.CustomInfo;
import org.eclipse.soda.devicekit.generator.metadata.model.CustomManifestInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.CustomTypeInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.FieldInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.metadata.model.MethodInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.TypeInformation;
import org.eclipse.soda.devicekit.generator.model.DeviceKitGenerator;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.EscPropertiesModel;
import org.eclipse.soda.devicekit.generator.model.IDkGenerator;
import org.eclipse.soda.devicekit.generator.model.NewCodeGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.CustomParameter;
import org.eclipse.soda.devicekit.generator.model.elements.RootElement;
import org.eclipse.soda.devicekit.generator.model.elements.SpecElement;
import org.eclipse.soda.devicekit.generator.model.elements.SpecReferenceElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.CodeUtilities;
import org.eclipse.soda.devicekit.generator.model.java.IField;
import org.eclipse.soda.devicekit.generator.model.java.IMethod;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.model.java.JavaFileModel;
import org.eclipse.soda.devicekit.generator.model.java.JavaModelException;
import org.eclipse.soda.devicekit.generator.print.XmlPrinter;
import org.eclipse.soda.devicekit.generator.save.IFileSaver;
import org.eclipse.soda.devicekit.generator.save.java.IJavaSaver;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.CoreUtility;
import org.eclipse.soda.devicekit.util.HtmlHelper;
import org.eclipse.soda.devicekit.util.KeyValuePair;
import org.eclipse.soda.devicekit.util.Nls;

public abstract class AbstractDkGenerator
implements IDkGenerator {
    protected CustomInfo customInfo;
    protected GeneratedInfo generatedInfo;
    protected JavaFileModel fBundleActivatorModel;
    private JavaFileModel messageModel;
    private HtmlHelper fHtmlHelper;
    private String fMainClassName;
    private String fMainPackage;
    private TagElement fMainTagElement;
    private ManifestModel fManifestModel;
    private IFileSaver fManifestSaver;
    private Hashtable fMethodProperties;
    private DeviceKitTagModel fModel;
    private String fPackageBase;
    private RootElement fRoot;
    private IJavaSaver fSaver;
    protected JavaFileModel fServiceModel;
    protected boolean osgi = true;
    protected BuildModel buildModel;
    private IFileSaver buildSaver;
    protected Hashtable otherManifestFiles = new Hashtable();

    protected AbstractDkGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        this(model, generatedInfo, new Hashtable());
    }

    protected AbstractDkGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Hashtable methodProperties) {
        this.fModel = model;
        this.fMethodProperties = methodProperties;
        this.generatedInfo = generatedInfo;
        this.init();
    }

    public void addAdditionalBundles(String bundleId) {
        this.getBuildModel().addAdditionalBundles(bundleId);
    }

    private void addCustomManifestItems() {
        CustomManifestInformation manifest;
        if (this.customInfo != null && (manifest = this.customInfo.getManifestInformation(this.getSourceFolderName())) != null) {
            String[] keys = manifest.getCustomManifestKeys();
            int i = 0;
            while (i < keys.length) {
                String key = keys[i];
                String value = manifest.getCustomManifestValue(key);
                this.fManifestModel.setKeyValue(key, value);
                ++i;
            }
        }
    }

    private void addFieldMetaData(IType type, IField field) {
        try {
            String fieldKey = MetaDataUtility.createFieldKey(field);
            String packageName = type.getPackage();
            String typeName = type.getName();
            TypeInformation typeInfo = this.generatedInfo.getTypeInformation(packageName, typeName);
            if (typeInfo != null) {
                typeInfo.addFieldInformation(fieldKey, null, this.getVersion());
            }
        }
        catch (org.eclipse.jdt.core.JavaModelException e) {
            e.printStackTrace();
        }
        catch (DeviceKitMetaDataException e) {
            e.printStackTrace();
        }
    }

    private void addMethodMetaData(IType type, IMethod method) {
        try {
            String methodKey = MetaDataUtility.createMethodKey(method);
            String packageName = type.getPackage();
            String typeName = type.getName();
            TypeInformation typeInfo = this.generatedInfo.getTypeInformation(packageName, typeName);
            if (typeInfo != null) {
                typeInfo.addMethodInformation(methodKey, null, this.getVersion());
            }
        }
        catch (org.eclipse.jdt.core.JavaModelException e) {
            e.printStackTrace();
        }
        catch (DeviceKitMetaDataException e) {
            e.printStackTrace();
        }
    }

    protected void codeBAClassNameField(IType ba) {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append('\"');
        buffer.append(this.getBundleActivatorFqn());
        buffer.append('\"');
        this.codeField(ba, "CLASS_NAME", "String", 49L, "Defines the class name.", buffer.toString());
    }

    protected void codeBACreateProperties(IType ba) {
        Hashtable table = this.getOsgiProperties(this.fBundleActivatorModel);
        if (table != null) {
            String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_HASHTABLE);
            String comment = this.getBACreatePropertiesComment(table);
            String contents = this.getBACreatePropertiesContents(table);
            this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_HASHTABLE);
            this.codeMethod(ba, "createProperties", comment, returnType, 1L, contents);
        }
    }

    protected void codeBADeviceCategoryField(IType ba) {
        StringBuffer comment = new StringBuffer(64);
        comment.append("Defines the ");
        comment.append("org.osgi.service.device.Constants.DEVICE_CATEGORY");
        comment.append(" property.");
        StringBuffer value = new StringBuffer(64);
        value.append("new String[] {");
        value.append(this.quote(this.getDeviceCategory()));
        value.append("}");
        this.codeField(ba, "DEVICE_CATEGORY", "String []", 49L, comment.toString(), value.toString());
    }

    protected void codeBAExportedServiceNamesField(IType ba, String valueString, String comment) {
        StringBuffer valueBuffer = new StringBuffer(32);
        valueBuffer.append("new String[]{\n");
        valueBuffer.append(valueString);
        valueBuffer.append("};");
        this.codeField(ba, "EXPORTED_SERVICE_NAMES", "String [] ", 49L, comment, valueBuffer.toString());
    }

    protected void codeBAFields(IType ba) {
        this.codeBAClassNameField(ba);
    }

    protected void codeBAGetExportedServiceNames(IType ba, String comment) {
        String contents = this.getBAGetExportedServiceNameContents();
        if (ba.getName().endsWith("Factory")) {
            this.codeMethod(ba, "getExportedServiceNames", comment, "String[]", 1L, contents, this.getBundleParameters(), null);
        } else {
            this.codeMethod(ba, "getExportedServiceNames", comment, "String[]", 1L, contents);
        }
    }

    protected void codeBAGetImportedServiceNames(IType ba, String comment) {
        String contents = this.getBAGetImportedServiceNameContents();
        if (ba.getName().endsWith("Factory")) {
            this.codeMethod(ba, "getImportedServiceNames", comment, "String[]", 1L, contents, this.getBundleParameters(), null);
        } else {
            this.codeMethod(ba, "getImportedServiceNames", comment, "String[]", 1L, contents);
        }
    }

    protected void codeBAGetImportedServiceNames(String bundle, IType ba) {
        Vector services = this.getManifestImportServices();
        if (services.size() > 0) {
            this.codeBAImportedServiceNamesField(bundle, ba);
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("Return the imported service name(s) to be registered by the " + bundle + " bundle.\n");
            buffer.append("\n@return String[] The imported service names.\n");
            this.codeBAGetImportedServiceNames(ba, buffer.toString());
        }
    }

    protected void codeBAGetMatchingDevicesMethod(IType ba, String comment) {
        String contents = this.getBAGetMatchingDevicesContents();
        this.codeMethod(ba, "getMatchDeviceClasses", comment, "String[]", 1L, contents);
    }

    protected void codeBAImportedServiceNamesField(IType ba, String valueString, String comment) {
        StringBuffer valueBuffer = new StringBuffer(32);
        valueBuffer.append("new String[]{\n");
        valueBuffer.append(valueString);
        valueBuffer.append("};");
        this.codeField(ba, "IMPORTED_SERVICE_NAMES", "String [] ", 49L, comment, valueBuffer.toString());
    }

    protected void codeBAImportedServiceNamesField(String bundle, IType ba) {
        StringBuffer fieldComment = new StringBuffer(64);
        fieldComment.append("Defines the imported service name(s) to be registered by the " + bundle + " bundle.\n");
        Vector services = this.getManifestImportServices();
        int indentation = 0;
        if (services.size() > 0) {
            fieldComment.append(this.getHtmlHelper().startTable(0));
            ++indentation;
            int i = 0;
            while (i < services.size()) {
                fieldComment.append(this.getHtmlHelper().getTableRow(indentation, String.valueOf(services.get(i))));
                ++i;
            }
            fieldComment.append(this.getHtmlHelper().endTable(--indentation));
        }
        StringBuffer value = new StringBuffer(64);
        int i = 0;
        while (i < services.size()) {
            String curr;
            if (i > 0) {
                value.append(',');
            }
            if ((curr = String.valueOf(services.get(i))).equals(DeviceKitGenerationConstants.CLASS_OSGI_DEVICE)) {
                value.append("\n\t");
                value.append(this.quote(curr));
            } else {
                value.append("\n\t");
                value.append(DeviceKitUtilities.stripPackage(curr));
                value.append('.');
                value.append("SERVICE_NAME");
            }
            ++i;
        }
        this.codeBAImportedServiceNamesField(ba, value.toString(), fieldComment.toString());
    }

    protected void codeBAMatchingDevicesField(IType ba, String valueString) {
        StringBuffer valueBuffer = new StringBuffer(32);
        valueBuffer.append("new String[]{\n");
        if (valueString != null) {
            valueBuffer.append(valueString);
        }
        valueBuffer.append('}');
        this.codeField(ba, "MATCHING_DEVICES", "String [] ", 49L, "The match strings.", valueBuffer.toString());
    }

    protected void codeBAMethods(IType bundleActivatorClass) {
        this.codeBACreateProperties(bundleActivatorClass);
    }

    protected void codeClassNameField(IType type, String classFqn) {
        String value = String.valueOf('\"') + classFqn + '\"';
        this.codeField(type, "CLASS_NAME", "String", 49L, "Defines the class name.", value);
    }

    protected void codeCreateMessageMethod(IType messgageType, String returnType, String methodName, long identifiers, String value, String fieldName) {
        StringBuffer valueBuffer = new StringBuffer(value.length() + 10);
        valueBuffer.append("return ");
        valueBuffer.append(value);
        valueBuffer.append(";\n");
        StringBuffer commentBuffer = new StringBuffer(64);
        commentBuffer.append("Creates and returns the ");
        commentBuffer.append(returnType);
        commentBuffer.append(' ');
        commentBuffer.append(fieldName);
        this.codeMethod(messgageType, methodName, commentBuffer.toString(), returnType, identifiers, valueBuffer.toString());
    }

    protected void codeCustomParameterServiceDefaultValue(IType service, String name, String type, String defaultValue) {
        String tname = name;
        if (defaultValue != null) {
            String comment = "Custom parameter " + tname + " configuration default value.";
            tname = "DEFAULT_" + tname.toUpperCase();
            this.codeField(service, tname, type, 49L, comment, defaultValue);
        }
    }

    protected void codeCustomParameterServiceFields(IType service) {
        Vector params = this.getMainElement().getAllChildrenWithTagCode(46);
        if (params == null) {
            return;
        }
        int i = 0;
        while (i < params.size()) {
            boolean isString;
            CustomParameter parameter = (CustomParameter)params.get(i);
            String name = parameter.getAttribute("name");
            String type = parameter.getAttribute("type");
            String defaultValue = parameter.getAttribute("defaultvalue");
            boolean bl = isString = "String".equals(type) || "java.lang.String".equals(type);
            if (defaultValue != null && isString) {
                defaultValue = this.quote(defaultValue);
            }
            this.codeCustomParameterServiceKey(service, name, this.quote(name));
            this.codeCustomParameterServiceDefaultValue(service, name, type, defaultValue);
            ++i;
        }
    }

    protected void codeCustomParameterServiceKey(IType service, String name, String value) {
        String tname = name;
        String comment = "Custom parameter " + tname + " configuration key.";
        tname = String.valueOf(tname.toUpperCase()) + "_KEY";
        this.codeField(service, tname, "String", 49L, comment, value);
    }

    protected void codeDescriptionField(IType type) {
        String description = this.getMainElement().getDescription();
        if (description == null) {
            description = this.getMainElement().getName();
        }
        String value = String.valueOf('\"') + description + '\"';
        this.codeField(type, "DESCRIPTION", "String", 49L, "Description of the test.", value);
    }

    protected IField codeField(IType type, String fieldName, String fieldType, long identifiers, String[] comment, String value) {
        IField field = type.createField(fieldType, fieldName);
        field.setIdentifiers(identifiers);
        String[] newComment = comment;
        field.setComment(newComment);
        field.setValue(value);
        this.addFieldMetaData(type, field);
        return field;
    }

    protected IField codeField(IType type, String fieldName, String fieldType, long identifiers, String comment, String value) {
        return this.codeField(type, fieldName, fieldType, identifiers, DeviceKitUtilities.convertStringToArray(comment), value);
    }

    protected void codeMessageCommonElements(IType messageType, TagElement element, boolean lazy, boolean initWithMethods) {
        String fieldType = this.getMessageType(element);
        fieldType = DeviceKitUtilities.stripPackage(fieldType);
        String fieldName = CodeUtilities.staticFieldName(element.getId());
        String[] comment = element.getFieldComment();
        if (comment != null && comment.length > 0 && !comment[0].trim().endsWith(".")) {
            comment[0] = String.valueOf(comment[0]) + ".";
        }
        long identifiers = 18L;
        String value = null;
        if (!lazy) {
            identifiers |= 0x20L;
            NewCodeGenerator gen = new NewCodeGenerator(this.getMessageFqn(), this.getMessageFqn(), this.getServiceFqn(), lazy);
            value = gen.getNewCode(0, element);
            if (initWithMethods) {
                String methodName = "create" + fieldName;
                this.codeCreateMessageMethod(messageType, fieldType, methodName, identifiers, value, fieldName);
                StringBuffer valueBuffer = new StringBuffer(methodName.length() + 2);
                valueBuffer.append(methodName);
                valueBuffer.append("()");
                value = valueBuffer.toString();
            }
            JavaFileModel messModel = this.getMessageModel();
            Vector newImports = gen.getImports();
            int j = 0;
            while (j < newImports.size()) {
                String importedItem = (String)newImports.elementAt(j);
                messModel.addImport(importedItem);
                String importedPack = DeviceKitUtilities.extractPackage(importedItem);
                this.getManifestModel().addImportPackage(importedPack);
                ++j;
            }
        }
        this.codeField(messageType, fieldName, fieldType, identifiers, comment, value);
        this.codeMessageGetter(messageType, element, lazy);
    }

    protected void codeMessageGetter(IType messType, TagElement element, boolean lazy) {
        JavaFileModel messModel = this.getMessageModel();
        String type = this.getMessageType(element);
        messModel.addImport(type);
        type = DeviceKitUtilities.stripPackage(type);
        String getterName = "get" + CodeUtilities.staticFieldName(element.getId());
        String comment = this.getMessageGetterComment(element, type);
        String contents = this.getMessageGetterContents(element, lazy);
        this.codeMethod(messType, getterName, comment, type, 17L, contents);
    }

    protected IMethod codeMethod(IType type, String name, String[] comment, String returnType, long identifers, String contents, KeyValuePair[] parameters, String[] exceptions) {
        int i;
        IMethod method = type.createMethod(name);
        method.setComment(comment);
        method.setReturnType(returnType);
        method.setIdentifiers(identifers);
        if (parameters != null) {
            i = 0;
            while (i < parameters.length) {
                method.addParameter(parameters[i].getKey(), parameters[i].getValue());
                ++i;
            }
        }
        if (exceptions != null) {
            i = 0;
            while (i < exceptions.length) {
                method.addThrownException(exceptions[i]);
                ++i;
            }
        }
        if (contents != null) {
            StringBuffer buffer = new StringBuffer(1024);
            buffer.append("/* ");
            buffer.append(this.getGeneratedMethodComment());
            buffer.append(" */\r\n");
            buffer.append(contents);
            method.setContents(buffer.toString());
        } else {
            method.setContents(this.getGeneratedMethodComment());
        }
        this.addMethodMetaData(type, method);
        return method;
    }

    protected IMethod codeMethod(IType type, String name, String[] comment, String returnType, long identifers, String contents) {
        return this.codeMethod(type, name, comment, returnType, identifers, contents, new KeyValuePair[0], null);
    }

    protected IMethod codeMethod(IType type, String name, String comment, String returnType, long identifiers, String contents, KeyValuePair[] parameters, String[] exceptions) {
        return this.codeMethod(type, name, DeviceKitUtilities.convertStringToArray(comment), returnType, identifiers, contents, parameters, exceptions);
    }

    protected IMethod codeMethod(IType type, String name, String comment, String returnType, long identifers, String contents) {
        return this.codeMethod(type, name, comment, returnType, identifers, contents, null, null);
    }

    protected IMethod codeMethodNoMetaData(IType type, String name, String[] comment, String returnType, long identifers, String contents, KeyValuePair[] parameters, String[] exceptions) {
        int i;
        IMethod method = type.createMethod(name);
        method.setComment(comment);
        method.setReturnType(returnType);
        method.setIdentifiers(identifers);
        if (parameters != null) {
            i = 0;
            while (i < parameters.length) {
                method.addParameter(parameters[i].getKey(), parameters[i].getValue());
                ++i;
            }
        }
        if (exceptions != null) {
            i = 0;
            while (i < exceptions.length) {
                method.addThrownException(exceptions[i]);
                ++i;
            }
        }
        if (contents != null) {
            method.setContents(contents);
        }
        return method;
    }

    protected IMethod codeMethodNoMetaDataOptional(IType type, String name, String[] comment, String returnType, long identifers, String contents, KeyValuePair[] parameters, String[] exceptions) {
        IMethod[] methods = type.getMethods();
        if (methods != null) {
            int i = 0;
            while (i < methods.length) {
                IMethod method = methods[i];
                if (name.equals(method.getName())) {
                    return method;
                }
                ++i;
            }
        }
        return this.codeMethodNoMetaData(type, name, comment, returnType, identifers, contents, parameters, exceptions);
    }

    protected void codeParameterAccess(CustomParameter parameter, IType transport) {
        String name = parameter.getAttribute("name");
        String capName = DeviceKitUtilities.capitalizeFirstLetter(name);
        String type = parameter.getAttribute("type");
        String defaultValue = parameter.getAttribute("defaultvalue");
        String description = parameter.getDescription();
        boolean isString = "String".equals(type) || "java.lang.String".equals(type);
        String comment = null;
        if (description != null) {
            if (!description.trim().endsWith(".")) {
                description = String.valueOf(description) + ".";
            }
            comment = description;
        } else {
            comment = "Custom parameter " + name + ".";
        }
        String value = null;
        if (defaultValue != null) {
            if (isString) {
                defaultValue = this.quote(defaultValue);
            }
            value = defaultValue;
        }
        this.codeField(transport, name, type, 2L, comment, value);
        String setName = "set" + capName;
        StringBuffer methDesc = new StringBuffer(64);
        if (description != null) {
            methDesc.append(description);
        } else {
            methDesc.append("Sets the value of " + name + " custom parameter.");
        }
        methDesc.append("\n@see #get" + capName);
        String setComment = methDesc.toString();
        KeyValuePair setParameter = new KeyValuePair(type, name);
        String setContents = "this." + name + " = " + name + ";\n";
        this.codeMethod(transport, setName, setComment, "void", 1L, setContents, new KeyValuePair[]{setParameter}, null);
        String getName = "get" + capName;
        methDesc = new StringBuffer(64);
        if (description != null) {
            methDesc.append(description);
        } else {
            methDesc.append("Gets the value of " + name + " custom parameter.");
        }
        methDesc.append("\n@see #set" + capName);
        String getComment = methDesc.toString();
        String getReturnType = type;
        String getContents = "return this." + name + ";\n";
        this.codeMethod(transport, getName, getComment, getReturnType, 1L, getContents);
    }

    protected void codeServiceFields(IType service) {
        boolean hasFactoryTag;
        boolean hasManagedTag;
        String comment = "Define the OSGi service name.";
        String value = String.valueOf('\"') + this.getServiceFqn() + '\"';
        this.codeServiceNameField(service, this.getServiceClass(), "SERVICE_NAME", comment, value);
        boolean bl = hasManagedTag = this.fMainTagElement.getAllChildrenWithTagCode(67).size() > 0;
        if (hasManagedTag) {
            String className = String.valueOf(this.getMainClassName()) + "Managed";
            comment = "Define the OSGi managed service name.";
            String packageName = DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase());
            String fqn = String.valueOf(packageName) + '.' + className;
            value = this.quote(fqn);
            this.codeServiceNameField(service, className, "MANAGED_SERVICE_NAME", comment, value);
        }
        boolean bl2 = hasFactoryTag = this.fMainTagElement.getAllChildrenWithTagCode(68).size() > 0;
        if (hasFactoryTag) {
            String className = String.valueOf(this.getMainClassName()) + "Factory";
            comment = "Define the OSGi factory service name.";
            String packageName = DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase());
            String fqn = String.valueOf(packageName) + '.' + className;
            value = this.quote(fqn);
            this.codeServiceNameField(service, className, "FACTORY_SERVICE_NAME", comment, value);
        }
    }

    private void codeServiceNameField(IType service, String className, String fieldName, String comment, String value) {
        this.codeField(service, fieldName, "String", 49L, comment, value);
    }

    protected IType createClass(JavaFileModel model, String packageName, String typeName, String projectName) throws JavaModelException {
        return this.createType(model, packageName, typeName, 1, projectName);
    }

    protected IType createInterface(JavaFileModel model, String packageName, String typeName, String projectName) throws JavaModelException {
        return this.createType(model, packageName, typeName, 0, projectName);
    }

    protected IType createMessageType() throws Exception {
        String messagePackage = this.getMessagePackage();
        String messageClass = this.getMessageClass();
        JavaFileModel messModel = new JavaFileModel(messageClass);
        messModel.setComment(this.getCopyright());
        messModel.setPackage(messagePackage);
        IType messType = this.createClass(messModel, messagePackage, messageClass, this.getSourceFolderName());
        messType.setComment(this.getMessageClassComment());
        this.setMessageModel(messModel);
        return messType;
    }

    private IType createServiceType() throws Exception {
        String servicePackage = this.getServicePackage();
        String serviceClass = this.getServiceClass();
        this.fServiceModel = new JavaFileModel(serviceClass);
        this.fServiceModel.setComment(this.getCopyright());
        this.fServiceModel.setPackage(servicePackage);
        IType serviceType = this.createInterface(this.fServiceModel, servicePackage, serviceClass, this.getSourceFolderName());
        serviceType.setComment(this.getServiceFileComment());
        String[] interfaces = this.getServiceInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            this.fServiceModel.addImport(interfaces[i]);
            serviceType.addSuperInterface(DeviceKitUtilities.stripPackage(interfaces[i]));
            ++i;
        }
        return serviceType;
    }

    protected IType createType(JavaFileModel model, String packageName, String typeName, int kind, String projectName) throws JavaModelException {
        IType type = null;
        type = kind == 1 ? model.createClass(packageName, typeName) : model.createInterface(packageName, typeName);
        this.generatedInfo.addTypeInformation(packageName, typeName, this.getVersion(), projectName);
        return type;
    }

    protected boolean doGenerateBundleActivator() {
        return true;
    }

    protected boolean doGenerateService() {
        return true;
    }

    protected RuntimeException error(String message) {
        return new RuntimeException(message);
    }

    protected void generate() throws Exception {
        this.initialize();
        if (this.doGenerateService()) {
            this.generateServiceClass();
        }
        this.generateSpecificClass();
        if (!this.isAbstract() && this.doGenerateBundleActivator()) {
            this.generateBundleActivatorClass();
        }
        if (this.doGenerateService()) {
            this.generateManifest();
        }
        this.generateOtherFiles();
    }

    protected void generateBundleActivatorClass() throws Exception {
    }

    protected void generateCustomBundleActivatorItems() {
        if (this.fBundleActivatorModel != null) {
            this.generateCustomItems(this.fBundleActivatorModel.getType());
        }
    }

    protected void generateCustomItems() {
        if (this.customInfo != null) {
            this.generateCustomMainItems();
            this.generateCustomServiceItems();
            this.generateCustomBundleActivatorItems();
        }
    }

    protected void generateCustomItems(IType type) {
        CustomTypeInformation customTypeInfo;
        if (this.customInfo != null && type != null && (customTypeInfo = this.customInfo.getTypeInformation(type.getPackage(), type.getName())) != null) {
            MethodInformation[] customMethods = customTypeInfo.getMethods();
            int i = 0;
            while (i < customMethods.length) {
                type.addExtraMethod(customMethods[i].getKey(), (String)customMethods[i].getData());
                ++i;
            }
            FieldInformation[] customFields = customTypeInfo.getFields();
            int i2 = 0;
            while (i2 < customFields.length) {
                type.addExtraField(customFields[i2].getKey(), (String)customFields[i2].getData());
                ++i2;
            }
        }
    }

    protected void generateCustomMainItems() {
        JavaFileModel mainModel = this.getMainModel();
        if (mainModel != null) {
            this.generateCustomItems(mainModel.getType());
        }
    }

    protected void generateCustomServiceItems() {
        if (this.fServiceModel != null) {
            this.generateCustomItems(this.fServiceModel.getType());
        }
    }

    public void generateManifest() {
        String abs;
        String manifestBundleName = this.getManifestBundleName();
        this.fManifestModel.setBundleName(manifestBundleName);
        if (this.useEclipse32Names()) {
            String manifestBundleId = this.getManifestBundleId();
            this.fManifestModel.setSymbolicBundleName(manifestBundleId);
            this.fManifestModel.setKeyValue("Bundle-ManifestVersion", "2");
        }
        if ((abs = this.getMainElement().getAttribute("abstract")) == null || abs.equals("false")) {
            this.fManifestModel.setBundleActivator(this.getBundleActivatorFqn());
        }
        this.fManifestModel.setVendor(this.getProvider());
        this.fManifestModel.setVendors(this.getVendors());
        this.fManifestModel.setDescription(this.getManifestDescription());
        if (this.useEclipse32Names()) {
            this.fManifestModel.setVersion(String.valueOf(this.getVersion()) + ".qualifier");
        } else {
            this.fManifestModel.setVersion(this.getVersion());
        }
        String[] categories = this.getManifestCategories();
        int i = 0;
        while (i < categories.length) {
            this.fManifestModel.addCategory(categories[i]);
            ++i;
        }
        Vector expServices = this.getManifestExportServices();
        int i2 = 0;
        while (i2 < expServices.size()) {
            this.fManifestModel.addExportedService((String)expServices.elementAt(i2));
            ++i2;
        }
        Vector expPackages = this.getManifestExportPackages();
        int i3 = 0;
        while (i3 < expPackages.size()) {
            this.fManifestModel.addExportedPackage((String)expPackages.elementAt(i3));
            ++i3;
        }
        Vector requiredBundles = this.getManifestRequiredBundles();
        int i4 = 0;
        while (i4 < requiredBundles.size()) {
            this.fManifestModel.addRequiredBundle((String)requiredBundles.elementAt(i4));
            ++i4;
        }
        Vector impServices = this.getManifestImportServices();
        int i5 = 0;
        while (i5 < impServices.size()) {
            this.fManifestModel.addImportService((String)impServices.elementAt(i5));
            String packageName = DeviceKitUtilities.extractPackage((String)impServices.elementAt(i5));
            if (!expPackages.contains(packageName)) {
                this.fManifestModel.addImportPackage(packageName);
            }
            ++i5;
        }
        Vector impPackages = this.getManifestImportPackages();
        int i6 = 0;
        while (i6 < impPackages.size()) {
            String name = (String)impPackages.elementAt(i6);
            if (!expPackages.contains(name)) {
                this.fManifestModel.addImportPackage(name);
            }
            ++i6;
        }
        i6 = 0;
        while (i6 < expServices.size()) {
            String packageName = DeviceKitUtilities.extractPackage((String)expServices.elementAt(i6));
            if (!expPackages.contains(packageName)) {
                this.fManifestModel.addImportPackage(packageName);
            }
            ++i6;
        }
        this.fManifestModel.setCopyright(this.getManifestCopyright());
        this.addCustomManifestItems();
        this.getBuildModel().addPackages(this.getManifestModel().getImportedPackages());
    }

    protected void generateMessageClass(boolean lazy, boolean initWithMethod) throws Exception {
        Vector elements = this.getMessageClassElements();
        if (elements.size() == 0) {
            return;
        }
        IType messageType = this.createMessageType();
        int i = 0;
        while (i < elements.size()) {
            TagElement element = (TagElement)elements.elementAt(i);
            this.codeMessageCommonElements(messageType, element, lazy, initWithMethod);
            ++i;
        }
    }

    protected void generateOtherFiles() throws Exception {
        String properties = this.getMetaDataProperties();
        if (properties != null) {
            this.otherManifestFiles.put("OSGI-INF/l10n/bundle.properties", properties);
            this.otherManifestFiles.put("OSGI-INF/l10n/bundle_en.properties", properties);
        }
    }

    protected void generateServiceClass() throws Exception {
        IType serviceType = this.createServiceType();
        this.codeServiceFields(serviceType);
        this.generateCustomServiceItems();
    }

    protected abstract void generateSpecificClass() throws Exception;

    protected void generateXml(int bundleType) throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        Map map = this.getTemplateVariables();
        String name = this.getMainElement().getKey();
        if (name != null) {
            IProject project;
            String baseType = "";
            String targetId = this.getMainElement().getProjectId();
            switch (bundleType) {
                case 0: {
                    break;
                }
                case 1: {
                    baseType = "bundle";
                    break;
                }
                case 2: {
                    baseType = "managed";
                    break;
                }
                case 3: {
                    baseType = "factory";
                }
            }
            String projectName = targetId;
            if (baseType.length() > 0) {
                projectName = String.valueOf(targetId) + '.' + baseType;
            }
            if ((project = CoreUtility.getProject(projectName)).exists()) {
                map.put("copyright_properties", GeneratorTemplates.getCopyrightPropertyString(map));
                map.put("copyright_xml", GeneratorTemplates.getCopyrightXmlString(map));
                String[] warningStrings = GeneratorTemplates.getStrings(GeneratorTemplates.getWarning(map));
                XmlPrinter printer = new XmlPrinter();
                printer.printComments(warningStrings);
                map.put("warning_xml", printer.getContents());
                String string = GeneratorTemplates.getResults("testagent/testagent" + baseType + "_test.xml", map).trim();
                IFile testXmlFile = project.getFile("test.xml");
                ByteArrayInputStream buildSamplesStringFileSource = new ByteArrayInputStream(string.getBytes());
                if (testXmlFile.exists()) {
                    testXmlFile.setContents((InputStream)buildSamplesStringFileSource, true, true, (IProgressMonitor)monitor);
                } else {
                    testXmlFile.create((InputStream)buildSamplesStringFileSource, true, (IProgressMonitor)monitor);
                }
            }
        }
    }

    protected String getBACreatePropertiesComment(Hashtable table) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(DeviceKitGenerator.getResource("AbstractDkGenerator.ba.create.properties.comment1"));
        buffer.append('\n');
        buffer.append("@return Hashtable of properties.\n");
        buffer.append(" \n");
        int indentation = 0;
        buffer.append(this.getHtmlHelper().startTable(indentation, 100));
        ++indentation;
        Enumeration enumeration = table.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = (String)table.get(key);
            String[] dataEntries = new String[]{this.unquote(key), this.unquote(value)};
            int[] percents = new int[]{50, 50};
            buffer.append(this.getHtmlHelper().getTableRow(indentation, dataEntries, percents));
        }
        buffer.append(this.getHtmlHelper().endTable(--indentation));
        return buffer.toString();
    }

    protected String getBACreatePropertiesContents(Hashtable table) {
        HashMap<String, String> map = new HashMap<String, String>(101);
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("final Hashtable properties = super.createProperties();\n");
        Enumeration enumeration = table.keys();
        while (enumeration.hasMoreElements()) {
            String key = String.valueOf(enumeration.nextElement());
            Object value = table.get(key);
            buffer.append("properties.put(");
            if (key.indexOf(46) < 0) {
                buffer.append(key);
            } else {
                String className = DeviceKitUtilities.extractPackage(key);
                String smallKey = DeviceKitUtilities.stripPackage(className);
                Object current = map.get(smallKey);
                if (current == null || className.equals(current)) {
                    buffer.append(smallKey);
                    buffer.append('.');
                    buffer.append(DeviceKitUtilities.stripPackage(key));
                    this.fBundleActivatorModel.addImport(className);
                    map.put(smallKey, className);
                } else {
                    buffer.append(key);
                }
            }
            buffer.append(", ");
            if (key.endsWith("org.osgi.service.device.Constants.DEVICE_CATEGORY")) {
                buffer.append("DEVICE_CATEGORY");
            } else {
                buffer.append(value.toString());
            }
            buffer.append(");\n");
        }
        buffer.append("return properties;");
        return buffer.toString();
    }

    protected String getBAGetExportedServiceNameContents() {
        return "return EXPORTED_SERVICE_NAMES;\n";
    }

    protected String getBAGetImportedServiceNameContents() {
        return "return IMPORTED_SERVICE_NAMES;\n";
    }

    protected String getBAGetMatchingDevicesContents() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("return MATCHING_DEVICES;\n");
        return buffer.toString();
    }

    protected abstract String getBASuperClass();

    public BuildModel getBuildModel() {
        return this.buildModel;
    }

    public IFileSaver getBuildSaver() {
        return this.buildSaver;
    }

    protected String getBundleActivatorClass() {
        return "";
    }

    protected String getBundleActivatorComment() {
        return "";
    }

    protected String getBundleActivatorFqn() {
        return "";
    }

    protected String getBundleActivatorPackage() {
        return String.valueOf(this.getMainPackage()) + "." + "bundle";
    }

    public KeyValuePair[] getBundleParameters() {
        KeyValuePair arg0 = new KeyValuePair(DkUtilities.stripPackage("String"), "pid");
        KeyValuePair arg1 = new KeyValuePair(DkUtilities.stripPackage("java.util.Dictionary"), "oldProperties");
        KeyValuePair arg2 = new KeyValuePair(DkUtilities.stripPackage("java.util.Dictionary"), "properties");
        KeyValuePair arg3 = new KeyValuePair(DkUtilities.stripPackage("org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager"), "manager");
        KeyValuePair[] parameters = new KeyValuePair[]{arg0, arg1, arg2, arg3};
        return parameters;
    }

    protected String getCommonClassComment() {
        String specComment = this.getSpecComment();
        StringBuffer buffer = new StringBuffer(specComment.length() + 64);
        buffer.append(specComment);
        if (this.getVendors() != null) {
            buffer.append("@author ");
            buffer.append(this.getVendors());
            buffer.append('\n');
        }
        if (this.getVersion() != null) {
            buffer.append("@version ");
            buffer.append(this.getVersion());
            buffer.append('\n');
        }
        return buffer.toString();
    }

    protected String getConfBoolean(TagElement element, String key, String defaultBoolean) {
        StringBuffer buffer = new StringBuffer(50);
        if (this.getConfigurationKey(element) == null) {
            buffer.append(defaultBoolean);
        } else {
            buffer.append("getBoolean(");
            String configKey = this.getConfigurationKey(element);
            buffer.append(this.quote(String.valueOf(configKey) + '.' + key));
            buffer.append(", ");
            buffer.append(defaultBoolean);
            buffer.append(")");
        }
        return buffer.toString();
    }

    protected String getConfBoolean(TagElement element, String key, boolean defaultBoolean) {
        StringBuffer buffer = new StringBuffer(50);
        if (this.getConfigurationKey(element) == null) {
            buffer.append(defaultBoolean);
        } else {
            buffer.append("getBoolean(");
            String configKey = this.getConfigurationKey(element);
            buffer.append(this.quote(String.valueOf(configKey) + '.' + key));
            buffer.append(", ");
            buffer.append(defaultBoolean);
            buffer.append(")");
            EscPropertiesModel.getModel(this).addProperty(String.valueOf(configKey) + '.' + key, defaultBoolean);
        }
        return buffer.toString();
    }

    protected String getConfInt(TagElement element, String key, String defaultValue) {
        StringBuffer buffer = new StringBuffer(50);
        if (this.getConfigurationKey(element) == null) {
            buffer.append(defaultValue);
        } else {
            buffer.append("getInt(");
            String configKey = this.getConfigurationKey(element);
            buffer.append(this.quote(String.valueOf(configKey) + '.' + key));
            buffer.append(", ");
            buffer.append(defaultValue);
            buffer.append(")");
        }
        return buffer.toString();
    }

    protected String getConfLong(TagElement element, String key, String defaultValue) {
        StringBuffer buffer = new StringBuffer(50);
        if (this.getConfigurationKey(element) == null) {
            buffer.append(defaultValue);
        } else {
            buffer.append("getLong(");
            String configKey = this.getConfigurationKey(element);
            buffer.append(this.quote(String.valueOf(configKey) + '.' + key));
            buffer.append(", ");
            buffer.append(defaultValue);
            buffer.append(")");
        }
        return buffer.toString();
    }

    protected String getConfStaticBoolean(TagElement element, String key, boolean defaultBoolean) {
        StringBuffer buffer = new StringBuffer(50);
        if (this.getConfigurationKey(element) == null) {
            buffer.append(defaultBoolean);
        } else {
            buffer.append("getStaticBoolean(");
            String configKey = this.getConfigurationKey(element);
            buffer.append(this.quote(String.valueOf(configKey) + '.' + key));
            buffer.append(", ");
            buffer.append(defaultBoolean);
            buffer.append(")");
            EscPropertiesModel.getModel(this).addProperty(String.valueOf(configKey) + '.' + key, defaultBoolean);
        }
        return buffer.toString();
    }

    protected String getConfStaticInt(TagElement element, String key, String defaultValue) {
        StringBuffer buffer = new StringBuffer(50);
        if (this.getConfigurationKey(element) == null) {
            buffer.append(defaultValue);
        } else {
            buffer.append("getStaticInt(");
            String configKey = this.getConfigurationKey(element);
            buffer.append(this.quote(String.valueOf(configKey) + '.' + key));
            buffer.append(", ");
            buffer.append(defaultValue);
            buffer.append(")");
        }
        return buffer.toString();
    }

    protected String getConfStaticLong(TagElement element, String key, String defaultValue) {
        StringBuffer buffer = new StringBuffer(50);
        if (this.getConfigurationKey(element) == null) {
            buffer.append(defaultValue);
        } else {
            buffer.append("getStaticLong(");
            String configKey = this.getConfigurationKey(element);
            buffer.append(this.quote(String.valueOf(configKey) + '.' + key));
            buffer.append(", ");
            buffer.append(defaultValue);
            buffer.append(")");
        }
        return buffer.toString();
    }

    protected String getConfString(TagElement element, String key, String defaultString) {
        StringBuffer buffer = new StringBuffer(50);
        if (this.getConfigurationKey(element) == null) {
            buffer.append(defaultString);
        } else {
            buffer.append("getString(");
            String configKey = this.getConfigurationKey(element);
            buffer.append(this.quote(String.valueOf(configKey) + '.' + key));
            buffer.append(", ");
            buffer.append(defaultString);
            buffer.append(")");
        }
        return buffer.toString();
    }

    protected String getConfigurationKey(TagElement element) {
        String key = element.getBundleId();
        if (key != null && key.length() > 0) {
            return key.toLowerCase();
        }
        TagElement parent = element.getParent();
        if (parent != null && (key = parent.getBundleId()) != null && key.length() > 0) {
            return key.toLowerCase();
        }
        key = element.getKey();
        if (key != null && key.length() > 0) {
            return key.toLowerCase();
        }
        return null;
    }

    protected String getCopyright() {
        return GeneratorTemplates.getCopyright(this.getTemplateVariables());
    }

    protected int getDefaultRanking() {
        return 6;
    }

    protected String getDeviceCategory() {
        return "";
    }

    public String getGeneratedMethodComment() {
        return "This is a generated method and should not be edited.";
    }

    protected String getGeneratorVersion() {
        return GeneratorPlugin.getVersion();
    }

    public HtmlHelper getHtmlHelper() {
        return this.fHtmlHelper;
    }

    protected String getImplementation(TagElement element, String name) {
        String imp;
        if (name.equals(element.getAttribute("service")) && (imp = element.getAttribute("implementation")) != null) {
            return imp;
        }
        return name;
    }

    public IJavaProject getJavaProject() {
        IJavaProject javaProject = CoreUtility.getJavaProject(this.getSourceFolderName());
        return javaProject;
    }

    protected String getKey(TagElement element) {
        StringBuffer key = new StringBuffer(32);
        String id = element.getId();
        if (id != null) {
            if (this.getServiceFqn() != null && this.getServiceFqn().length() > 0 && id != null && id.length() > 0) {
                key.append(DeviceKitUtilities.stripPackage(this.getServiceFqn()));
                key.append('.');
                key.append(id);
            } else {
                key.append(this.quote(id));
            }
            return key.toString();
        }
        return "null";
    }

    public String getMainClassName() {
        return this.fMainClassName;
    }

    protected TagElement getMainElement() {
        return this.fMainTagElement;
    }

    protected String getMainFqn() {
        return String.valueOf(this.getMainPackage()) + '.' + this.getMainClassName();
    }

    public String getMainPackage() {
        return this.fMainPackage;
    }

    protected String getManifestBundleId() {
        String id = this.getMainElement().getBundleId();
        if (id == null) {
            return this.getMainPackage();
        }
        if (id.indexOf(46) < 0) {
            return DeviceKitUtilities.getPackageFromClassName(id, this.getPackageBase());
        }
        return id;
    }

    protected String getManifestBundleName() {
        String name = this.getMainElement().getBundleName();
        if (name != null && name.length() > 0) {
            return name;
        }
        return this.getMainElement().getKey();
    }

    protected abstract String[] getManifestCategories();

    protected String getManifestCopyright() {
        String[] strings = GeneratorTemplates.getCopyrightStrings(this.getTemplateVariables());
        if (strings.length > 0) {
            return strings[0];
        }
        return "";
    }

    protected String getManifestDescription() {
        return this.fMainTagElement.getDescription();
    }

    protected Vector getManifestExportPackages() {
        Vector vector = new Vector();
        return vector;
    }

    protected Vector getManifestExportServices() {
        return new Vector();
    }

    protected Vector getManifestImportPackages() {
        JavaFileModel messModel;
        String corePack;
        Vector<String> vector = new Vector<String>();
        Vector imports = this.fMainTagElement.getAllChildrenWithTagCode(29);
        int i = 0;
        while (i < imports.size()) {
            String string = ((TagElement)imports.elementAt(i)).getTextData();
            if (string != null && string.length() > 0) {
                vector.addElement(string);
            }
            ++i;
        }
        String packageName = Types.getPackage("TransportBundle");
        if (!vector.contains(packageName)) {
            vector.add(packageName);
        }
        if (!vector.contains(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_OSGI_BUNDLE_ACTIVATOR))) {
            vector.addElement(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_OSGI_BUNDLE_ACTIVATOR));
        }
        if (!vector.contains(corePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_CORE_ESC_OBJECT))) {
            vector.add(corePack);
        }
        if ((messModel = this.getMessageModel()) != null) {
            String[] imps = messModel.getImports();
            int i2 = 0;
            while (i2 < imps.length) {
                if (!this.inThisBundle(imps[i2])) {
                    vector.addElement(DeviceKitUtilities.extractPackage(imps[i2]));
                }
                ++i2;
            }
        }
        return vector;
    }

    protected Vector getManifestImportServices() {
        Vector vector = new Vector();
        return vector;
    }

    public ManifestModel getManifestModel() {
        return this.fManifestModel;
    }

    public Vector getManifestRequiredBundles() {
        Vector vector = new Vector();
        return vector;
    }

    protected IFileSaver getManifestSaver() {
        return this.fManifestSaver;
    }

    protected String getMessageClass() {
        return String.valueOf(this.getMainClassName()) + "Messages";
    }

    protected String getMessageClassComment() {
        StringBuffer buffer = new StringBuffer(64);
        String desc = this.getMainElement().getDescription();
        if (desc != null) {
            buffer.append(desc);
            if (!desc.trim().endsWith(".")) {
                buffer.append('.');
            }
            buffer.append("\n\n ");
        }
        String comment = DeviceKitGenerator.getResource("DkDeviceGenerator.message.class.comment1");
        Object[] variables = new String[]{this.getType(), this.getMainClassName()};
        String nlsComment = Nls.format(comment, variables);
        buffer.append(nlsComment);
        buffer.append(" \n");
        buffer.append(this.getCommonClassComment());
        return buffer.toString();
    }

    protected Vector getMessageClassElements() {
        Vector all = TagElement.collection.getIds();
        Vector<TagElement> elements = new Vector<TagElement>();
        int i = 0;
        while (i < all.size()) {
            TagElement e = (TagElement)all.elementAt(i);
            if (e.isMessageClassElement()) {
                elements.addElement(e);
            }
            ++i;
        }
        return elements;
    }

    protected String getMessageFqn() {
        return String.valueOf(this.getMessagePackage()) + "." + this.getMessageClass();
    }

    protected String getMessageGetterComment(TagElement element, String type) {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("Gets the ");
        buffer.append(element.getId());
        buffer.append(" value.");
        buffer.append('\n');
        if (element.hasChildWithTagCode(65)) {
            String specRefComment = this.getSpecReferenceComment(element);
            buffer.append(specRefComment);
        }
        buffer.append("\n@return ");
        buffer.append(type);
        buffer.append(" The ");
        buffer.append(element.getId());
        buffer.append(" message");
        return buffer.toString();
    }

    protected String getMessageGetterContents(TagElement element, boolean lazy) {
        JavaFileModel messModel = this.getMessageModel();
        String name = CodeUtilities.staticFieldName(element.getId());
        StringBuffer contents = new StringBuffer(64);
        if (lazy) {
            contents.append("if (" + name + " == null){\n");
            contents.append("\t" + name + " = \n");
            NewCodeGenerator gen = new NewCodeGenerator(this.getMessageFqn(), this.getMessageFqn(), this.getServiceFqn());
            contents.append(gen.getNewCode(2, element));
            Vector imports = gen.getImports();
            int j = 0;
            while (j < imports.size()) {
                String importedItem = (String)imports.elementAt(j);
                messModel.addImport(importedItem);
                String importedPack = DeviceKitUtilities.extractPackage(importedItem);
                this.getManifestModel().addImportPackage(importedPack);
                ++j;
            }
            contents.append(";\n");
            contents.append("}\n");
        }
        contents.append("return " + name + ";");
        return contents.toString();
    }

    protected JavaFileModel getMessageModel() {
        return this.messageModel;
    }

    protected String getMessagePackage() {
        return String.valueOf(this.getMainPackage()) + "." + "Messages".toLowerCase();
    }

    protected String getMessageType(TagElement element) {
        JavaFileModel messModel = this.getMessageModel();
        String type = null;
        type = element.getTagCode() == 7 ? DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE : (element.getTagCode() == 6 ? DeviceKitGenerationConstants.CLASS_FILTER_SERVICE : (element.getTagCode() == 12 || element.getTagCode() == 40 || element.getTagCode() == 25 ? element.getType() : (element.getTagCode() == 5 || element.getTagCode() == 23 ? DeviceKitGenerationConstants.CLASS_PARAMETER_SERVICE : element.getType())));
        messModel.addImport(type);
        return type;
    }

    protected String getMetaDataProperties() {
        return null;
    }

    protected boolean getMethodProperty(String methodName) {
        if (this.fMethodProperties == null) {
            return false;
        }
        String b = (String)this.fMethodProperties.get(methodName);
        return b != null && b.equals("true");
    }

    protected DeviceKitTagModel getModel() {
        return this.fModel;
    }

    protected Hashtable getOsgiProperties(JavaFileModel model) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("org.eclipse.soda.dk.connection.bundle.ServiceBundle.DEVICE_REVISION", this.quote(this.getVersion()));
        return table;
    }

    public Hashtable getOtherManifestFiles() {
        return this.otherManifestFiles;
    }

    protected String getPackageBase() {
        return this.fPackageBase;
    }

    public IPackageFragment[] getPackages() {
        Vector<IPackageFragment> vector = new Vector<IPackageFragment>(101);
        try {
            IJavaProject javaProject = this.getJavaProject();
            if (javaProject.exists()) {
                IPackageFragment[] javaPackages = javaProject.getPackageFragments();
                int i = 0;
                while (i < javaPackages.length) {
                    ICompilationUnit[] compilationUnits = javaPackages[i].getCompilationUnits();
                    if (compilationUnits.length > 0) {
                        vector.add(javaPackages[i]);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IPackageFragment[] javaPackages = new IPackageFragment[vector.size()];
        javaPackages = vector.toArray(javaPackages);
        return javaPackages;
    }

    protected String getProvider() {
        String provider = this.fModel.getProvider();
        if (provider != null) {
            return provider;
        }
        return "Eclipse.org";
    }

    protected RootElement getRootElement() {
        return this.fRoot;
    }

    protected IJavaSaver getSaver() {
        return this.fSaver;
    }

    protected String getServiceClass() {
        return String.valueOf(this.fMainClassName) + "Service";
    }

    protected String getServiceFileComment() {
        return "";
    }

    protected String getServiceFqn() {
        return String.valueOf(this.getServicePackage()) + "." + this.getServiceClass();
    }

    protected String[] getServiceInterfaces() {
        return new String[0];
    }

    protected String getServicePackage() {
        return String.valueOf(this.getMainPackage()) + "." + "Service".toLowerCase();
    }

    protected String getSetConents(TagElement element, String type, String name, String defValue) {
        if ("boolean".equals(type)) {
            boolean val = Boolean.getBoolean(defValue);
            return this.getConfBoolean(element, name, val);
        }
        if ("int".equals(type)) {
            return this.getConfInt(element, name, defValue);
        }
        if ("long".equals(type)) {
            return this.getConfLong(element, name, defValue);
        }
        if ("String".equals(type)) {
            return this.getConfString(element, name, defValue);
        }
        if ("byte".equals(type)) {
            return "(byte) " + this.getConfInt(element, name, defValue);
        }
        return defValue;
    }

    public String getSourceFolderName() {
        String sfName = null;
        sfName = this.useEclipse32Names() ? this.getMainPackage() : this.getMainClassName();
        return sfName;
    }

    protected String getSpecComment() {
        Vector specs = TagElement.collection.getSpecs();
        StringBuffer buffer = new StringBuffer(specs.size() * 64);
        if (specs.size() > 0) {
            buffer.append("<p>");
            buffer.append("See the following specification(s) for more details:\n");
            int i = 0;
            while (i < specs.size()) {
                SpecElement se = (SpecElement)specs.get(i);
                String title = se.getSpecTitle();
                if (title != null) {
                    if (i > 0) {
                        buffer.append("<br>\n");
                    }
                    buffer.append(this.getHtmlHelper().startTable(0, 100, "border=\"2\""));
                    int[] percentages = new int[]{20, 80};
                    buffer.append(this.getHtmlHelper().getTableRow(1, new String[]{"Title:", "<i>" + title + "</i>"}, percentages));
                    if (se.getSpecVersion() != null) {
                        buffer.append(this.getHtmlHelper().getTableRow(1, new String[]{"Version:", se.getSpecVersion()}, percentages));
                    }
                    if (se.getSpecDate() != null) {
                        buffer.append(this.getHtmlHelper().getTableRow(1, new String[]{"Date:", se.getSpecDate()}, percentages));
                    }
                    if (se.getSpecVendor() != null) {
                        buffer.append(this.getHtmlHelper().getTableRow(1, new String[]{"Vendor:", se.getSpecVendor()}, percentages));
                    }
                    if (se.getSpecComment() != null) {
                        buffer.append(this.getHtmlHelper().getTableRow(1, new String[]{"Comment:", se.getSpecComment()}, percentages));
                    }
                    buffer.append(this.getHtmlHelper().endTable(0));
                }
                ++i;
            }
            buffer.append("</p>\n");
        }
        return buffer.toString();
    }

    protected String getSpecReferenceComment(TagElement element) {
        Vector specReferences = element.getAllChildrenWithTagCode(65);
        StringBuffer commentBuffer = new StringBuffer(specReferences.size() * 32);
        int j = 0;
        while (j < specReferences.size()) {
            SpecReferenceElement srElement = (SpecReferenceElement)specReferences.get(j);
            commentBuffer.append(srElement.getSpecReferenceComment());
            commentBuffer.append('\n');
            ++j;
        }
        return commentBuffer.toString();
    }

    public Map getTemplateVariables() {
        String year = String.valueOf(Calendar.getInstance().get(1));
        HashMap<String, String> map = new HashMap<String, String>(101);
        map.put("vendor", this.getVendor());
        map.put("vendors", this.getVendors());
        map.put("provider", this.getProvider());
        map.put("packagebase", this.getPackageBase());
        map.put("version", this.getVersion());
        map.put("year", year);
        map.put("years", year);
        return map;
    }

    protected String getType() {
        return null;
    }

    protected String getUserName(TagElement element) {
        String name = element.getBundleName();
        if (name != null && name.length() > 0) {
            return name;
        }
        return element.getKey();
    }

    protected String getVendor() {
        String vendor = this.fModel.getVendor();
        if (vendor != null) {
            return vendor;
        }
        return this.getProvider();
    }

    protected String getVendors() {
        String vendors = this.fModel.getVendors();
        if (vendors != null) {
            return vendors;
        }
        return this.getVendor();
    }

    protected String getVersion() {
        String version = this.fModel.getVersion();
        if (version != null) {
            return version;
        }
        return "1.0.0";
    }

    protected boolean inThisBundle(String string) {
        String packageOnly = DkUtilities.extractPackage(string);
        if (packageOnly.equals(this.getMainPackage())) {
            return true;
        }
        if (packageOnly.equals(this.getServicePackage())) {
            return true;
        }
        return packageOnly.equals(this.getBundleActivatorPackage());
    }

    protected void init() {
        this.fRoot = this.fModel.getRoot();
        this.fHtmlHelper = new HtmlHelper();
        this.fManifestModel = new ManifestModel();
        if (this.generatedInfo == null) {
            this.generatedInfo = new GeneratedInfo();
        }
        this.buildModel = new BuildModel(this);
        EscPropertiesModel.getModel(this);
    }

    protected void initialize() {
        this.setupExportedPackages();
    }

    protected boolean isAbstract() {
        return false;
    }

    private void organizeManifest() throws Exception {
        this.fManifestModel.organize();
    }

    protected String quote(String original) {
        StringBuffer buffer = new StringBuffer(original.length() + 2);
        buffer.append('\"');
        buffer.append(original);
        buffer.append('\"');
        return buffer.toString();
    }

    protected Vector save() throws Exception {
        JavaFileModel messModel;
        this.saveBuildProperties();
        this.saveManifest();
        Vector<Object> result = new Vector<Object>();
        if (this.fServiceModel != null) {
            this.fServiceModel.setSaver(this.getSaver());
            this.fServiceModel.setSortOrder(3L);
            Object service = this.fServiceModel.save();
            if (service != null) {
                result.addElement(service);
            }
        }
        if (this.fBundleActivatorModel != null) {
            this.fBundleActivatorModel.setSaver(this.getSaver());
            this.fBundleActivatorModel.setSortOrder(3L);
            Object ba = this.fBundleActivatorModel.save();
            if (ba != null) {
                result.addElement(ba);
            }
        }
        if ((messModel = this.getMessageModel()) != null) {
            messModel.setSaver(this.getSaver());
            messModel.setSortOrder(3L);
            Object message = messModel.save();
            if (message != null) {
                result.addElement(message);
            }
        }
        this.organizeManifest();
        return result;
    }

    protected void saveBuildProperties() throws Exception {
        this.buildModel.setBuildSaver(this.buildSaver);
        this.buildModel.save();
    }

    public void saveCommon() throws Exception {
        this.saveBuildProperties();
        this.saveManifest();
    }

    private void saveManifest() throws Exception {
        this.fManifestModel.setAbstract(this.isAbstract());
        this.fManifestModel.setSaver(this.fManifestSaver);
        this.fManifestModel.save();
    }

    public void setBuildSaver(IFileSaver buildSaver) {
        this.buildSaver = buildSaver;
    }

    public void setCustomInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
    }

    public void setGenerateManifest(boolean genManifest) {
        this.osgi = genManifest;
    }

    protected void setMainClassName(String mainClassName) {
        this.fMainClassName = mainClassName;
    }

    protected void setMainPackage(String mainPackage) {
        this.fMainPackage = mainPackage;
    }

    protected void setMainTagElement(TagElement mainElement) {
        this.fMainTagElement = mainElement;
    }

    public void setManifestSaver(IFileSaver manifestSaver) {
        this.fManifestSaver = manifestSaver;
    }

    protected void setMessageModel(JavaFileModel messModel) {
        this.messageModel = messModel;
    }

    protected void setOsgi(boolean osgi) {
        this.osgi = osgi;
    }

    protected void setPackageBase(String packageBase) {
        this.fPackageBase = packageBase;
    }

    public void setSaver(IJavaSaver saver) {
        this.fSaver = saver;
    }

    public void setupExportedPackages() {
        if (this.useEclipse32Names()) {
            this.fManifestModel.setVersion(String.valueOf(this.getVersion()) + ".qualifier");
        } else {
            this.fManifestModel.setVersion(this.getVersion());
        }
        Vector expPackages = this.getManifestExportPackages();
        int i = 0;
        while (i < expPackages.size()) {
            this.fManifestModel.addExportedPackage((String)expPackages.elementAt(i));
            ++i;
        }
        Vector requiredBundles = this.getManifestRequiredBundles();
        int i2 = 0;
        while (i2 < requiredBundles.size()) {
            this.fManifestModel.addRequiredBundle((String)requiredBundles.elementAt(i2));
            ++i2;
        }
        IPackageFragment[] javaPackages = this.getPackages();
        int i3 = 0;
        while (i3 < javaPackages.length) {
            this.fManifestModel.addExportedPackage(javaPackages[i3].getElementName());
            ++i3;
        }
    }

    protected String unquote(String string) {
        if (string.indexOf("\"") == -1) {
            return string;
        }
        StringBuffer sb = new StringBuffer(string);
        while (sb.toString().indexOf("\"") != -1) {
            int qIndex = sb.toString().indexOf("\"");
            sb.replace(qIndex, qIndex + 1, "");
        }
        return sb.toString();
    }

    protected boolean useEclipse32Names() {
        return GeneratorPlugin.useEclipse32Names();
    }
}

