/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.Vector;
import org.eclipse.soda.devicekit.generator.model.AbstractDkGenerator;
import org.eclipse.soda.devicekit.generator.model.DkDeviceGenerator;
import org.eclipse.soda.devicekit.generator.model.FactoryMetaDataBuilder;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationElement;
import org.eclipse.soda.devicekit.generator.model.elements.CustomParameter;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;

public class DeviceFactoryMetaDataBuilder
extends FactoryMetaDataBuilder {
    protected Vector configurations;

    public DeviceFactoryMetaDataBuilder(AbstractDkGenerator generator, int pidType) {
        super(generator, pidType);
    }

    protected String getConfigurationProperty(ConfigurationElement element) {
        String description = element.getDescription();
        String name = element.getExternalId();
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(name);
        buffer.append('=');
        buffer.append(name.replace('/', ' '));
        buffer.append('\n');
        buffer.append(name);
        buffer.append("_description=");
        if (description != null) {
            buffer.append(description);
        }
        buffer.append('\n');
        return buffer.toString();
    }

    protected String getPropertyCustom() throws Exception {
        StringBuffer buffer = new StringBuffer(32 * this.configurations.size());
        int i = 0;
        while (i < this.configurations.size()) {
            buffer.append(this.getConfigurationProperty((ConfigurationElement)this.configurations.get(i)));
            ++i;
        }
        Vector cps = this.getCustomParameters();
        int i2 = 0;
        while (i2 < cps.size()) {
            CustomParameter cp = (CustomParameter)cps.get(i2);
            buffer.append(this.getCustomParameterProperty(cp));
            ++i2;
        }
        return buffer.toString();
    }

    protected String getXmlConfigurationAttributeDefs(String type, String name, String defaultValue, String description, String cardinality, String size) {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("\r\n\t\t<AD id=\"");
        buffer.append(name);
        buffer.append("\"\r\n\t\t\ttype=\"");
        buffer.append(this.getValidMetaType(type));
        buffer.append("\"\r\n");
        if (defaultValue != null) {
            buffer.append(" default=\"");
            buffer.append(defaultValue);
            buffer.append("\"\r\n");
        } else if (cardinality == null) {
            buffer.append("\t\t\tdefault=\"\"\r\n");
        }
        buffer.append("\t\t\tname=\"%");
        buffer.append(name);
        buffer.append("\"\r\n");
        buffer.append("\t\t\tdescription=\"%");
        buffer.append(String.valueOf(name) + "_description");
        buffer.append("\"\r\n");
        if (cardinality != null) {
            buffer.append("\t\t\tcardinality=\"");
            if ("ARRAY".equals(cardinality)) {
                if (size != null) {
                    buffer.append(size);
                } else {
                    buffer.append(Integer.MAX_VALUE);
                }
            } else if (size != null) {
                buffer.append('-');
                buffer.append(size);
            } else {
                buffer.append(Integer.MIN_VALUE);
            }
            buffer.append("\"\r\n");
        } else {
            buffer.append("\t\t\tcardinality=\"0\"\r\n");
        }
        buffer.append("\t\t\trequired=\"false\"");
        buffer.append("/>\r\n");
        return buffer.toString();
    }

    protected String getXmlConfigurationAttributeId(String name) {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("\t\t<ATTRIBUTE ID=\"");
        buffer.append(this.getValidMetaType(name));
        buffer.append("\" REQUIRED=\"no\"/>\n");
        return buffer.toString();
    }

    protected String getXmlCustomAttributeDefs() throws Exception {
        StringBuffer buffer = new StringBuffer(this.configurations.size() * 64);
        int i = 0;
        while (i < this.configurations.size()) {
            ConfigurationElement element = (ConfigurationElement)this.configurations.get(i);
            String name = element.getExternalId();
            String type = element.getType();
            String defaultValue = element.getDefaultValue();
            String description = element.getDescription();
            String cardinality = element.getCardinality();
            String size = element.getSize();
            buffer.append(this.getXmlConfigurationAttributeDefs(type, name, defaultValue, description, cardinality, size));
            ++i;
        }
        Vector cps = this.getCustomParameters();
        if (cps != null && cps.size() > 0) {
            buffer.append(this.getXmlCustomParameterAttributeDefs());
        }
        return buffer.toString();
    }

    protected String getXmlCustomAttributeIds() throws Exception {
        StringBuffer buffer = new StringBuffer(this.configurations.size() * 32);
        int i = 0;
        while (i < this.configurations.size()) {
            ConfigurationElement element = (ConfigurationElement)this.configurations.get(i);
            String name = element.getExternalId();
            buffer.append(this.getXmlConfigurationAttributeId(name));
            ++i;
        }
        return buffer.toString();
    }

    protected void init() {
        super.init();
        DkDeviceGenerator generator = (DkDeviceGenerator)this.getGenerator();
        MainTagElement element = generator.getDeviceElement();
        this.configurations = element.getConfigurations();
        this.setCustomParameters(element.getAllChildrenWithTagCode(46));
        Vector elements = element.getAllChildrenWithTagCodes(new int[]{86}, new int[]{85});
        Vector parents = element.getAllChildrenWithTagCodes(new int[]{86}, new int[]{83});
        if (parents != null) {
            int i = 0;
            while (i < parents.size()) {
                TagElement parent = (TagElement)parents.elementAt(i);
                Vector moreElements = parent.getAllChildrenWithTagCodes(new int[]{86}, new int[]{85});
                if (moreElements != null) {
                    elements.addAll(moreElements);
                }
                ++i;
            }
        }
        this.setProfiles(elements);
    }
}

