/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.soda.devicekit.generator.build.BuildSaver;
import org.eclipse.soda.devicekit.generator.html.ExternalHtmlGenerator;
import org.eclipse.soda.devicekit.generator.manifest.SourceFolderManifestSaver;
import org.eclipse.soda.devicekit.generator.metadata.model.CustomInfo;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.metadata.processing.CustomElementLoader;
import org.eclipse.soda.devicekit.generator.metadata.processing.MetaDataSaver;
import org.eclipse.soda.devicekit.generator.model.AbstractDkGenerator;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkAdapterBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkAdapterGenerator;
import org.eclipse.soda.devicekit.generator.model.DkAdapterTestGenerator;
import org.eclipse.soda.devicekit.generator.model.DkAgentBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkAgentGenerator;
import org.eclipse.soda.devicekit.generator.model.DkAgentTestGenerator;
import org.eclipse.soda.devicekit.generator.model.DkConcreteBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkConcreteGenerator;
import org.eclipse.soda.devicekit.generator.model.DkConcreteTestGenerator;
import org.eclipse.soda.devicekit.generator.model.DkDeviceBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkDeviceGenerator;
import org.eclipse.soda.devicekit.generator.model.DkDeviceTestCaseGenerator;
import org.eclipse.soda.devicekit.generator.model.DkDeviceTestGenerator;
import org.eclipse.soda.devicekit.generator.model.DkProfileBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkProfileGenerator;
import org.eclipse.soda.devicekit.generator.model.DkProfileTestGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTestAgentBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTestAgentGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTestBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTestCaseGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTestGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTransportBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTransportGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTransportTestCaseGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTransportTestGenerator;
import org.eclipse.soda.devicekit.generator.model.EscPropertiesModel;
import org.eclipse.soda.devicekit.generator.model.elements.AdapterElement;
import org.eclipse.soda.devicekit.generator.model.elements.AgentElement;
import org.eclipse.soda.devicekit.generator.model.elements.DeviceElement;
import org.eclipse.soda.devicekit.generator.model.elements.ProfileElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestAgentElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestElement;
import org.eclipse.soda.devicekit.generator.model.elements.TransportElement;
import org.eclipse.soda.devicekit.generator.save.java.eclipse.DeviceKitJavaSaver;
import org.eclipse.soda.devicekit.generator.sim.DKDeviceJunitTestGenerator;
import org.eclipse.soda.devicekit.generator.sim.DkDeviceMonitorTestGenerator;
import org.eclipse.soda.devicekit.generator.sim.DkDevicePlayBackTestGenerator;
import org.eclipse.soda.devicekit.generator.sim.DkTransportJunitTestGenerator;
import org.eclipse.soda.devicekit.generator.sim.DkTransportMonitorTestGenerator;
import org.eclipse.soda.devicekit.generator.sim.DkTransportPlayBackTestGenerator;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.util.PreGenElementHolder;
import org.w3c.dom.Node;

public class DeviceKitGenerator {
    private static ResourceBundle DefaultResourceBundle;
    private String schema = null;
    private IJavaProject javaProject;
    private boolean genTestScript = false;
    private Hashtable properties;
    private DeviceKitTagModel fDkFileModel;
    private IFile dkmlFile;
    private IFile metaDataFile;
    private boolean keepCustom;
    private Vector fReferences;
    private Vector fGeneratedFiles;
    private PreGenElementHolder customHolder;
    protected boolean genManifest;
    private GeneratedInfo generatedInfo;
    private CustomInfo customInfo;
    private boolean useMetaData = true;
    private IProgressMonitor progressMonitor;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.model.DeviceKitGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = ResourceBundle.getBundle(String.valueOf(clazz.getName()) + "ResourceBundle");
    }

    public DeviceKitGenerator(IFile file) {
        this((IProgressMonitor)new NullProgressMonitor(), file, new Vector(), false, false);
    }

    public DeviceKitGenerator(IProgressMonitor progressMonitor, IFile file, Vector references, boolean custom, boolean genManifest) {
        this.setProgressMonitor(progressMonitor);
        this.dkmlFile = file;
        this.fReferences = references;
        this.fGeneratedFiles = new Vector();
        this.keepCustom = custom;
        this.genManifest = genManifest;
    }

    public static String getResource(String key) {
        return DefaultResourceBundle.getString(key);
    }

    protected boolean doKeepCustom() {
        return this.keepCustom;
    }

    public void generate() throws Exception {
        this.initialize();
        Vector types = this.fDkFileModel.getRoot().getRootTypes();
        int i = 0;
        while (i < types.size()) {
            Vector result = this.generate((TagElement)types.elementAt(i));
            if (result != null && result.size() > 0) {
                this.fGeneratedFiles = DeviceKitUtilities.mergeVectors(result, this.fGeneratedFiles);
            }
            this.generateEscProperties();
            if (this.useMetaData) {
                this.generateMetaData();
            }
            this.generateHtmlFiles((TagElement)types.elementAt(i));
            ++i;
        }
    }

    private Vector generate(TagElement element) throws Exception {
        switch (element.getTagCode()) {
            case 18: {
                return this.generateConcrete(element);
            }
            case 8: {
                return this.generateDevice(element);
            }
            case 10: {
                return this.generateTest(element);
            }
            case 87: {
                return this.generateTestAgent(element);
            }
            case 9: {
                return this.generateTransport(element);
            }
            case 91: {
                return this.generateAgent(element);
            }
            case 72: {
                return this.generateAdapter(element);
            }
            case 74: {
                return this.generateProfile(element);
            }
        }
        return new Vector();
    }

    protected Vector generateAdapter(TagElement element) throws Exception {
        Vector subResult;
        SubProgressMonitor subMonitor = new SubProgressMonitor(this.getProgressMonitor(), 4);
        String tagName = element.getProjectId();
        subMonitor.subTask(tagName);
        AdapterElement deviceElement = (AdapterElement)element;
        DkAdapterGenerator gen = new DkAdapterGenerator(this.fDkFileModel, this.generatedInfo);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(this.getFile().getProject().getName(), this.getProgressMonitor()));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setBuildSaver(new BuildSaver(jProject));
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        Vector result = gen.save();
        subMonitor.worked(1);
        if (deviceElement.isBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateAdapterBundle(1);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        if (deviceElement.isManagedBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".managed");
            subResult = this.generateAdapterBundle(2);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        if (deviceElement.isManagedFactoryBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".factory");
            subResult = this.generateAdapterBundle(3);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        return result;
    }

    private Vector generateAdapterBundle(int type) throws Exception {
        DkAdapterBundleGenerator gen = new DkAdapterBundleGenerator(this.fDkFileModel, this.generatedInfo, this.properties, type);
        gen.setGenerateManifest(true);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), this.getProgressMonitor()));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), true, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        return gen.save();
    }

    private Vector generateAgent(TagElement element) throws Exception {
        Vector subResult;
        SubProgressMonitor subMonitor = new SubProgressMonitor(this.getProgressMonitor(), 4);
        String tagName = element.getProjectId();
        subMonitor.subTask(tagName);
        AgentElement profileElement = (AgentElement)element;
        DkAgentGenerator gen = new DkAgentGenerator(this.fDkFileModel, this.generatedInfo);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(this.getFile().getProject().getName(), this.getProgressMonitor()));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setBuildSaver(new BuildSaver(jProject));
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        Vector result = gen.save();
        subMonitor.worked(1);
        if (profileElement.isBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateAgentBundle(1);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        if (profileElement.isManagedBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".managed");
            subResult = this.generateAgentBundle(2);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        if (profileElement.isManagedFactoryBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".factory");
            subResult = this.generateAgentBundle(3);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        this.generateHtml(element, this.fDkFileModel);
        return result;
    }

    private Vector generateAgentBundle(int type) throws Exception {
        DkAgentBundleGenerator gen = new DkAgentBundleGenerator(this.fDkFileModel, this.generatedInfo, this.properties, type);
        gen.setGenerateManifest(true);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), this.getProgressMonitor()));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), true, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        return gen.save();
    }

    protected Vector generateConcrete(TagElement element) throws Exception {
        Vector subResult;
        SubProgressMonitor subMonitor = new SubProgressMonitor(this.getProgressMonitor(), 4);
        String tagName = element.getProjectId();
        subMonitor.subTask(tagName);
        DeviceElement deviceElement = (DeviceElement)element;
        DkConcreteGenerator gen = new DkConcreteGenerator(this.fDkFileModel, this.generatedInfo);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(this.getFile().getProject().getName(), this.getProgressMonitor()));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        Vector result = gen.save();
        subMonitor.worked(1);
        if (deviceElement.isBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateConcreteBundle(1);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        if (deviceElement.isManagedBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".managed");
            subResult = this.generateConcreteBundle(2);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        if (deviceElement.isManagedFactoryBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".factory");
            subResult = this.generateConcreteBundle(3);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        return result;
    }

    private Vector generateConcreteBundle(int type) throws Exception {
        DkConcreteBundleGenerator gen = new DkConcreteBundleGenerator(this.fDkFileModel, this.generatedInfo, this.properties, type);
        gen.setGenerateManifest(true);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), this.getProgressMonitor()));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), true, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(this.javaProject));
        return gen.save();
    }

    protected Vector generateDevice(TagElement element) throws Exception {
        Vector subResult;
        SubProgressMonitor subMonitor = new SubProgressMonitor(this.getProgressMonitor(), 4);
        String tagName = element.getProjectId();
        subMonitor.subTask(tagName);
        DeviceElement deviceElement = (DeviceElement)element;
        DkDeviceGenerator gen = new DkDeviceGenerator(this.fDkFileModel, this.generatedInfo);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), this.getProgressMonitor()));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        Vector result = ((AbstractDkGenerator)gen).save();
        subMonitor.worked(1);
        if (deviceElement.isBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateDeviceBundle(1);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        if (deviceElement.isManagedBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".managed");
            subResult = this.generateDeviceBundle(2);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        if (deviceElement.isManagedFactoryBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".factory");
            subResult = this.generateDeviceBundle(3);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        return result;
    }

    private Vector generateDeviceBundle(int type) throws Exception {
        DkDeviceBundleGenerator gen = new DkDeviceBundleGenerator(this.fDkFileModel, this.generatedInfo, this.properties, type);
        gen.setGenerateManifest(true);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        ((AbstractDkGenerator)gen).generate();
        gen.setSaver(new DeviceKitJavaSaver(((AbstractDkGenerator)gen).getSourceFolderName(), this.getProgressMonitor()));
        IJavaProject jProject = this.getJavaProject(((AbstractDkGenerator)gen).getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, ((AbstractDkGenerator)gen).getSourceFolderName(), true, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        return ((AbstractDkGenerator)gen).save();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateEscProperties() throws IOException, CoreException {
        ByteArrayInputStream bis;
        InputStream currentContents;
        block11: {
            IProject project = this.getFile().getProject();
            EscPropertiesModel model = EscPropertiesModel.getModel(null);
            currentContents = null;
            InputStream stream = null;
            bis = null;
            IFile escProperties = project.getFile("esc.properties");
            try {
                if (escProperties != null && escProperties.exists()) {
                    stream = escProperties.getContents();
                    String contents = model.getFileContents(stream, true, true);
                    bis = new ByteArrayInputStream(contents.getBytes());
                    currentContents = escProperties.getContents();
                    if (!DeviceKitUtilities.sameStream(currentContents, bis)) {
                        bis.reset();
                        escProperties.setContents((InputStream)bis, true, true, null);
                    }
                } else {
                    String contents = model.getFileContents(null, true, true);
                    bis = new ByteArrayInputStream(contents.getBytes());
                    escProperties.create((InputStream)bis, true, null);
                }
                Object var8_11 = null;
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (stream != null) {
                    stream.close();
                }
                if (bis != null) {
                    bis.close();
                }
                if (currentContents != null) {
                    currentContents.close();
                }
                throw throwable;
            }
            stream.close();
        }
        if (bis != null) {
            bis.close();
        }
        if (currentContents != null) {
            currentContents.close();
        }
        EscPropertiesModel.resetModel();
    }

    public void generateHtml(TagElement element, DeviceKitTagModel dkFileModel) {
    }

    public void generateHtmlFiles(TagElement tag) {
        ExternalHtmlGenerator externalHtmlGenerator = new ExternalHtmlGenerator(tag, this.fDkFileModel, this.dkmlFile);
        externalHtmlGenerator.generate();
    }

    private Vector generateJunitTest(TestElement element, int testType) throws Exception {
        DkTestGenerator gen = null;
        gen = testType == 8 ? new DKDeviceJunitTestGenerator(this.fDkFileModel, this.generatedInfo) : new DkTransportJunitTestGenerator(this.fDkFileModel, this.generatedInfo);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        Vector junits = element.getAllChildrenWithTagCode(49);
        String script = ((TagElement)junits.elementAt(0)).getAttribute("antscript");
        this.genTestScript = script == null || script.equals("true");
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), this.getProgressMonitor()));
        return gen.save();
    }

    protected void generateMetaData() throws Exception {
        MetaDataSaver saver = new MetaDataSaver(this.metaDataFile);
        saver.save(this.generatedInfo);
    }

    private Vector generatePlayBackTest(TestElement element, int testType) throws Exception {
        DkTestGenerator gen = null;
        gen = testType == 8 ? new DkDevicePlayBackTestGenerator(this.fDkFileModel, this.generatedInfo) : new DkTransportPlayBackTestGenerator(this.fDkFileModel, this.generatedInfo);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), this.getProgressMonitor()));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        return gen.save();
    }

    protected Vector generateProfile(TagElement element) throws Exception {
        Vector subResult;
        SubProgressMonitor subMonitor = new SubProgressMonitor(this.getProgressMonitor(), 4);
        String tagName = element.getProjectId();
        subMonitor.subTask(tagName);
        ProfileElement profileElement = (ProfileElement)element;
        DkProfileGenerator gen = new DkProfileGenerator(this.fDkFileModel, this.generatedInfo);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(this.getFile().getProject().getName(), this.getProgressMonitor()));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setBuildSaver(new BuildSaver(jProject));
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        Vector result = gen.save();
        subMonitor.worked(1);
        if (profileElement.isBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateProfileBundle(1);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        if (profileElement.isManagedBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".managed");
            subResult = this.generateProfileBundle(2);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        if (profileElement.isManagedFactoryBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".factory");
            subResult = this.generateProfileBundle(3);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        this.generateHtml(element, this.fDkFileModel);
        subMonitor.worked(1);
        return result;
    }

    private Vector generateProfileBundle(int type) throws Exception {
        DkProfileBundleGenerator gen = new DkProfileBundleGenerator(this.fDkFileModel, this.generatedInfo, this.properties, type);
        gen.setGenerateManifest(true);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), this.getProgressMonitor()));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), true, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        return gen.save();
    }

    private Vector generateRecordTest(TestElement element, int testType) throws Exception {
        DkTestGenerator gen = null;
        gen = testType == 8 ? new DkDeviceMonitorTestGenerator(this.fDkFileModel, this.generatedInfo) : new DkTransportMonitorTestGenerator(this.fDkFileModel, this.generatedInfo);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), this.getProgressMonitor()));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        return gen.save();
    }

    protected Vector generateTest(TagElement element) throws Exception {
        SubProgressMonitor subMonitor = new SubProgressMonitor(this.getProgressMonitor(), 4);
        String tagName = element.getProjectId();
        subMonitor.subTask(tagName);
        Vector result = null;
        DkTestGenerator gen = null;
        TestElement testElement = (TestElement)element;
        int testType = -1;
        if (testElement.getAllChildrenWithTagCode(8).size() > 0) {
            gen = new DkDeviceTestGenerator(this.fDkFileModel, this.generatedInfo);
            testType = 8;
        } else if (testElement.getAllChildrenWithTagCode(9).size() > 0) {
            gen = new DkTransportTestGenerator(this.fDkFileModel, this.generatedInfo);
            testType = 9;
        } else if (testElement.getAllChildrenWithTagCode(91).size() > 0) {
            gen = new DkAgentTestGenerator(this.fDkFileModel, this.generatedInfo);
            testType = 91;
        } else if (testElement.getAllChildrenWithTagCode(18).size() > 0) {
            gen = new DkConcreteTestGenerator(this.fDkFileModel, this.generatedInfo);
            testType = 18;
        } else if (testElement.getAllChildrenWithTagCode(72).size() > 0) {
            gen = new DkAdapterTestGenerator(this.fDkFileModel, this.generatedInfo);
            testType = 72;
        } else if (testElement.getAllChildrenWithTagCode(74).size() > 0) {
            gen = new DkProfileTestGenerator(this.fDkFileModel, this.generatedInfo);
            testType = 74;
        }
        subMonitor.worked(1);
        if (gen != null) {
            Vector subResult;
            gen.setGenerateManifest(this.genManifest);
            if (this.useMetaData) {
                gen.setCustomInfo(this.customInfo);
            }
            gen.generate();
            gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), this.getProgressMonitor()));
            IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
            gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
            gen.setBuildSaver(new BuildSaver(jProject));
            result = gen.save();
            if (testElement.getAllChildrenWithTagCode(48).size() > 0) {
                subResult = this.generateRecordTest(testElement, testType);
                DeviceKitUtilities.mergeVectors(result, subResult);
            }
            if (testElement.getAllChildrenWithTagCode(47).size() > 0) {
                subResult = this.generatePlayBackTest(testElement, testType);
                DeviceKitUtilities.mergeVectors(result, subResult);
            }
            if (testElement.getAllChildrenWithTagCode(49).size() > 0) {
                subResult = this.generateJunitTest(testElement, testType);
                DeviceKitUtilities.mergeVectors(result, subResult);
            }
            if (testElement.getAllChildrenWithTagCode(71).size() > 0) {
                subResult = this.generateTestCase(testElement, testType);
                DeviceKitUtilities.mergeVectors(result, subResult);
            }
            if (testElement.isBundle()) {
                subMonitor.subTask(String.valueOf(tagName) + ".bundle");
                subResult = this.generateTestBundle(testElement, testType, 1);
                DeviceKitUtilities.mergeVectors(result, subResult);
            }
            subMonitor.worked(1);
            if (testElement.isManagedBundle()) {
                subMonitor.subTask(String.valueOf(tagName) + ".managed");
                subResult = this.generateTestBundle(testElement, testType, 2);
                DeviceKitUtilities.mergeVectors(result, subResult);
            }
            subMonitor.worked(1);
            if (testElement.isManagedFactoryBundle()) {
                subMonitor.subTask(String.valueOf(tagName) + ".factory");
                subResult = this.generateTestBundle(testElement, testType, 3);
                DeviceKitUtilities.mergeVectors(result, subResult);
            }
            subMonitor.worked(1);
        }
        subMonitor.done();
        return result;
    }

    protected Vector generateTestAgent(TagElement element) throws Exception {
        Vector subResult;
        SubProgressMonitor subMonitor = new SubProgressMonitor(this.getProgressMonitor(), 4);
        String tagName = element.getProjectId();
        subMonitor.subTask(tagName);
        Vector result = null;
        TestAgentElement testAgentElement = (TestAgentElement)element;
        DkTestAgentGenerator gen = new DkTestAgentGenerator(this.fDkFileModel, this.generatedInfo);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), this.getProgressMonitor()));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        result = gen.save();
        subMonitor.worked(1);
        if (testAgentElement.isBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateTestAgentBundle(testAgentElement, 1);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        if (testAgentElement.isManagedBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateTestAgentBundle(testAgentElement, 2);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        if (testAgentElement.isManagedFactoryBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateTestAgentBundle(testAgentElement, 3);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        return result;
    }

    private Vector generateTestAgentBundle(TestAgentElement testElement, int type_bundle) {
        Vector result = new Vector();
        DkTestAgentBundleGenerator gen = new DkTestAgentBundleGenerator(this.fDkFileModel, this.generatedInfo, type_bundle);
        if (gen != null) {
            gen.setGenerateManifest(this.genManifest);
            if (this.useMetaData) {
                gen.setCustomInfo(this.customInfo);
            }
            try {
                ((AbstractDkGenerator)gen).generate();
                gen.setSaver(new DeviceKitJavaSaver(((AbstractDkGenerator)gen).getSourceFolderName(), this.getProgressMonitor()));
                IJavaProject jProject = this.getJavaProject(((AbstractDkGenerator)gen).getSourceFolderName());
                gen.setManifestSaver(new SourceFolderManifestSaver(jProject, ((AbstractDkGenerator)gen).getSourceFolderName(), true, gen.getOtherManifestFiles()));
                gen.setBuildSaver(new BuildSaver(jProject));
                result = ((AbstractDkGenerator)gen).save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private Vector generateTestBundle(TestElement testElement, int testType, int type_bundle) {
        Vector result = new Vector();
        AbstractDkGenerator gen = null;
        switch (testType) {
            case 8: 
            case 9: 
            case 72: 
            case 74: {
                gen = new DkTestBundleGenerator(this.fDkFileModel, this.generatedInfo, type_bundle, testType);
            }
        }
        if (gen != null) {
            gen.setGenerateManifest(this.genManifest);
            if (this.useMetaData) {
                gen.setCustomInfo(this.customInfo);
            }
            try {
                ((DkTestBundleGenerator)gen).generate();
                gen.setSaver(new DeviceKitJavaSaver(((DkTestBundleGenerator)gen).getSourceFolderName(), this.getProgressMonitor()));
                IJavaProject jProject = this.getJavaProject(((DkTestBundleGenerator)gen).getSourceFolderName());
                gen.setManifestSaver(new SourceFolderManifestSaver(jProject, ((DkTestBundleGenerator)gen).getSourceFolderName(), true, gen.getOtherManifestFiles()));
                gen.setBuildSaver(new BuildSaver(jProject));
                result = ((DkTestBundleGenerator)gen).save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private Vector generateTestCase(TestElement element, int testType) throws Exception {
        DkTestCaseGenerator gen = null;
        if (testType == 8) {
            gen = new DkDeviceTestCaseGenerator(this.fDkFileModel, this.generatedInfo);
        } else if (testType == 9) {
            gen = new DkTransportTestCaseGenerator(this.fDkFileModel, this.generatedInfo);
        }
        if (gen != null) {
            if (this.useMetaData) {
                gen.setCustomInfo(this.customInfo);
            }
            gen.generate();
            gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), this.getProgressMonitor()));
            IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
            gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
            gen.setBuildSaver(new BuildSaver(jProject));
            return gen.save();
        }
        return new Vector();
    }

    public boolean generateTestScript() {
        return this.genTestScript;
    }

    protected Vector generateTransport(TagElement element) throws Exception {
        Vector subResult;
        SubProgressMonitor subMonitor = new SubProgressMonitor(this.getProgressMonitor(), 4);
        String tagName = element.getProjectId();
        subMonitor.subTask(tagName);
        TransportElement transportElement = (TransportElement)element;
        if (this.doKeepCustom() && (this.metaDataFile == null || !this.metaDataFile.exists())) {
            this.saveCustomElements(9);
        }
        DkTransportGenerator gen = new DkTransportGenerator(this.fDkFileModel, this.generatedInfo, this.properties);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        DeviceKitJavaSaver saver = new DeviceKitJavaSaver(gen.getSourceFolderName(), this.getProgressMonitor());
        gen.setSaver(saver);
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        Vector result = ((AbstractDkGenerator)gen).save();
        subMonitor.worked(1);
        if (transportElement.isBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateTransportBundle(1);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        if (transportElement.isManagedBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".managed");
            subResult = this.generateTransportBundle(2);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        if (transportElement.isManagedFactoryBundle()) {
            subMonitor.subTask(String.valueOf(tagName) + ".factory");
            subResult = this.generateTransportBundle(3);
            DeviceKitUtilities.mergeVectors(result, subResult);
        }
        subMonitor.worked(1);
        return result;
    }

    private Vector generateTransportBundle(int type) throws Exception {
        DkTransportBundleGenerator gen = new DkTransportBundleGenerator(this.fDkFileModel, this.generatedInfo, this.properties, type);
        gen.setGenerateManifest(true);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), this.getProgressMonitor()));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), true, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        return gen.save();
    }

    public PreGenElementHolder getCustomHolder() {
        return this.customHolder;
    }

    protected IFile getFile() {
        return this.dkmlFile;
    }

    public Vector getGeneratedFiles() {
        return this.fGeneratedFiles;
    }

    private IJavaProject getJavaProject(String name) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = ws.getRoot();
        IProject project = root.getProject(name);
        IJavaProject jProject = JavaCore.create((IProject)project);
        if (project.exists()) {
            try {
                project.refreshLocal(2, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return jProject;
    }

    public IProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = new NullProgressMonitor();
        }
        return this.progressMonitor;
    }

    public Node getXmlDocument() {
        if (this.fDkFileModel != null) {
            return this.fDkFileModel.getXmlDocument();
        }
        return null;
    }

    private void initialize() throws Exception {
        IProject project = this.getFile().getProject();
        this.javaProject = JavaCore.create((IProject)project);
        this.fDkFileModel = new DeviceKitTagModel(this.getFile().getContents(), this.fReferences, this.schema);
        this.fDkFileModel.build();
        if (this.useMetaData) {
            this.loadCustomElements();
            if (this.generatedInfo != null) {
                this.generatedInfo.prepareOldElement(this.fDkFileModel.getVersion());
            } else {
                this.generatedInfo = new GeneratedInfo();
            }
        }
    }

    protected void loadCustomElements() {
        if (this.javaProject != null && this.javaProject.exists()) {
            CustomElementLoader loader = new CustomElementLoader(this.javaProject, this.dkmlFile);
            try {
                this.customInfo = loader.loadCustomInfo();
                this.generatedInfo = loader.getGeneratedInfo();
                this.metaDataFile = loader.getMetaDataFile();
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    protected void saveCustomElements(int tagCode) {
        PreGenElementHolder peh;
        if (this.javaProject != null && this.javaProject.exists() && (peh = new PreGenElementHolder(this.fDkFileModel, tagCode, this.javaProject)).exists()) {
            this.setCustomHolder(peh);
        }
    }

    protected void setCustomHolder(PreGenElementHolder peh) {
        this.customHolder = peh;
    }

    public void setMethodProperties(Hashtable properties) {
        this.properties = properties;
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void setReferencedFiles(Vector references) {
        this.fReferences = references;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }
}

