/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.model.DeviceKitGeneratorMessages;
import org.eclipse.soda.devicekit.generator.model.GenXmlErrorHandler;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.RootElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DeviceKitTagModel {
    private String schema;
    private Document fMainDoc;
    private RootElement fRoot;
    private InputStream fStream;
    private Vector fReferences;

    public DeviceKitTagModel(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public DeviceKitTagModel(File file, Vector references) throws FileNotFoundException {
        this(new FileInputStream(file), references);
    }

    public DeviceKitTagModel(InputStream stream) {
        this(stream, new Vector());
    }

    public DeviceKitTagModel(InputStream stream, Vector references) {
        this.fStream = stream;
        this.fReferences = references;
    }

    public DeviceKitTagModel(InputStream stream, Vector references, String schema) {
        this.fStream = stream;
        this.fReferences = references;
        this.schema = schema;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build() throws Exception {
        try {
            this.fMainDoc = this.doDomParse();
            Node root = ParserUtilities.findChildNode("dkml", this.fMainDoc);
            if (root == null) throw new Exception(DeviceKitGeneratorMessages.getString("DkTagModel.error.dkml.tag.required"));
            RootElement rootElement = new RootElement(root, this.fReferences);
            this.setRoot(rootElement);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fStream.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fStream.close();
    }

    private Document doDomParse() throws Exception {
        return ParserUtilities.parseDeviceKit(this.fStream, new GenXmlErrorHandler());
    }

    public MainTagElement getMainElement() {
        Vector children = this.getRoot().getChildren();
        int i = 0;
        while (i < children.size()) {
            Object object = children.elementAt(i);
            if (object instanceof MainTagElement) {
                return (MainTagElement)object;
            }
            ++i;
        }
        return null;
    }

    public String getProvider() {
        MainTagElement mainElement = this.getMainElement();
        if (mainElement != null) {
            return mainElement.getProvider();
        }
        return this.getRoot().getVersion();
    }

    public RootElement getRoot() {
        return this.fRoot;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getVendor() {
        MainTagElement mainElement = this.getMainElement();
        if (mainElement != null) {
            return mainElement.getVendor();
        }
        return this.getRoot().getVendor();
    }

    public String getVendors() {
        MainTagElement mainElement = this.getMainElement();
        if (mainElement != null) {
            return mainElement.getVendors();
        }
        return this.getRoot().getVendor();
    }

    public String getVersion() {
        MainTagElement mainElement = this.getMainElement();
        if (mainElement != null) {
            return mainElement.getVersion();
        }
        return this.getRoot().getVersion();
    }

    public Node getXmlDocument() {
        return this.fMainDoc;
    }

    private void setRoot(RootElement root) {
        this.fRoot = root;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }
}

