/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkProfileGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.AdapterElement;
import org.eclipse.soda.devicekit.generator.model.elements.AgentElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class DkAgentGenerator
extends DkProfileGenerator {
    public DkAgentGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    public DkAgentGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Hashtable table, int bundleType) {
        super(model, generatedInfo, table, bundleType);
    }

    protected String getBASuperClass() {
        switch (this.bundleType) {
            case 2: {
                return DeviceKitGenerationConstants.CLASS_AGENT_MANAGED_BA;
            }
            case 3: {
                return DeviceKitGenerationConstants.CLASS_AGENT_MANAGED_FACTORY_BA;
            }
        }
        return DeviceKitGenerationConstants.CLASS_AGENT_BUNDLE_ACTIVATOR;
    }

    protected void initialize() {
        Vector services = this.getRootElement().getAllChildrenWithTagCode(91);
        AgentElement profile = (AgentElement)services.elementAt(0);
        this.setDevice(profile);
        Vector devices = profile.getAllChildrenWithTagCode(8);
        if (devices.size() > 0) {
            MainTagElement device = (MainTagElement)devices.elementAt(0);
            this.setTargetDevice(device);
        }
        this.setMainTagElement(profile);
        String className = DeviceKitUtilities.getClassNameFromTagElement(profile);
        this.setMainClassName(className);
        Vector adapters = this.getMainElement().getAllChildrenWithTagCode(72);
        if (adapters.size() > 0) {
            AdapterElement adapaterService = (AdapterElement)adapters.elementAt(0);
            this.setTargetAdapter(adapaterService);
        }
        this.setPackageBase(profile.getPackageBase());
        this.setMainPackage(DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase()));
        if (profile.getAttribute("lazy") == null || "false".equals(profile.getAttribute("lazy"))) {
            this.setLazy(false);
        } else {
            this.setLazy(true);
        }
        if (profile.hasChildWithTagCode(45)) {
            this.setInitializeMeasurements(true);
        } else {
            this.setInitializeMeasurements(false);
        }
        String initWithMethod = profile.getAttribute("createmethod");
        if (initWithMethod != null && initWithMethod.trim().toLowerCase().equals("true")) {
            this.setInitializeWithMethod(true);
        } else {
            this.setInitializeWithMethod(false);
        }
        this.setupExportedPackages();
        this.initializeGet();
    }
}

