/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkDeviceTestGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.ConcreteElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class DkConcreteTestGenerator
extends DkDeviceTestGenerator {
    public DkConcreteTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        this(model, generatedInfo, new Hashtable());
    }

    public DkConcreteTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Hashtable methodProperties) {
        super(model, generatedInfo, methodProperties);
    }

    protected String getModelName() {
        Vector concretes = this.fTest.getAllChildrenWithTagCode(18);
        TagElement concrete = (TagElement)concretes.elementAt(0);
        String name = concrete.getImplementation();
        if (name != null && name.indexOf(46) == -1) {
            String pack = DeviceKitUtilities.getPackageFromClassName(name, this.getPackageBase());
            name = String.valueOf(pack) + '.' + name;
        }
        return name;
    }

    protected String getModelServiceName() {
        Vector concretes = this.fTest.getAllChildrenWithTagCode(18);
        String service = null;
        TagElement concrete = (TagElement)concretes.elementAt(0);
        service = concrete.getAttribute("service") != null ? concrete.getAttribute("service") : concrete.getImplementation();
        if (service != null) {
            if (!service.endsWith("Service")) {
                service = String.valueOf(service) + "Service";
            }
            if (service.indexOf(46) == -1) {
                service = String.valueOf(DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase())) + '.' + service;
            }
            return service;
        }
        return "";
    }

    protected boolean isAbstract() {
        Vector cons = this.getMainElement().getAllChildrenWithTagCode(18);
        ConcreteElement con = (ConcreteElement)cons.elementAt(0);
        String abs = con.getAttribute("abstract");
        return abs != null && abs.equals("true");
    }
}

