/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.AbstractDkGenerator;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.ConnectionElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.JavaFileModel;

public class DkConnectionGenerator
extends AbstractDkGenerator {
    private ConnectionElement fConnection;
    protected int bundleType = 0;

    public DkConnectionGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    public DkConnectionGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Hashtable methodProperties) {
        super(model, generatedInfo, methodProperties);
    }

    protected void generateSpecificClass() throws Exception {
    }

    protected String getBASuperClass() {
        switch (this.bundleType) {
            case 2: {
                return DeviceKitGenerationConstants.CLASS_TRANSPORT_MANAGED_BA;
            }
            case 3: {
                return DeviceKitGenerationConstants.CLASS_TRANSPORT_MANAGED_FACTORY_BA;
            }
        }
        if (this.getConnectionElement().getTransportServiceChildren().size() > 0) {
            return DeviceKitGenerationConstants.CLASS_TRANSPORT_BA_TUNNEL;
        }
        return DeviceKitGenerationConstants.CLASS_TRANSPORT_BA;
    }

    public int getBundleType() {
        return this.bundleType;
    }

    protected ConnectionElement getConnectionElement() {
        if (this.fConnection != null) {
            return this.fConnection;
        }
        return this.getConnectionElement(this.getRootElement());
    }

    protected ConnectionElement getConnectionElement(TagElement parent) {
        Vector children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (36 == ((TagElement)children.elementAt(i)).getTagCode()) {
                return (ConnectionElement)children.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public JavaFileModel getMainModel() {
        return null;
    }

    protected String[] getManifestCategories() {
        return new String[]{"device"};
    }

    public Hashtable getOtherManifestFiles() {
        return this.otherManifestFiles;
    }

    public void setBundleType(int bundleType) {
        this.bundleType = bundleType;
    }

    public void setOtherManifestFiles(Hashtable otherManifestFiles) {
        this.otherManifestFiles = otherManifestFiles;
    }
}

