/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkAdapterGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.AdapterElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.ProfileElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class DkProfileGenerator
extends DkAdapterGenerator {
    private AdapterElement targetAdapter = null;

    public DkProfileGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    public DkProfileGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Hashtable table, int bundleType) {
        super(model, generatedInfo, table, bundleType);
    }

    protected void codeInterestFilterField(IType device) {
    }

    protected void codeServiceFields(IType service) {
        super.codeServiceFields(service);
        Vector parents = this.getDevice().getAllChildrenWithTagCode(83);
        if (parents.size() == 0) {
            String name = this.getMainClassName();
            this.codeDeviceServiceKeyField(service, "Status", String.valueOf(name) + "/Status", 2, new StringBuffer(1024), false, false);
            this.codeDeviceServiceKeyField(service, "Configuration", String.valueOf(name) + "/Configuration", 2, new StringBuffer(1024), false, false);
            this.codeDeviceServiceKeyField(service, "Capabilities", String.valueOf(name) + "/Capabilities", 2, new StringBuffer(1024), false, false);
        }
    }

    protected String getBASuperClass() {
        switch (this.bundleType) {
            case 2: {
                return DeviceKitGenerationConstants.CLASS_PROFILE_MANAGED_BA;
            }
            case 3: {
                return DeviceKitGenerationConstants.CLASS_PROFILE_MANAGED_FACTORY_BA;
            }
        }
        return DeviceKitGenerationConstants.CLASS_PROFILE_BUNDLE_ACTIVATOR;
    }

    protected String getConstructorContents() {
        Vector parents = this.getDevice().getAllChildrenWithTagCode(83);
        if (parents.size() == 0) {
            String serviceName = this.getServiceClass();
            StringBuffer buffer = new StringBuffer(32);
            buffer.append("super(");
            buffer.append(serviceName);
            buffer.append(".Capabilities, ");
            buffer.append(serviceName);
            buffer.append(".Status, ");
            buffer.append(serviceName);
            buffer.append(".Configuration);\n");
            buffer.append("setKey(getDefaultKey());\n");
            if (!this.isLazyDevice || this.hasPids) {
                buffer.append("initialize();\n");
            }
            return buffer.toString();
        }
        return super.getConstructorContents();
    }

    public String getServiceClassParent() {
        return DeviceKitGenerationConstants.CLASS_PROFILE_SERVICE;
    }

    protected String[] getServiceInterfaces() {
        Vector<String> result = new Vector<String>();
        result.addElement(this.getServiceClassParent());
        this.fServiceModel.addImport(this.getServiceClassParent());
        Vector exportedService = this.getDevice().getAllChildrenWithTagCode(30);
        int i = 0;
        while (i < exportedService.size()) {
            if (((TagElement)exportedService.elementAt(i)).getTextData() != null) {
                result.addElement(((TagElement)exportedService.elementAt(i)).getTextData());
            }
            ++i;
        }
        Vector parents = this.getDevice().getAllChildrenWithTagCode(83);
        int i2 = 0;
        while (i2 < parents.size()) {
            TagElement parent = (TagElement)parents.elementAt(i2);
            Vector profileRefs = parent.getAllChildrenWithTagCode(86);
            int j = 0;
            while (j < profileRefs.size()) {
                TagElement profileRef = (TagElement)profileRefs.elementAt(j);
                if (profileRef.getIdRaw() != null) {
                    String serviceName = profileRef.getServiceNameFull();
                    this.fServiceModel.addImport(serviceName);
                    result.addElement(DeviceKitUtilities.stripPackage(serviceName));
                }
                ++j;
            }
            ++i2;
        }
        String[] serviceInterfaces = new String[result.size()];
        int i3 = 0;
        while (i3 < result.size()) {
            serviceInterfaces[i3] = (String)result.elementAt(i3);
            ++i3;
        }
        return serviceInterfaces;
    }

    public AdapterElement getTargetAdapter() {
        return this.targetAdapter;
    }

    protected void initialize() {
        Vector services = this.getRootElement().getAllChildrenWithTagCode(74);
        ProfileElement profile = (ProfileElement)services.elementAt(0);
        this.setDevice(profile);
        Vector devices = profile.getAllChildrenWithTagCode(8);
        if (devices.size() > 0) {
            MainTagElement device = (MainTagElement)devices.elementAt(0);
            this.setTargetDevice(device);
        }
        this.setMainTagElement(profile);
        String className = DeviceKitUtilities.getClassNameFromTagElement(profile);
        this.setMainClassName(className);
        Vector adapters = this.getMainElement().getAllChildrenWithTagCode(72);
        if (adapters.size() > 0) {
            AdapterElement adapaterService = (AdapterElement)adapters.elementAt(0);
            this.setTargetAdapter(adapaterService);
        }
        this.setPackageBase(profile.getPackageBase());
        this.setMainPackage(DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase()));
        if (profile.getAttribute("lazy") == null || "false".equals(profile.getAttribute("lazy"))) {
            this.setLazy(false);
        } else {
            this.setLazy(true);
        }
        if (profile.hasChildWithTagCode(45)) {
            this.setInitializeMeasurements(true);
        } else {
            this.setInitializeMeasurements(false);
        }
        String initWithMethod = profile.getAttribute("createmethod");
        if (initWithMethod != null && initWithMethod.trim().toLowerCase().equals("true")) {
            this.setInitializeWithMethod(true);
        } else {
            this.setInitializeWithMethod(false);
        }
        this.setupExportedPackages();
        this.initializeGet();
    }

    public void setTargetAdapter(AdapterElement targetAdapater) {
        this.targetAdapter = targetAdapater;
    }
}

