/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkTestCaseGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.TransportElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.util.DeviceKitEclipseUtilities;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class DkTransportTestCaseGenerator
extends DkTestCaseGenerator {
    private String transportClassName;

    public DkTransportTestCaseGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    public DkTransportTestCaseGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Hashtable methodProperties) {
        super(model, generatedInfo, methodProperties);
    }

    private void codeCreateTransport(IType test) {
        String comment = this.getCreateTransportComment();
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        this.getMainModel().addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        this.getMainModel().addImport(this.getTransportFqn());
        String bundleId = DeviceKitEclipseUtilities.extractPackage(this.getTransportFqn());
        this.addAdditionalBundles(bundleId);
        String contents = this.getCreateTransportContents();
        this.codeMethod(test, "createTransport", comment, returnType, 1L, contents);
    }

    protected void codeMethods(IType test) {
        super.codeMethods(test);
        this.codeCreateTransport(test);
    }

    protected IType createTestType() throws Exception {
        IType test = super.createTestType();
        Vector devs = this.getTestElement().getAllChildrenWithTagCode(9);
        TransportElement transportElement = (TransportElement)devs.elementAt(0);
        String deviceClassName = DeviceKitUtilities.getClassNameFromTagElement(transportElement);
        this.setTransportClassName(deviceClassName);
        this.getMainModel().addImport(this.getTransportFqn());
        this.getMainModel().addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_TEST_CASE);
        this.addAdditionalBundles(this.getTransportPackage());
        return test;
    }

    protected String getBASuperClass() {
        return DeviceKitGenerationConstants.CLASS_TRANSPORT_TEST_CASE_BUNDLE_ACTIVATOR;
    }

    private String getCreateTransportComment() {
        StringBuffer buffer = new StringBuffer(128);
        String transportService = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        buffer.append("Create transport and return the ");
        buffer.append(transportService);
        buffer.append(".\n");
        buffer.append("@return\tResults of the create transport (<code>");
        buffer.append(transportService);
        buffer.append("</code>) value.\n");
        return buffer.toString();
    }

    private String getCreateTransportContents() {
        StringBuffer buffer = new StringBuffer(64);
        String transportClassName = this.getTransportClassName();
        buffer.append("return new ");
        buffer.append(transportClassName);
        buffer.append("();\n");
        return buffer.toString();
    }

    protected Vector getManifestImportPackages() {
        Vector<String> v = new Vector<String>();
        v.add(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE));
        v.add(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_TEST_CASE));
        v.add(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_TEST_CASE_BUNDLE_ACTIVATOR));
        v.add(this.getTransportPackage());
        v.add(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_JUNIT_TESTRUNNER));
        v.add(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_OSGI_BUNDLE_ACTIVATOR));
        return v;
    }

    protected String getSuperClass() {
        return DeviceKitGenerationConstants.CLASS_TRANSPORT_TEST_CASE;
    }

    protected String getTargetType() {
        return "transport";
    }

    protected String getTransportClassName() {
        return this.transportClassName;
    }

    protected String getTransportFqn() {
        return String.valueOf(this.getTransportPackage()) + '.' + this.getTransportClassName();
    }

    protected String getTransportPackage() {
        return DeviceKitUtilities.getPackageFromClassName(this.getTransportClassName(), this.getPackageBase());
    }

    protected void setTransportClassName(String transportClassName) {
        this.transportClassName = transportClassName;
    }
}

