/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.model.AbstractDkGenerator;
import org.eclipse.soda.devicekit.generator.model.PropertiesModel;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class EscPropertiesModel
extends PropertiesModel {
    public static final String PROPERTY_INTRO_LICENSE = "#Licensed Materials - Property of IBM";
    public static final String PROPERTY_INTRO_COPYRIGHT = "#(C) Copyright IBM Corp. " + Calendar.getInstance().get(1) + " All Rights Reserved";
    public static final String PROPERTY_INTRO_BLANK = "#";
    public static final String PROPERTY_INTRO_START_GEN = "#Start Generated Properties";
    public static final String PROPERTY_INTRO_END_GEN = "#End Generated Properties.  Everything below this line will be saved.";
    private static EscPropertiesModel model;
    private AbstractDkGenerator generator;
    private List properties;

    private EscPropertiesModel() {
        this(null);
    }

    public EscPropertiesModel(AbstractDkGenerator generator) {
        this.generator = generator;
        this.properties = new ArrayList();
    }

    public static EscPropertiesModel getModel(AbstractDkGenerator generator) {
        if (model == null) {
            model = new EscPropertiesModel(generator);
        }
        return model;
    }

    public static EscPropertiesModel getModel() {
        return model;
    }

    public static EscPropertiesModel resetModel(AbstractDkGenerator generator) {
        model = new EscPropertiesModel(generator);
        return model;
    }

    public static EscPropertiesModel resetModel() {
        model = model != null ? new EscPropertiesModel(EscPropertiesModel.model.generator) : new EscPropertiesModel(null);
        return model;
    }

    public void addProperty(String key, String value) {
        List props = this.getListProperties();
        if (!this.contains(key)) {
            KeyValuePair pair = new KeyValuePair(key, value);
            props.add(pair);
        }
    }

    public void addProperty(String key, boolean value) {
        this.addProperty(key, new Boolean(value).toString());
    }

    public boolean contains(String key) {
        List props = this.getListProperties();
        int i = 0;
        while (i < props.size()) {
            KeyValuePair pair = (KeyValuePair)props.get(i);
            if (pair.getKey() != null && pair.getKey().equals(key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getFileContents(InputStream stream, boolean comment, boolean preserveOldValues) {
        String contents = this.getNewContents(comment);
        if (preserveOldValues && stream != null) {
            String oldContents = this.getOldContents(stream);
            StringBuffer result = new StringBuffer(contents.length() + oldContents.length());
            result.append(contents);
            result.append(oldContents);
            contents = result.toString();
        }
        return contents;
    }

    public List getListProperties() {
        return this.properties;
    }

    private String getNewContents(boolean comment) {
        List properties = this.getListProperties();
        StringBuffer buffer = new StringBuffer(properties.size() * 128);
        buffer.append(GeneratorTemplates.getCopyrightPropertyString(this.getTemplateVariables()));
        buffer.append(PROPERTY_INTRO_START_GEN);
        buffer.append("\r\n");
        int i = 0;
        while (i < properties.size()) {
            KeyValuePair pair = (KeyValuePair)properties.get(i);
            String key = pair.getKey();
            String value = pair.getValue();
            if (comment) {
                buffer.append(PROPERTY_INTRO_BLANK);
            }
            buffer.append(key);
            buffer.append("=");
            buffer.append(value);
            buffer.append("\r\n");
            ++i;
        }
        buffer.append(PROPERTY_INTRO_END_GEN);
        buffer.append("\r\n");
        return buffer.toString();
    }

    private String getOldContents(InputStream stream) {
        try {
            String contents = DkUtilities.getStringFromStream(stream);
            return this.removeGeneratedProperties(contents);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String();
        }
    }

    public Map getTemplateVariables() {
        return this.generator.getTemplateVariables();
    }

    private String removeGeneratedProperties(String contents) {
        String endLine = "#End Generated Properties.  Everything below this line will be saved.\r\n";
        int index = contents.indexOf(endLine);
        if (index == -1) {
            endLine = "#End Generated Properties.  Everything below this line will be saved.\r\n";
            index = contents.indexOf(endLine);
        }
        int lineLength = endLine.length();
        if (index != -1 && (index += lineLength) < contents.length()) {
            return contents.substring(index, contents.length());
        }
        return new String();
    }

    public String toString() {
        if (this.getProperties() != null) {
            return this.getProperties().toString();
        }
        return super.toString();
    }
}

