/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.model.AbstractDkGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.CustomParameter;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.java.CodeUtilities;
import org.eclipse.soda.devicekit.generator.print.XmlPrinter;
import org.eclipse.soda.devicekit.generator.template.TemplateInputStream;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;

public class FactoryMetaDataBuilder {
    private AbstractDkGenerator generator;
    private int pidType;
    private Hashtable variables;
    private Vector customParameters;
    private Vector profiles;
    static /* synthetic */ Class class$0;

    public FactoryMetaDataBuilder(AbstractDkGenerator generator, int pidType) {
        this.generator = generator;
        this.pidType = pidType;
        this.variables = new Hashtable();
    }

    protected void addCommonVariables() {
        this.variables.put("provider", this.generator.getProvider());
        this.variables.put("vendor", this.generator.getVendor());
        this.variables.put("vendors", this.generator.getVendors());
        this.variables.put("year", Integer.toString(Calendar.getInstance().get(1)));
        this.variables.put("years", Integer.toString(Calendar.getInstance().get(1)));
        this.variables.put("pidType", this.getPidType());
        this.variables.put("bundleActivator", this.generator.getBundleActivatorFqn());
        this.variables.put("settings", this.generator.getManifestDescription());
        this.variables.put("copyright_properties", GeneratorTemplates.getCopyrightPropertyString(this.variables));
        this.variables.put("copyright_xml", GeneratorTemplates.getCopyrightXmlString(this.variables));
        String[] warningStrings = GeneratorTemplates.getStrings(GeneratorTemplates.getWarning(this.variables));
        XmlPrinter printer = new XmlPrinter();
        printer.printComments(warningStrings);
        this.variables.put("warning_xml", printer.getContents());
    }

    protected boolean doIncludeCustomParameter(String type) {
        if (type == null) {
            return false;
        }
        return type.equals("String") || type.equals("java.lang.String") || type.equals("int") || type.equals("long") || type.equals("boolean") || type.equals("double");
    }

    protected String getCustomParameterProperty(CustomParameter parameter) {
        String name = parameter.getAttribute("name");
        String description = parameter.getDescription();
        StringBuffer buffer = new StringBuffer(32);
        String capName = DkUtilities.makeFirstCharUpper(name);
        buffer.append(name);
        buffer.append("=");
        buffer.append(capName);
        buffer.append('\n');
        if (description == null) {
            description = capName;
        }
        buffer.append(name);
        buffer.append("_description=");
        buffer.append(description);
        buffer.append('\n');
        return buffer.toString();
    }

    protected Vector getCustomParameters() {
        if (this.customParameters == null) {
            this.customParameters = new Vector();
        }
        return this.customParameters;
    }

    protected AbstractDkGenerator getGenerator() {
        return this.generator;
    }

    public String getMetaDataPropertiesContents() {
        this.init();
        try {
            String result = this.getPropertiesContents();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getMetaDataXmlContents() {
        this.init();
        try {
            String result = this.getXmlContents();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getPidType() {
        switch (this.pidType) {
            case 2: {
                return "PID";
            }
            case 3: {
                return "FACTORYPID";
            }
        }
        return "";
    }

    protected String getProfileProperty(MainTagElement element) {
        String description = element.getDescription();
        String id = DeviceKitUtilities.stripPackage(element.getClassNameFull());
        StringBuffer buffer = new StringBuffer(128);
        if (id != null) {
            String newName = String.valueOf(id) + "Prefix";
            String name = CodeUtilities.methodName(newName);
            buffer.append(name);
            buffer.append('=');
            String betterName = CodeUtilities.betterName(newName, true).replace('/', ' ');
            buffer.append(betterName);
            buffer.append('\n');
            buffer.append(name);
            buffer.append("_description=");
            if (description != null) {
                buffer.append(description);
            } else {
                buffer.append(betterName);
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public Vector getProfiles() {
        return this.profiles;
    }

    protected String getPropertiesContents() throws Exception {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(this.getPropertyCopyright());
        buffer.append(this.getPropertyBundle());
        switch (this.pidType) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                buffer.append(this.getPropertyCommonHeader());
                buffer.append(this.getPropertyCustom());
                buffer.append(this.getPropertyProfiles());
            }
        }
        TemplateInputStream tis = new TemplateInputStream(new ByteArrayInputStream(buffer.toString().getBytes()));
        tis.setEntities(this.getVariables());
        return DeviceKitUtilities.getStringFromStream(tis);
    }

    public String getPropertyBundle() {
        StringBuffer buffer = new StringBuffer(1024);
        String copyright = this.generator.getManifestCopyright();
        buffer.append("bundle.copyright=");
        buffer.append(copyright);
        buffer.append("\r\n");
        String description = this.generator.getManifestDescription();
        buffer.append("bundle.description=");
        buffer.append(description);
        buffer.append("\r\n");
        String name = this.generator.getManifestBundleName();
        buffer.append("bundle.name=");
        buffer.append(name);
        buffer.append("\r\n");
        String vendor = this.generator.getProvider();
        buffer.append("bundle.vendor=");
        buffer.append(vendor);
        buffer.append("\r\n");
        return buffer.toString();
    }

    protected String getPropertyCommonHeader() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.model.TransportFactoryMetaDataBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream stream = clazz.getResourceAsStream("common.header.metadata.properties");
        return DeviceKitUtilities.getStringFromStream(stream);
    }

    protected String getPropertyCopyright() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.model.TransportFactoryMetaDataBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream stream = clazz.getResourceAsStream("common.header.metadata.properties.copyright");
        return DeviceKitUtilities.getStringFromStream(stream);
    }

    protected String getPropertyCustom() throws Exception {
        return "";
    }

    protected String getPropertyProfiles() throws Exception {
        if (this.profiles != null) {
            StringBuffer buffer = new StringBuffer(32 * this.profiles.size());
            int i = 0;
            while (i < this.profiles.size()) {
                buffer.append(this.getProfileProperty((MainTagElement)this.profiles.get(i)));
                ++i;
            }
            return buffer.toString();
        }
        return "";
    }

    public String getValidMetaType(String type) {
        String ttype = type.toLowerCase();
        if (type.endsWith("[]")) {
            ttype = ttype.substring(0, ttype.length() - 2);
        }
        if ("string".equals(ttype)) {
            return "String";
        }
        if ("int".equals(ttype) || "integer".equals(ttype)) {
            return "Integer";
        }
        if ("boolean".equals(ttype) || "bool".equals(ttype)) {
            return "Boolean";
        }
        if ("char".equals(ttype) || "character".equals(ttype)) {
            return "Char";
        }
        if ("long".equals(ttype)) {
            return "Long";
        }
        if ("float".equals(ttype)) {
            return "Float";
        }
        if ("double".equals(ttype)) {
            return "Double";
        }
        if ("short".equals(ttype)) {
            return "Short";
        }
        if ("byte".equals(ttype)) {
            return "Byte";
        }
        if ("biginteger".equals(ttype)) {
            return "BigInteger";
        }
        if ("bigdecimal".equals(ttype)) {
            return "BigDecimal";
        }
        return type;
    }

    protected Hashtable getVariables() {
        return this.variables;
    }

    protected String getXmlCommonAttributeDefs() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.model.TransportFactoryMetaDataBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream stream = clazz.getResourceAsStream("common.metadata.attributedefs");
        return DeviceKitUtilities.getStringFromStream(stream);
    }

    private String getXmlCommonFooter() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.model.TransportFactoryMetaDataBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream stream = clazz.getResourceAsStream("common.footer.metadata");
        return DeviceKitUtilities.getStringFromStream(stream);
    }

    protected String getXmlCommonHeader() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.model.TransportFactoryMetaDataBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream stream = clazz.getResourceAsStream("common.header.metadata");
        return DeviceKitUtilities.getStringFromStream(stream);
    }

    protected String getXmlContents() throws Exception {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(this.getXmlCommonHeader());
        buffer.append(this.getXmlObjectClassHeader());
        buffer.append(this.getXmlCommonAttributeDefs());
        buffer.append(this.getXmlCustomAttributeDefs());
        buffer.append(this.getXmlProfileAttributeDefs());
        buffer.append(this.getXmlObjectClassFooter());
        buffer.append(this.getXmlDesignate());
        buffer.append(this.getXmlCommonFooter());
        TemplateInputStream tis = new TemplateInputStream(new ByteArrayInputStream(buffer.toString().getBytes()));
        tis.setEntities(this.getVariables());
        return DeviceKitUtilities.getStringFromStream(tis);
    }

    protected String getXmlCustomAttributeDefs() throws Exception {
        return "";
    }

    protected String getXmlCustomAttributeIds() throws Exception {
        return "";
    }

    protected String getXmlCustomParameterAttributeDefs() throws Exception {
        Vector cps = this.getCustomParameters();
        StringBuffer buffer = new StringBuffer(cps.size() * 64);
        int i = 0;
        while (i < cps.size()) {
            CustomParameter parameter = (CustomParameter)cps.get(i);
            String type = parameter.getAttribute("type");
            if (this.doIncludeCustomParameter(type)) {
                String name = parameter.getAttribute("name");
                String defaultValue = parameter.getAttribute("defaultvalue");
                buffer.append(this.getXmlCustomParameterAttributeDefs(type, name, defaultValue));
            }
            ++i;
        }
        return buffer.toString();
    }

    protected String getXmlCustomParameterAttributeDefs(String type, String name, String defaultValue) {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("\r\n\t\t<AD id=\"");
        buffer.append(name);
        buffer.append("\"\r\n\t\t\ttype=\"");
        buffer.append(this.getValidMetaType(type));
        buffer.append("\"\r\n");
        if (defaultValue != null) {
            buffer.append("\t\t\tdefault=\"");
            buffer.append(defaultValue);
            buffer.append("\"\r\n");
        }
        buffer.append("\t\t\tname=\"%");
        buffer.append(name);
        buffer.append("\"\r\n");
        buffer.append("\t\t\tdescription=\"%");
        buffer.append(name);
        buffer.append("_description\"\r\n");
        buffer.append("\t\t\tcardinality=\"0\"\r\n");
        buffer.append("\t\t\trequired=\"false\"");
        buffer.append("/>\r\n");
        return buffer.toString();
    }

    protected String getXmlCustomParameterAttributeId(String type) {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("\t\t<ATTRIBUTE ID=\"");
        buffer.append(this.getValidMetaType(type));
        buffer.append("\" REQUIRED=\"no\"/>\n");
        return buffer.toString();
    }

    protected String getXmlCustomParameterAttributeIds() {
        Vector cps = this.getCustomParameters();
        StringBuffer buffer = new StringBuffer(cps.size() * 64);
        int i = 0;
        while (i < cps.size()) {
            CustomParameter parameter = (CustomParameter)cps.get(i);
            String type = parameter.getAttribute("type");
            if (this.doIncludeCustomParameter(type)) {
                String name = parameter.getAttribute("name");
                buffer.append(this.getXmlCustomParameterAttributeId(name));
            }
            ++i;
        }
        return buffer.toString();
    }

    private String getXmlDesignate() throws Exception {
        if (this.pidType == 2) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.model.TransportFactoryMetaDataBuilder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            InputStream stream = clazz.getResourceAsStream("designate.managed");
            return DeviceKitUtilities.getStringFromStream(stream);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.model.TransportFactoryMetaDataBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream stream = clazz.getResourceAsStream("designate.factory");
        return DeviceKitUtilities.getStringFromStream(stream);
    }

    private String getXmlObjectClassFooter() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.model.TransportFactoryMetaDataBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream stream = clazz.getResourceAsStream("common.objectclass.footer.metadata");
        return DeviceKitUtilities.getStringFromStream(stream);
    }

    private String getXmlObjectClassHeader() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.model.TransportFactoryMetaDataBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream stream = clazz.getResourceAsStream("common.objectclass.header.metadata");
        return DeviceKitUtilities.getStringFromStream(stream);
    }

    protected String getXmlProfileAttributeDefs() throws Exception {
        Vector cps = this.getProfiles();
        if (cps != null) {
            StringBuffer buffer = new StringBuffer(cps.size() * 64);
            int i = 0;
            while (i < cps.size()) {
                MainTagElement parameter = (MainTagElement)cps.get(i);
                String name = DeviceKitUtilities.stripPackage(parameter.getClassNameFull());
                if (name != null) {
                    buffer.append(this.getXmlCustomParameterAttributeDefs("String", CodeUtilities.methodName(String.valueOf(name) + "Prefix"), ""));
                }
                ++i;
            }
            return buffer.toString();
        }
        return "";
    }

    protected String getXmlProfilesAttributeIds() {
        Vector cps = this.getCustomParameters();
        StringBuffer buffer = new StringBuffer(cps.size() * 64);
        if (cps != null) {
            int i = 0;
            while (i < cps.size()) {
                CustomParameter parameter = (CustomParameter)cps.get(i);
                String type = parameter.getAttribute("type");
                if (this.doIncludeCustomParameter(type)) {
                    String name = parameter.getAttribute("name");
                    buffer.append(this.getXmlCustomParameterAttributeId(name));
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    protected void init() {
        this.addCommonVariables();
    }

    protected void setCustomParameters(Vector customParameters) {
        this.customParameters = customParameters;
    }

    public void setProfiles(Vector profiles) {
        this.profiles = profiles;
    }
}

