/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.model.AbstractDkGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTransportGenerator;
import org.eclipse.soda.devicekit.generator.model.FactoryMetaDataBuilder;
import org.eclipse.soda.devicekit.generator.model.elements.CustomParameter;
import org.eclipse.soda.devicekit.generator.model.elements.FileElement;
import org.eclipse.soda.devicekit.generator.model.elements.RandomAccessFileElement;
import org.eclipse.soda.devicekit.generator.model.elements.SerialElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TcpipElement;
import org.eclipse.soda.devicekit.generator.model.elements.TcpipServerElement;
import org.eclipse.soda.devicekit.generator.model.elements.TransportElement;
import org.eclipse.soda.devicekit.generator.model.elements.UrlConnectionElement;
import org.eclipse.soda.devicekit.generator.model.elements.UsbElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class TransportFactoryMetaDataBuilder
extends FactoryMetaDataBuilder {
    private Vector connections;
    private String[] templateBases;
    static /* synthetic */ Class class$0;

    public TransportFactoryMetaDataBuilder(AbstractDkGenerator generator, int pidType) {
        super(generator, pidType);
    }

    private void addFileMetaDataVariables(FileElement element) {
        this.getVariables().put("inputNameValue", element.getInputName());
        this.getVariables().put("inputPathValue", element.getInputPath());
        this.getVariables().put("outputNameValue", element.getOutputName());
        this.getVariables().put("outputPathValue", element.getOutputPath());
    }

    private void addRandomAccessFileMetaDataVariables(RandomAccessFileElement element) {
        this.getVariables().put("mode", element.getMode());
        this.getVariables().put("name", element.getRandomAccessFileName());
        this.getVariables().put("path", element.getRandomAccessFilePath());
    }

    private void addSerialMetaDataVariables(SerialElement element) {
        this.getVariables().put("comportValue", element.getComport());
        this.getVariables().put("baudRateValue", element.getBaudRate());
        this.getVariables().put("dataBitsValue", element.getDataBits());
        this.getVariables().put("parityValue", element.getParityAsInt());
        this.getVariables().put("stopBitsValue", element.getStopBits());
        this.getVariables().put("hwFlowControlValue", element.getHwFlowControl());
        this.getVariables().put("swFlowControlValue", element.getSwFlowControl());
        this.getVariables().put("readTotalTimeoutValue", element.getReadTotalTimeout());
        this.getVariables().put("writeTotalTimeoutValue", element.getWriteTotalTimeout());
        this.getVariables().put("readIntervalTimeoutValue", element.getReadIntervalTimeout());
    }

    private void addTcpipMetaDataVariables(TcpipElement element) {
        this.getVariables().put("hostValue", element.getHost());
        this.getVariables().put("remotePortValue", element.getRemotePort());
        this.getVariables().put("localPortValue", element.getLocalPort());
        this.getVariables().put("linger", element.getLinger());
    }

    private void addTcpipServerMetaDataVariables(TcpipServerElement element) {
        this.getVariables().put("portValue", element.getPort());
    }

    private void addUrlMetaDataVariables(UrlConnectionElement element) {
        this.getVariables().put("urlValue", element.getUrl());
    }

    private void addUsbMetaDataVariables(UsbElement element) {
        this.getVariables().put("vendorIdValue", element.getVendorId());
        this.getVariables().put("productIdValue", element.getProductId());
        this.getVariables().put("usageValue", element.getUsage());
        this.getVariables().put("usagePageValue", element.getUsagePage());
    }

    protected String getConnectionProperty() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("connection=Connection\n");
        buffer.append("connection_description=The connection type.\n");
        return buffer.toString();
    }

    private String getConnectionTemplateName(TagElement element) {
        switch (element.getTagCode()) {
            case 32: {
                return "serial";
            }
            case 37: {
                return "tcpip";
            }
            case 33: {
                return "file";
            }
            case 34: {
                return "url";
            }
            case 51: {
                return "usb";
            }
            case 56: {
                return "tcpipserver";
            }
            case 61: {
                return "randomaccessfile";
            }
        }
        return null;
    }

    protected String getPropertyCustom() throws Exception {
        StringBuffer buffer = new StringBuffer(256 * this.templateBases.length);
        if (this.templateBases.length > 0) {
            buffer.append(this.getConnectionProperty());
        }
        int i = 0;
        while (i < this.templateBases.length) {
            buffer.append(this.getXmlTemplateProperty(this.templateBases[i]));
            ++i;
        }
        Vector cps = this.getCustomParameters();
        int i2 = 0;
        while (i2 < cps.size()) {
            CustomParameter cp = (CustomParameter)cps.get(i2);
            buffer.append(this.getCustomParameterProperty(cp));
            ++i2;
        }
        return buffer.toString();
    }

    private String getXmlConnectionAttributeDef(Vector connections) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("\n\t\t<AD id=\"connection\"\r\n\t\t\ttype=\"String\"\r\n\t\t\tdefault=\"factory\"\r\n\t\t\t");
        buffer.append("name=\"%connection\"\r\n\t\t\t");
        buffer.append("decription=\"%connection_description\"\r\n\t\t\trequired=\"false\">\r\n\t\t\t");
        buffer.append("<Option value=\"factory\" label=\"%factory\"/>\n");
        int i = 0;
        while (i < connections.size()) {
            String connection = this.getConnectionTemplateName((TagElement)connections.get(i));
            if (connection != null) {
                buffer.append("\t\t\t<Option value=\"");
                buffer.append(connection);
                buffer.append("\" label=\"%");
                buffer.append(connection);
                buffer.append("\"/>\n");
            }
            ++i;
        }
        buffer.append("\t\t</AD>\n");
        return buffer.toString();
    }

    private String getXmlConnectionAttributeId() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("\t\t<ATTRIBUTE ID=\"connection\" REQUIRED=\"no\"/>\n");
        return buffer.toString();
    }

    protected String getXmlCustomAttributeDefs() throws Exception {
        Vector cps;
        StringBuffer buffer = new StringBuffer(64 * this.templateBases.length);
        int i = 0;
        while (i < this.templateBases.length) {
            buffer.append(this.getXmlTemplateAttributeDef(this.templateBases[i]));
            ++i;
        }
        if (this.connections != null && this.connections.size() > 0) {
            buffer.append(this.getXmlConnectionAttributeDef(this.connections));
        }
        if ((cps = this.getCustomParameters()) != null && cps.size() > 0) {
            buffer.append(this.getXmlCustomParameterAttributeDefs());
        }
        return buffer.toString();
    }

    protected String getXmlCustomAttributeIds() throws Exception {
        Vector cps;
        StringBuffer buffer = new StringBuffer(32 * this.templateBases.length);
        int i = 0;
        while (i < this.templateBases.length) {
            buffer.append(this.getXmlTemplateAttributeId(this.templateBases[i]));
            ++i;
        }
        if (this.templateBases.length > 0) {
            buffer.append(this.getXmlConnectionAttributeId());
        }
        if ((cps = this.getCustomParameters()) != null && cps.size() > 0) {
            buffer.append(this.getXmlCustomParameterAttributeIds());
        }
        return buffer.toString();
    }

    private String getXmlTemplateAttributeDef(String templateBase) throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.model.TransportFactoryMetaDataBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream stream = clazz.getResourceAsStream(String.valueOf(templateBase) + ".metadata.attributedefs");
        return DeviceKitUtilities.getStringFromStream(stream);
    }

    private String getXmlTemplateAttributeId(String templateBase) throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.model.TransportFactoryMetaDataBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream stream = clazz.getResourceAsStream(String.valueOf(templateBase) + ".metadata.attributeids");
        return DeviceKitUtilities.getStringFromStream(stream);
    }

    private String getXmlTemplateProperty(String templateBase) throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.model.TransportFactoryMetaDataBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream stream = clazz.getResourceAsStream(String.valueOf(templateBase) + ".metadata_en.properties");
        return DeviceKitUtilities.getStringFromStream(stream);
    }

    protected void init() {
        super.init();
        DkTransportGenerator generator = (DkTransportGenerator)this.getGenerator();
        TransportElement element = generator.getTransportElement();
        this.setCustomParameters(element.getAllChildrenWithTagCode(46));
        this.connections = element.getConnectionChildren();
        this.loadTransportData(element);
    }

    private void loadTransportData(TransportElement element) {
        String noActivityTimeout;
        ArrayList<String> localTemplates = new ArrayList<String>();
        if (this.connections != null) {
            int i = 0;
            while (i < this.connections.size()) {
                TagElement connection = (TagElement)this.connections.get(i);
                switch (connection.getTagCode()) {
                    case 32: {
                        this.addSerialMetaDataVariables((SerialElement)connection);
                        localTemplates.add(this.getConnectionTemplateName(connection));
                        break;
                    }
                    case 37: {
                        this.addTcpipMetaDataVariables((TcpipElement)connection);
                        localTemplates.add(this.getConnectionTemplateName(connection));
                        break;
                    }
                    case 33: {
                        this.addFileMetaDataVariables((FileElement)connection);
                        localTemplates.add(this.getConnectionTemplateName(connection));
                        break;
                    }
                    case 34: {
                        this.addUrlMetaDataVariables((UrlConnectionElement)connection);
                        localTemplates.add(this.getConnectionTemplateName(connection));
                        break;
                    }
                    case 51: {
                        this.addUsbMetaDataVariables((UsbElement)connection);
                        localTemplates.add(this.getConnectionTemplateName(connection));
                        break;
                    }
                    case 56: {
                        this.addTcpipServerMetaDataVariables((TcpipServerElement)connection);
                        localTemplates.add(this.getConnectionTemplateName(connection));
                        break;
                    }
                    case 61: {
                        this.addRandomAccessFileMetaDataVariables((RandomAccessFileElement)connection);
                        localTemplates.add(this.getConnectionTemplateName(connection));
                    }
                }
                ++i;
            }
        }
        if (element.getResponseTimeout() != null) {
            this.getVariables().put("responsetimeout", element.getResponseTimeout());
            localTemplates.add("responsetimeout");
        }
        if ((noActivityTimeout = element.getNoActivityTimeout()) == null) {
            noActivityTimeout = "10000";
        }
        this.getVariables().put("noactivitytimeout", noActivityTimeout);
        localTemplates.add("noactivitytimeout");
        String retryTime = element.getRetryTime();
        if (element.getRetryTime() == null) {
            retryTime = "1000";
        }
        this.getVariables().put("retrytime", retryTime);
        localTemplates.add("retrytime");
        this.templateBases = new String[localTemplates.size()];
        localTemplates.toArray(this.templateBases);
    }
}

