/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.soda.devicekit.generator.model.elements.BytesItem;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.w3c.dom.Node;

public class AsciiElement
extends BytesItem {
    public AsciiElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public byte[] bytesCdata(String cdata) {
        int length = this.getBitLengthValue(0);
        int requestedLength = (length + 7) / 8;
        ByteArrayOutputStream byteArrayOutputStream = length == 0 ? new ByteArrayOutputStream() : new ByteArrayOutputStream(requestedLength);
        try {
            byte[] bytes = cdata.getBytes("US-ASCII");
            byteArrayOutputStream.write(bytes, 0, bytes.length);
            return byteArrayOutputStream.toByteArray();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byte[] bytes = cdata.getBytes();
            byteArrayOutputStream.write(bytes, 0, bytes.length);
            return byteArrayOutputStream.toByteArray();
        }
    }

    public int getTagCode() {
        return 63;
    }
}

