/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import org.eclipse.soda.devicekit.generator.model.elements.DkgElementsMessages;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.util.BinaryOuputStream;
import org.eclipse.soda.devicekit.util.Nls;
import org.w3c.dom.Node;

public abstract class BytesItem
extends TagElement {
    public BytesItem(Node node, TagElement parent) {
        super(node, parent);
    }

    public void append(BinaryOuputStream stream) throws IOException {
        stream.write(this.bytes());
    }

    public byte byteCdata(String cdata) {
        int base = this.getBase();
        try {
            short value;
            if (base == 0 || base == 10) {
                value = Byte.decode(cdata).shortValue();
            } else {
                value = Short.parseShort(cdata, base);
                if ((value & 0xFF00) != 0) {
                    throw this.error(String.valueOf(Nls.format(DkgElementsMessages.getString("BytesItem.error.invalid.byte"), cdata)) + this.toString());
                }
            }
            return (byte)value;
        }
        catch (NumberFormatException numberFormatException) {
            throw this.error(String.valueOf(Nls.format(DkgElementsMessages.getString("BytesItem.error.invalid.byte"), cdata)) + this.toString());
        }
    }

    public byte[] bytes() {
        String string = this.getTextDataFix();
        if (string == null) {
            string = new String();
        }
        return this.bytesCdata(string);
    }

    public byte[] bytesCdata(String cdataInput) {
        String cdata = cdataInput.replace('\n', ' ');
        cdata = cdata.replace('\r', ' ');
        int length = this.getBitLengthValue(0);
        int requestedLength = (length + 7) / 8;
        ByteArrayOutputStream byteArrayOutputStream = length == 0 ? new ByteArrayOutputStream() : new ByteArrayOutputStream(requestedLength);
        String format = this.getFormat();
        if ("ascii".equals(format)) {
            byte[] bytes = cdata.getBytes();
            byteArrayOutputStream.write(bytes, 0, bytes.length);
        } else {
            StringTokenizer tokenizer = new StringTokenizer(cdata, " ,\t\n\r\f");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                byteArrayOutputStream.write(this.byteCdata(token));
            }
        }
        if (length > 0) {
            int size;
            int i = size = byteArrayOutputStream.size();
            while (i < requestedLength) {
                byteArrayOutputStream.write(0);
                ++i;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        return "byte []";
    }

    public boolean isMessageClassElement() {
        return this.isChildOfCode(7);
    }
}

