/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.ControlItem;
import org.eclipse.soda.devicekit.generator.model.elements.DeviceElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.MeasurementElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.w3c.dom.Node;

public class CommandElement
extends ControlItem {
    public CommandElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        String implementation = this.getAttribute("implementation");
        boolean isCommandReceived = this.isCommandReceviced(this);
        if (implementation != null) {
            return implementation;
        }
        if (this.hasChildWithTagCode(2)) {
            if (isCommandReceived) {
                return DeviceKitGenerationConstants.CLASS_COMMAND_MEASUREMENT;
            }
            return DeviceKitGenerationConstants.CLASS_COMMAND_SIMPLE_MEASUREMENT;
        }
        if (this.hasChildWithTagCode(5) || this.hasChildWithTagCode(23)) {
            if (isCommandReceived) {
                return DeviceKitGenerationConstants.CLASS_COMMAND_PARAMETER;
            }
            return DeviceKitGenerationConstants.CLASS_COMMAND_SIMPLE_PARAMETER;
        }
        if (this.hasTransformChild()) {
            if (isCommandReceived) {
                return DeviceKitGenerationConstants.CLASS_COMMAND_TRANSFORM;
            }
            return DeviceKitGenerationConstants.CLASS_COMMAND_SIMPLE_TRANSFORM;
        }
        if (this.hasChildWithTagCode(7)) {
            Vector messages = this.getAllChildrenWithTagCode(7);
            TagElement me = (TagElement)messages.elementAt(0);
            if (me.hasChildWithTagCode(5) || me.hasChildWithTagCode(23)) {
                if (isCommandReceived) {
                    return DeviceKitGenerationConstants.CLASS_COMMAND_DATA;
                }
                return DeviceKitGenerationConstants.CLASS_COMMAND_SIMPLE_DATA;
            }
            if (isCommandReceived) {
                return DeviceKitGenerationConstants.CLASS_COMMAND_MESSAGE;
            }
            return DeviceKitGenerationConstants.CLASS_COMMAND_SIMPLE_MESSAGE;
        }
        if (this.hasMethodChild()) {
            return DeviceKitGenerationConstants.CLASS_METHOD_COMMAND;
        }
        return DeviceKitGenerationConstants.CLASS_COMMAND;
    }

    public String getServiceType() {
        return DeviceKitGenerationConstants.CLASS_COMMAND_SERVICE;
    }

    public int getTagCode() {
        return 1;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("measurement".equals(childNodeName)) {
            this.handleMeasurement(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    private void handleMeasurement(Node node) {
        this.addChild(new MeasurementElement(node, this));
    }

    private boolean isCommandReceviced(TagElement element) {
        if (element == null) {
            return true;
        }
        TagElement parent = element.getParent();
        if (parent instanceof DeviceElement) {
            MainTagElement de = (MainTagElement)parent;
            return de.includeCommandRecevied();
        }
        return this.isCommandReceviced(parent);
    }
}

