/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.CommandElement;
import org.eclipse.soda.devicekit.generator.model.elements.ControlItem;
import org.eclipse.soda.devicekit.generator.model.elements.SleepElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class CommandsElement
extends ControlItem {
    public CommandsElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        return DeviceKitGenerationConstants.CLASS_COMMANDS;
    }

    public String getServiceType() {
        return DeviceKitGenerationConstants.CLASS_COMMAND_SERVICE;
    }

    public int getTagCode() {
        return 19;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("command".equals(childNodeName)) {
            this.handleCommand(childNode);
        } else if ("key".equals(childNodeName)) {
            this.setKey(ParserUtilities.extractData(childNode));
        } else if ("sleep".equals(childNodeName)) {
            this.handleSleep(childNode);
        }
        super.handleChild(childNode);
    }

    private void handleCommand(Node node) {
        CommandElement ce = new CommandElement(node, this);
        this.addChild(ce);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addCommand(ce.getId(), ce);
            }
            catch (Exception e) {
                this.error(e.getMessage());
            }
        }
    }

    private void handleSleep(Node node) {
        SleepElement element = new SleepElement(node, this);
        this.addChild(element);
    }
}

