/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.w3c.dom.Node;

public class ConfigurationElement
extends TagElement {
    public ConfigurationElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public String getCardinality() {
        String cardinality = this.getAttribute("cardinality");
        if (cardinality != null) {
            cardinality = cardinality.toUpperCase();
            this.validateCardinality(cardinality);
        }
        return cardinality;
    }

    public String getDefaultValue() {
        String defaultValue = this.getAttribute("defaultvalue");
        return defaultValue;
    }

    public String getDescription() {
        return this.getParent().getDescription();
    }

    public String getExternalId() {
        TagElement parent = this.getParent();
        if (parent != null) {
            return parent.getExternalId();
        }
        return super.getExternalId();
    }

    public String getId() {
        return this.getParent().getId();
    }

    public String getSize() {
        String size = this.getAttribute("size");
        return size;
    }

    public int getTagCode() {
        return 70;
    }

    public String getType() {
        String type = this.getAttribute("type");
        if (type == null) {
            return "String";
        }
        return type;
    }

    public boolean isOn() {
        String textData = this.getTextData();
        if (textData == null) {
            return false;
        }
        return textData.equals("1") || textData.toLowerCase().equals("true");
    }

    private void validateCardinality(String cardinality) {
        if (!("SCALAR".equals(cardinality) || "ARRAY".equals(cardinality) || "VECTOR".equals(cardinality))) {
            throw this.error("Invalid cardinality type - Cardinality must be set to SCALAR, ARRAY, or VECTOR.");
        }
    }
}

