/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.AsciiElement;
import org.eclipse.soda.devicekit.generator.model.elements.BytesElement;
import org.eclipse.soda.devicekit.generator.model.elements.DkgElementsMessages;
import org.eclipse.soda.devicekit.generator.model.elements.MessageClassItem;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.w3c.dom.Node;

public class FilterElement
extends MessageClassItem {
    public FilterElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        if (this.isSimple()) {
            return DeviceKitGenerationConstants.CLASS_FILTER_SIMPLE;
        }
        return DeviceKitGenerationConstants.CLASS_FILTER;
    }

    public int getBitLengthValue(int defaultValue) {
        if (this.getByteChildren().size() > 0) {
            byte[] bytes = this.getBytes();
            int index = 0;
            index = bytes.length - 1;
            while (index >= 0) {
                if (bytes[index] != 0) {
                    if (bytes[index] == -1) break;
                    int i = 7;
                    while (i >= 0) {
                        if ((bytes[index] & 1) != 0) {
                            return 8 * index + i;
                        }
                        --i;
                    }
                    break;
                }
                --index;
            }
            return (index + 1) * 8;
        }
        return super.getBitLengthValue(defaultValue);
    }

    public int getBitOffsetValue(int defaultValue) {
        if (this.getByteChildren().size() > 0) {
            byte[] bytes = this.getBytes();
            int offset = 0;
            int i = 0;
            while (i < bytes.length) {
                if (bytes[i] != 0) {
                    int mask = 128;
                    int j = 0;
                    while (j < 8) {
                        if ((bytes[i] & masks[j]) != 0) {
                            return offset + j;
                        }
                        mask >>= 1;
                        ++j;
                    }
                    break;
                }
                offset = (i + 1) * 8;
                ++i;
            }
            return offset;
        }
        return super.getBitOffsetValue(defaultValue);
    }

    public String getServiceType() {
        return DeviceKitGenerationConstants.CLASS_FILTER_SERVICE;
    }

    public int getTagCode() {
        return 6;
    }

    private void handleAscii(Node node) {
        AsciiElement element = new AsciiElement(node, this);
        this.addChild(element);
    }

    private void handleBytes(Node node) {
        BytesElement element = new BytesElement(node, this);
        this.addChild(element);
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("bytes".equals(childNodeName)) {
            this.handleBytes(childNode);
        } else if ("ascii".equals(childNodeName)) {
            this.handleAscii(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    protected void validate() {
        Vector bytes;
        if (this.getAttribute("idref") == null && (bytes = this.getAllChildrenWithTagCodes(new int[]{12, 1012})).size() == 0) {
            throw this.error(DkgElementsMessages.getString("FilterElement.error.child1"));
        }
    }
}

