/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.Vector;
import org.eclipse.soda.devicekit.generator.model.elements.CommandElement;
import org.eclipse.soda.devicekit.generator.model.elements.CommandRefElement;
import org.eclipse.soda.devicekit.generator.model.elements.CommandsElement;
import org.eclipse.soda.devicekit.generator.model.elements.MeasurementElement;
import org.eclipse.soda.devicekit.generator.model.elements.MeasurementRefElement;
import org.eclipse.soda.devicekit.generator.model.elements.SignalElement;
import org.eclipse.soda.devicekit.generator.model.elements.SignalLinkElement;
import org.eclipse.soda.devicekit.generator.model.elements.SignalRefElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class GroupElement
extends TagElement {
    public GroupElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public GroupElement(Node node, TagElement parent, Vector references) {
        super(node, parent, references);
    }

    public String getGroupId() {
        return this.getId();
    }

    public int getTagCode() {
        return 82;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("command".equals(childNodeName)) {
            this.handleCommand(childNode);
        } else if ("commandref".equals(childNodeName)) {
            this.handleCommandRef(childNode);
        } else if ("signal".equals(childNodeName)) {
            this.handleSignal(childNode);
        } else if ("signalref".equals(childNodeName)) {
            this.handleSignalRef(childNode);
        } else if ("measurement".equals(childNodeName)) {
            this.handleMeasurement(childNode);
        } else if ("measurementref".equals(childNodeName)) {
            this.handleMeasurementRef(childNode);
        } else if ("commands".equals(childNodeName)) {
            this.handleCommands(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    private void handleCommand(Node node) {
        CommandElement ce = new CommandElement(node, this);
        this.addChild(ce);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addCommand(ce.getId(), ce);
            }
            catch (Exception e) {
                this.error(e.getMessage());
            }
        }
    }

    private void handleCommandRef(Node node) {
        CommandRefElement ce = new CommandRefElement(node, this);
        this.addChild(ce);
        String idref = ParserUtilities.getAttribute("idref", node);
        if (idref != null) {
            try {
                TagElement.collection.addControlRef(idref, ce);
            }
            catch (Exception e) {
                this.error(e.getMessage());
            }
        }
    }

    private void handleCommands(Node node) {
        CommandsElement ce = new CommandsElement(node, this);
        this.addChild(ce);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addCommand(ce.getId(), ce);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleMeasurement(Node node) {
        MeasurementElement me = new MeasurementElement(node, this);
        this.addChild(me);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addMeasurement(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleMeasurementRef(Node node) {
        MeasurementRefElement ce = new MeasurementRefElement(node, this);
        this.addChild(ce);
        String idref = ParserUtilities.getAttribute("idref", node);
        if (idref != null) {
            try {
                TagElement.collection.addControlRef(idref, ce);
            }
            catch (Exception e) {
                this.error(e.getMessage());
            }
        }
    }

    private void handleSignal(Node node) {
        if (ParserUtilities.containsAttribute("idref", node)) {
            this.addChild(new SignalLinkElement(node, this));
        } else {
            SignalElement se = new SignalElement(node, this);
            this.addChild(se);
            if (ParserUtilities.containsAttribute("id", node)) {
                try {
                    TagElement.collection.addSignal(se.getId(), se);
                }
                catch (Exception e) {
                    throw this.error(e.getMessage());
                }
            }
        }
    }

    private void handleSignalRef(Node node) {
        SignalRefElement ce = new SignalRefElement(node, this);
        this.addChild(ce);
        String idref = ParserUtilities.getAttribute("idref", node);
        if (idref != null) {
            try {
                TagElement.collection.addControlRef(idref, ce);
            }
            catch (Exception e) {
                this.error(e.getMessage());
            }
        }
    }
}

