/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.ControlItem;
import org.eclipse.soda.devicekit.generator.model.elements.DataElement;
import org.eclipse.soda.devicekit.generator.model.elements.DecrementCommandElement;
import org.eclipse.soda.devicekit.generator.model.elements.IncrementCommandElement;
import org.eclipse.soda.devicekit.generator.model.elements.MaximumElement;
import org.eclipse.soda.devicekit.generator.model.elements.MinimumElement;
import org.eclipse.soda.devicekit.generator.model.elements.NegativeElement;
import org.eclipse.soda.devicekit.generator.model.elements.NotElement;
import org.eclipse.soda.devicekit.generator.model.elements.ParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.ReadCommandElement;
import org.eclipse.soda.devicekit.generator.model.elements.ScaleElement;
import org.eclipse.soda.devicekit.generator.model.elements.ShiftElement;
import org.eclipse.soda.devicekit.generator.model.elements.SignalElement;
import org.eclipse.soda.devicekit.generator.model.elements.SignalLinkElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TranslateElement;
import org.eclipse.soda.devicekit.generator.model.elements.UnitsElement;
import org.eclipse.soda.devicekit.generator.model.elements.UnitsLinkElement;
import org.eclipse.soda.devicekit.generator.model.elements.ValueElement;
import org.eclipse.soda.devicekit.generator.model.elements.WriteCommandElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class MeasurementElement
extends ControlItem {
    private Hashtable tags = MeasurementElement.createTags();
    private Hashtable values = MeasurementElement.createValues();

    public MeasurementElement(Node node, TagElement parent) {
        super(node, parent);
        this.tags = MeasurementElement.createTags();
        this.values = MeasurementElement.createValues();
    }

    private static Hashtable createTags() {
        Hashtable<String, String> tagTypes = new Hashtable<String, String>();
        tagTypes.put("boolean", "Boolean");
        tagTypes.put("byte", "Number");
        tagTypes.put("short", "Number");
        tagTypes.put("int", "Number");
        tagTypes.put("long", "Number");
        tagTypes.put("ascii", "String");
        tagTypes.put("string", "String");
        return tagTypes;
    }

    private static Hashtable createValues() {
        Hashtable<String, String> values = new Hashtable<String, String>();
        values.put("Boolean", "Boolean.FALSE");
        values.put("Number", "new Integer(0)");
        values.put("String", "\"\"");
        return values;
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        if (this.getParent().getTagCode() == 18) {
            return DeviceKitGenerationConstants.CLASS_MEASUREMENT_CONCRETE;
        }
        if (this.hasChildWithTagCode(2)) {
            return DeviceKitGenerationConstants.CLASS_MEASUREMENT_CHILD;
        }
        if (this.hasChildWithTagCode(20) || this.hasChildWithTagCode(45)) {
            return DeviceKitGenerationConstants.CLASS_MEASUREMENT_COMMAND;
        }
        if (this.hasChildWithTagCode(3)) {
            return DeviceKitGenerationConstants.CLASS_MEASUREMENT_SIGNAL;
        }
        if (this.hasMethodChild()) {
            return DeviceKitGenerationConstants.CLASS_METHOD_MEASUREMENT;
        }
        if (!this.isExecuteWrite() && !this.isSetValue()) {
            return DeviceKitGenerationConstants.CLASS_READ_ONLY_MEASUREMENT;
        }
        return DeviceKitGenerationConstants.CLASS_MEASUREMENT;
    }

    public String[] getContents() {
        return null;
    }

    public String getDefaultMeasurementValue() {
        String type = this.getMeasurementType();
        Vector minimum = this.getAllChildrenWithTagCode(27);
        if (minimum.size() > 0) {
            String min = ((TagElement)minimum.elementAt(0)).getTextData();
            if (min != null && type.equals("Number")) {
                return "new Integer(" + min + ")";
            }
            Object value = this.values.get(type);
            if (value != null) {
                return value.toString();
            }
        }
        return "null";
    }

    public String getMeasurementType() {
        String name = this.getAttribute("type");
        if (name == null || name.length() == 0) {
            name = "Object";
            Vector signals = this.getAllChildrenWithTagCode(3);
            if (signals.size() > 0) {
                Vector list = ((TagElement)signals.elementAt(0)).getParameterChildren();
                if (list.size() > 1) {
                    name = "Object[]";
                } else if (list.size() == 1) {
                    ParameterElement parm = (ParameterElement)list.elementAt(0);
                    String typename = parm.getAttribute("type");
                    if (typename.startsWith("u")) {
                        name = "Number";
                    } else {
                        Object type = this.tags.get(typename);
                        if (type != null) {
                            name = type.toString();
                        }
                    }
                }
            }
        }
        return name;
    }

    public String getServiceType() {
        return DeviceKitGenerationConstants.CLASS_MEASUREMENT_SERVICE;
    }

    public int getTagCode() {
        return 2;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("readcommand".equals(childNodeName)) {
            this.handleReadCommand(childNode);
        } else if ("writecommand".equals(childNodeName)) {
            this.handleWriteCommand(childNode);
        } else if ("signal".equals(childNodeName)) {
            this.handleSignal(childNode);
        } else if ("data".equals(childNodeName)) {
            this.handleData(childNode);
        } else if ("units".equals(childNodeName)) {
            this.handleUnits(childNode);
        } else if ("value".equals(childNodeName)) {
            this.handleValue(childNode);
        } else if ("maximum".equals(childNodeName)) {
            this.handleMaximum(childNode);
        } else if ("minimum".equals(childNodeName)) {
            this.handleMinimum(childNode);
        } else if ("negative".equals(childNodeName)) {
            this.handleNegative(childNode);
        } else if ("not".equals(childNodeName)) {
            this.handleNot(childNode);
        } else if ("scale".equals(childNodeName)) {
            this.handleScale(childNode);
        } else if ("shift".equals(childNodeName)) {
            this.handleShift(childNode);
        } else if ("translate".equals(childNodeName)) {
            this.handleTranslate(childNode);
        } else if ("decrementcommand".equals(childNodeName)) {
            this.handleDecrementCommand(childNode);
        } else if ("incrementcommand".equals(childNodeName)) {
            this.handleIncrementCommand(childNode);
        } else if ("measurement".equals(childNodeName)) {
            this.handleMeasurement(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    private void handleData(Node node) {
        DataElement pe = new DataElement(node, this);
        this.addChild(pe);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addData(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleDecrementCommand(Node node) {
        this.addChild(new DecrementCommandElement(node, this));
    }

    private void handleIncrementCommand(Node node) {
        this.addChild(new IncrementCommandElement(node, this));
    }

    private void handleMaximum(Node node) {
        MaximumElement element = new MaximumElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleMeasurement(Node node) {
        this.addChild(new MeasurementElement(node, this));
    }

    private void handleMinimum(Node node) {
        MinimumElement element = new MinimumElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleNegative(Node node) {
        NegativeElement element = new NegativeElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleNot(Node node) {
        NotElement element = new NotElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleReadCommand(Node node) {
        ReadCommandElement element = new ReadCommandElement(node, this);
        this.addChild(element);
    }

    private void handleScale(Node node) {
        ScaleElement element = new ScaleElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleShift(Node node) {
        ShiftElement element = new ShiftElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleSignal(Node node) {
        if (ParserUtilities.containsAttribute("idref", node)) {
            this.addChild(new SignalLinkElement(node, this));
        } else {
            SignalElement se = new SignalElement(node, this);
            this.addChild(se);
            if (ParserUtilities.containsAttribute("id", node)) {
                try {
                    TagElement.collection.addSignal(se.getId(), se);
                }
                catch (Exception e) {
                    throw this.error(e.getMessage());
                }
            }
        }
    }

    private void handleTranslate(Node node) {
        TranslateElement element = new TranslateElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleUnits(Node node) {
        if (ParserUtilities.containsAttribute("idref", node)) {
            this.addChild(new UnitsLinkElement(node, this));
        } else {
            UnitsElement element = new UnitsElement(node, this);
            this.addChild(element);
            if (ParserUtilities.containsAttribute("id", node)) {
                try {
                    TagElement.collection.addUnits(element.getId(), element);
                }
                catch (Exception e) {
                    throw this.error(e.getMessage());
                }
            }
        }
    }

    private void handleValue(Node node) {
        ValueElement element = new ValueElement(node, this);
        this.addChild(element);
    }

    private void handleWriteCommand(Node node) {
        WriteCommandElement element = new WriteCommandElement(node, this);
        this.addChild(element);
    }

    public boolean isExecuteRead() {
        String value = this.getAttribute("executeread");
        if (value == null) {
            return true;
        }
        return value.equals("1") || value.toLowerCase().equals("true");
    }

    public boolean isExecuteWrite() {
        String value = this.getAttribute("executewrite");
        if (value == null) {
            return true;
        }
        return value.equals("1") || value.toLowerCase().equals("true");
    }

    public boolean isSetValue() {
        String value = this.getAttribute("setvalue");
        if (value == null) {
            return true;
        }
        return value.equals("1") || value.toLowerCase().equals("true");
    }
}

