/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.io.IOException;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.model.elements.BytesItem;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.util.BinaryOuputStream;
import org.w3c.dom.Node;

public abstract class MessageClassItem
extends TagElement {
    protected static final byte[] masks = new byte[]{-1, 127, 63, 31, 15, 7, 3, 1};
    protected static final byte[] lenmasks = new byte[]{-1, -128, -64, -32, -16, -8, -4, -2};

    public MessageClassItem(Node node, TagElement parent) {
        super(node, parent);
    }

    public byte[] getBytes() {
        Vector list = this.getByteChildren();
        switch (list.size()) {
            case 0: {
                int length = this.getBitLengthValue(0);
                int offset = this.getBitOffsetValue(0);
                int total = (offset + length + 7) / 8;
                if (total > 0) {
                    byte[] bytes = new byte[total];
                    int i = 0;
                    while (i < total) {
                        bytes[i] = i * 8 >= offset && i < total ? -1 : 0;
                        ++i;
                    }
                    bytes[offset / 8] = masks[offset % 8];
                    bytes[total - 1] = total - 1 == offset / 8 ? (byte)(bytes[total - 1] & lenmasks[(offset + length) % 8]) : lenmasks[(offset + length) % 8];
                    return bytes;
                }
                return null;
            }
        }
        BinaryOuputStream byteArrayOutputStream = new BinaryOuputStream(100);
        int i = 0;
        while (i < list.size()) {
            BytesItem bytesItem = (BytesItem)list.elementAt(i);
            try {
                bytesItem.append(byteArrayOutputStream);
            }
            catch (IOException exception) {
                throw this.error(exception.getMessage());
            }
            ++i;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public boolean isMessageClassElement() {
        return true;
    }

    protected boolean isSimple() {
        byte[] bytes = this.getBytes();
        if (bytes != null) {
            int start = 0;
            start = 0;
            while (start < bytes.length) {
                if (bytes[start] != 0) break;
                ++start;
            }
            int end = 0;
            end = bytes.length - 1;
            while (end >= 0) {
                if (bytes[end] != 0) break;
                --end;
            }
            int i = start;
            while (i <= end) {
                if (bytes[i] != -1) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

