/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.AsciiElement;
import org.eclipse.soda.devicekit.generator.model.elements.BytesElement;
import org.eclipse.soda.devicekit.generator.model.elements.FilterElement;
import org.eclipse.soda.devicekit.generator.model.elements.MessageClassItem;
import org.eclipse.soda.devicekit.generator.model.elements.NibblesElement;
import org.eclipse.soda.devicekit.generator.model.elements.ParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.ParametersElement;
import org.eclipse.soda.devicekit.generator.model.elements.SentMessageElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class MessageElement
extends MessageClassItem {
    private String fTokens;

    public MessageElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        if (this.fTokens != null) {
            return DeviceKitGenerationConstants.CLASS_MESSAGE_TOKENS;
        }
        if (this.hasChildWithTagCode(62)) {
            return DeviceKitGenerationConstants.CLASS_MESSAGE_RESPONSE;
        }
        if (this.hasChildWithTagCode(5) || this.hasChildWithTagCode(23)) {
            return DeviceKitGenerationConstants.CLASS_MESSAGE_PARAMETER;
        }
        if (this.hasChildWithTagCode(6)) {
            return DeviceKitGenerationConstants.CLASS_MESSAGE_FILTER;
        }
        if (this.hasChildWithTagCode(63) || !this.hasChildWithTagCode(12) && !this.hasChildWithTagCode(25)) {
            return DeviceKitGenerationConstants.CLASS_MESSAGE_ASCII;
        }
        return DeviceKitGenerationConstants.CLASS_MESSAGE;
    }

    public String getServiceType() {
        return DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE;
    }

    public int getTagCode() {
        return 7;
    }

    public String getTokens() {
        return this.fTokens;
    }

    private void handleAscii(Node node) {
        AsciiElement element = new AsciiElement(node, this);
        this.addChild(element);
    }

    private void handleBytes(Node node) {
        BytesElement element = new BytesElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addElement(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("parameter".equals(childNodeName)) {
            this.handleParameter(childNode);
        } else if ("parameters".equals(childNodeName)) {
            this.handleParameters(childNode);
        } else if ("bytes".equals(childNodeName)) {
            this.handleBytes(childNode);
        } else if ("nibbles".equals(childNodeName)) {
            this.handleNibbles(childNode);
        } else if ("tokens".equals(childNodeName)) {
            this.setTokens(ParserUtilities.extractData(childNode));
        } else if ("filter".equals(childNodeName)) {
            this.handleFilter(childNode);
        } else if ("sentmessage".equals(childNodeName)) {
            this.handleSentMessage(childNode);
        } else if ("ascii".equals(childNodeName)) {
            this.handleAscii(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    private void handleFilter(Node node) {
        FilterElement fe = new FilterElement(node, this);
        this.addChild(fe);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addFilter(fe.getId(), fe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleNibbles(Node node) {
        NibblesElement element = new NibblesElement(node, this);
        this.addChild(element);
    }

    private void handleParameter(Node node) {
        ParameterElement pe = new ParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleParameters(Node node) {
        ParametersElement element = new ParametersElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addParameter(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleSentMessage(Node node) {
        SentMessageElement element = new SentMessageElement(node, this);
        this.addChild(element);
    }

    protected void setTokens(String tokens) {
        this.fTokens = tokens;
    }
}

