/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.EnumElement;
import org.eclipse.soda.devicekit.generator.model.elements.LittleEndianElement;
import org.eclipse.soda.devicekit.generator.model.elements.MaximumElement;
import org.eclipse.soda.devicekit.generator.model.elements.MinimumElement;
import org.eclipse.soda.devicekit.generator.model.elements.NegativeElement;
import org.eclipse.soda.devicekit.generator.model.elements.NotElement;
import org.eclipse.soda.devicekit.generator.model.elements.ScaleElement;
import org.eclipse.soda.devicekit.generator.model.elements.ShiftElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TranslateElement;
import org.eclipse.soda.devicekit.generator.model.elements.UnitsElement;
import org.eclipse.soda.devicekit.generator.model.elements.UnitsLinkElement;
import org.eclipse.soda.devicekit.generator.model.elements.UnsignedElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class ParameterElement
extends TagElement {
    private String fField;
    private String fIndex;
    private boolean fInsert;
    private String fLength;
    private String fOffset;
    private String fSize;

    public ParameterElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        if (this.fField != null) {
            return DeviceKitGenerationConstants.CLASS_PARAMETER_FIELD;
        }
        int length = this.getBitLengthValue(0);
        int offset = this.getBitOffsetValue(0);
        if (offset % 8 == 0 && length % 8 == 0) {
            return DeviceKitGenerationConstants.CLASS_PARAMETER_SIMPLE;
        }
        return DeviceKitGenerationConstants.CLASS_PARAMETER_OFFSET;
    }

    public int getBitLengthValue(int defaultValue) {
        String length = this.getLength();
        String size = this.getSize();
        if (length != null) {
            int len = Integer.parseInt(length);
            return super.getBitLengthValue(len);
        }
        if (size != null) {
            int s = Integer.parseInt(size);
            return super.getBitLengthValue(s * 8);
        }
        return super.getBitLengthValue(defaultValue);
    }

    public String getField() {
        return this.fField;
    }

    public String getIndex() {
        return this.fIndex;
    }

    public boolean getInsert() {
        return this.fInsert;
    }

    public String getLength() {
        return this.fLength;
    }

    public String getOffset() {
        return this.fOffset;
    }

    public String getServiceType() {
        return DeviceKitGenerationConstants.CLASS_PARAMETER_SERVICE;
    }

    public String getSize() {
        return this.fSize;
    }

    public int getTagCode() {
        return 5;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("field".equals(childNodeName)) {
            this.setField(ParserUtilities.extractData(childNode));
        } else if ("index".equals(childNodeName)) {
            this.setIndex(ParserUtilities.extractData(childNode));
        } else if ("insert".equals(childNodeName)) {
            this.setInsert(true);
        } else if ("key".equals(childNodeName)) {
            this.setKey(ParserUtilities.extractData(childNode));
        } else if ("length".equals(childNodeName)) {
            this.setLength(ParserUtilities.extractData(childNode));
        } else if ("maximum".equals(childNodeName)) {
            this.handleMaximum(childNode);
        } else if ("minimum".equals(childNodeName)) {
            this.handleMinimum(childNode);
        } else if ("negative".equals(childNodeName)) {
            this.handleNegative(childNode);
        } else if ("not".equals(childNodeName)) {
            this.handleNot(childNode);
        } else if ("offset".equals(childNodeName)) {
            this.setOffset(ParserUtilities.extractData(childNode));
        } else if ("scale".equals(childNodeName)) {
            this.handleScale(childNode);
        } else if ("enum".equals(childNodeName)) {
            this.handleEnum(childNode);
        } else if ("shift".equals(childNodeName)) {
            this.handleShift(childNode);
        } else if ("size".equals(childNodeName)) {
            this.setSize(ParserUtilities.extractData(childNode));
        } else if ("translate".equals(childNodeName)) {
            this.handleTranslate(childNode);
        } else if ("units".equals(childNodeName)) {
            this.handleUnits(childNode);
        } else if ("littleendian".equals(childNodeName)) {
            this.handleLittleEndian(childNode);
        } else if ("le".equals(childNodeName)) {
            this.handleLittleEndian(childNode);
        } else if ("unsigned".equals(childNodeName)) {
            this.handleUnsigned(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    private void handleEnum(Node node) {
        EnumElement element = new EnumElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addEnum(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleLittleEndian(Node node) {
        this.addChild(new LittleEndianElement(node, this));
    }

    private void handleMaximum(Node node) {
        MaximumElement element = new MaximumElement(node, this);
        this.addChild(element);
    }

    private void handleMinimum(Node node) {
        MinimumElement element = new MinimumElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleNegative(Node node) {
        NegativeElement element = new NegativeElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleNot(Node node) {
        NotElement element = new NotElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleScale(Node node) {
        ScaleElement element = new ScaleElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleShift(Node node) {
        ShiftElement element = new ShiftElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleTranslate(Node node) {
        TranslateElement element = new TranslateElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleUnits(Node node) {
        if (ParserUtilities.containsAttribute("idref", node)) {
            this.addChild(new UnitsLinkElement(node, this));
        } else {
            UnitsElement element = new UnitsElement(node, this);
            this.addChild(element);
            if (ParserUtilities.containsAttribute("id", node)) {
                try {
                    TagElement.collection.addUnits(element.getId(), element);
                }
                catch (Exception e) {
                    throw this.error(e.getMessage());
                }
            }
        }
    }

    private void handleUnsigned(Node node) {
        this.addChild(new UnsignedElement(node, this));
    }

    public boolean isMessageClassElement() {
        return true;
    }

    protected void setField(String field) {
        this.fField = field;
    }

    protected void setIndex(String index) {
        this.fIndex = index;
    }

    protected void setInsert(boolean insert) {
        this.fInsert = insert;
    }

    protected void setLength(String length) {
        if (DeviceKitUtilities.isInteger(length)) {
            int val = Integer.parseInt(length);
            if (val < 0) {
                throw this.error("Parameter length value: " + length + " must be positive");
            }
        } else {
            throw this.error("Parameter length value: " + length + " must be a number");
        }
        this.fLength = length;
    }

    protected void setOffset(String offset) {
        this.fOffset = offset;
    }

    protected void setSize(String size) {
        if (DeviceKitUtilities.isInteger(size)) {
            int val = Integer.parseInt(size);
            if (val < 0) {
                throw this.error("Parameter size value: " + size + " must be positive");
            }
        } else {
            throw this.error("Parameter size value: " + size + " must be a number");
        }
        this.fSize = size;
    }
}

