/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.ParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.w3c.dom.Node;

public class ParametersElement
extends ParameterElement {
    public ParametersElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        return DeviceKitGenerationConstants.CLASS_PARAMETER_SERVICE;
    }

    public int getTagCode() {
        return 23;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("parameter".equals(childNodeName)) {
            this.handleParameter(childNode);
        } else if ("key".equals(childNodeName)) {
            this.setKey(childNode.getNodeValue());
        } else {
            super.handleChild(childNode);
        }
    }

    private void handleParameter(Node node) {
        ParameterElement pe = new ParameterElement(node, this);
        this.addChild(pe);
        if (pe.getId() != null) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    public boolean isMessageClassElement() {
        return true;
    }
}

