/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import org.eclipse.soda.devicekit.generator.model.elements.MessageElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class ReadCommandElement
extends TagElement {
    private String fRate;

    public ReadCommandElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public String getRate() {
        return this.fRate;
    }

    public int getTagCode() {
        return 20;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("key".equals(childNodeName)) {
            this.setKey(ParserUtilities.extractData(childNode));
        } else if ("rate".equals(childNodeName)) {
            this.setRate(ParserUtilities.extractData(childNode));
        } else if ("message".equals(childNodeName)) {
            this.handleMessage(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    protected void handleMessage(Node node) {
        String messageId;
        MessageElement me = new MessageElement(node, this);
        this.addChild(me);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addMessage(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
        if (this.getId() != null && (messageId = this.getIdForMessage(this.getId(), me)) != null) {
            me.setAttribute("id", messageId);
            try {
                TagElement.collection.addMessage(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    public void setRate(String rate) {
        this.fRate = rate;
    }
}

