/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.IConnectionItem;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class SerialElement
extends TagElement
implements IConnectionItem {
    private String fBaudRate;
    private String fComport;
    private String fDataBits;
    private String fHwFlowControl;
    private String fParity;
    private String fReadIntervalTimeout;
    private String fReadTotalTimeout;
    private String fSwFlowControl;
    private String fStopBits;
    private String fWriteTotalTimeout;

    public SerialElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        return DeviceKitGenerationConstants.CLASS_CONNECTION_SERIAL;
    }

    public String getBaudRate() {
        if (this.fBaudRate == null) {
            this.fBaudRate = "1200";
        }
        return this.fBaudRate;
    }

    public String getComport() {
        if (this.fComport == null) {
            this.fComport = "1";
        }
        return this.fComport;
    }

    public ConfigurationField[] getConfigurationOptions() {
        ArrayList<ConfigurationField> list = new ArrayList<ConfigurationField>();
        String constants = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_SERIAL_SERVICE);
        list.add(new ConfigurationField("int", "DEFAULT_BAUDRATE", this.getBaudRate()));
        list.add(new ConfigurationField("int", "DEFAULT_COMPORT", this.getComport()));
        list.add(new ConfigurationField("int", "DEFAULT_DATABITS", String.valueOf(constants) + ".DATABITS_" + this.getDataBits()));
        list.add(new ConfigurationField("int", "DEFAULT_HWFLOW", this.getHwFlowControl()));
        list.add(new ConfigurationField("int", "DEFAULT_PARITY", String.valueOf(constants) + ".PARITY_" + this.getParity().toUpperCase()));
        list.add(new ConfigurationField("int", "DEFAULT_READINTERVALTIMEOUT", this.getReadIntervalTimeout()));
        list.add(new ConfigurationField("int", "DEFAULT_READTOTALTIMEOUT", this.getReadTotalTimeout()));
        list.add(new ConfigurationField("int", "DEFAULT_STOPBITS", String.valueOf(constants) + ".STOPBITS_" + this.getStopBits().replace('.', '_')));
        list.add(new ConfigurationField("int", "DEFAULT_SWFLOW", this.getSwFlowControl()));
        list.add(new ConfigurationField("int", "DEFAULT_WRITETOTALTIMEOUT", this.getWriteTotalTimeout()));
        ConfigurationField[] pairs = new ConfigurationField[list.size()];
        list.toArray(pairs);
        return pairs;
    }

    public String getConnectionConstant() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_SERIAL_SERVICE));
        buffer.append('.');
        buffer.append("CONNECTION_TYPE");
        return buffer.toString();
    }

    public String getConnectionTag() {
        return "serial";
    }

    public String getDataBits() {
        if (this.fDataBits == null) {
            this.fDataBits = "8";
        }
        return this.fDataBits;
    }

    public String[] getExtraImports() {
        return new String[]{DeviceKitGenerationConstants.CLASS_CONNECTION_SERIAL_SERVICE};
    }

    public String getHwFlowControl() {
        if (this.fHwFlowControl == null) {
            this.fHwFlowControl = "0";
        } else if (this.fHwFlowControl.equalsIgnoreCase("true")) {
            this.fHwFlowControl = "1";
        } else if (this.fHwFlowControl.equalsIgnoreCase("false")) {
            this.fHwFlowControl = "0";
        }
        return this.fHwFlowControl;
    }

    public String getParity() {
        if (this.fParity == null) {
            this.fParity = "none";
        }
        return this.fParity;
    }

    public String getParityAsInt() {
        String par = this.getParity();
        if ("even".equals(par)) {
            return "1";
        }
        if ("odd".equals(par)) {
            return "2";
        }
        if ("mark".equals(par)) {
            return "3";
        }
        if ("space".equals(par)) {
            return "4";
        }
        return "0";
    }

    public Hashtable getProperties() {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("comport", this.getComport());
        table.put("baudrate", this.getBaudRate());
        table.put("databits", this.getDataBits());
        table.put("hardwareflowcontrol", this.getHwFlowControl());
        table.put("parity", this.getParity());
        table.put("readintervaltimeout", this.getReadIntervalTimeout());
        table.put("readtotaltimeout", this.getReadTotalTimeout());
        table.put("stopbits", this.getStopBits());
        table.put("softwareflowcontrol", this.getSwFlowControl());
        table.put("writetotaltimeout", this.getWriteTotalTimeout());
        return table;
    }

    public String getReadIntervalTimeout() {
        if (this.fReadIntervalTimeout == null) {
            this.fReadIntervalTimeout = "50";
        }
        return this.fReadIntervalTimeout;
    }

    public String getReadTotalTimeout() {
        if (this.fReadTotalTimeout == null) {
            this.fReadTotalTimeout = "100";
        }
        return this.fReadTotalTimeout;
    }

    public String getStopBits() {
        if (this.fStopBits == null) {
            this.fStopBits = "1";
        }
        return this.fStopBits;
    }

    public String getSwFlowControl() {
        if (this.fSwFlowControl == null) {
            this.fSwFlowControl = "0";
        } else if (this.fSwFlowControl.equalsIgnoreCase("true")) {
            this.fHwFlowControl = "1";
        } else if (this.fSwFlowControl.equalsIgnoreCase("false")) {
            this.fHwFlowControl = "0";
        }
        return this.fSwFlowControl;
    }

    public int getTagCode() {
        return 32;
    }

    public String getWriteTotalTimeout() {
        if (this.fWriteTotalTimeout == null) {
            this.fWriteTotalTimeout = "1000";
        }
        return this.fWriteTotalTimeout;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("baudrate".equals(childNodeName)) {
            this.setBaudRate(ParserUtilities.extractData(childNode));
        } else if ("comport".equals(childNodeName)) {
            this.setComport(ParserUtilities.extractData(childNode));
        } else if ("databits".equals(childNodeName)) {
            this.setDataBits(ParserUtilities.extractData(childNode));
        } else if ("hardwareflowcontrol".equals(childNodeName)) {
            this.setHwFlowControl(ParserUtilities.extractData(childNode));
        } else if ("parity".equals(childNodeName)) {
            this.setParity(ParserUtilities.extractData(childNode));
        } else if ("readintervaltimeout".equals(childNodeName)) {
            this.setReadIntervalTimeout(ParserUtilities.extractData(childNode));
        } else if ("readtotaltimeout".equals(childNodeName)) {
            this.setReadTotalTimeout(ParserUtilities.extractData(childNode));
        } else if ("softwareflowcontrol".equals(childNodeName)) {
            this.setSwFlowControl(ParserUtilities.extractData(childNode));
        } else if ("stopbits".equals(childNodeName)) {
            this.setStopBits(ParserUtilities.extractData(childNode));
        } else if ("writetotaltimeout".equals(childNodeName)) {
            this.setWriteTotalTimeout(ParserUtilities.extractData(childNode));
        } else {
            super.handleChild(childNode);
        }
    }

    protected void setBaudRate(String baudRate) {
        this.fBaudRate = baudRate;
    }

    protected void setComport(String comport) {
        this.fComport = comport;
    }

    protected void setDataBits(String dataBits) {
        this.fDataBits = dataBits;
    }

    protected void setHwFlowControl(String hwFlowControl) {
        this.fHwFlowControl = hwFlowControl;
    }

    protected void setParity(String parity) {
        this.fParity = parity;
    }

    protected void setReadIntervalTimeout(String readIntervalTimeout) {
        this.fReadIntervalTimeout = readIntervalTimeout;
    }

    protected void setReadTotalTimeout(String readTotalTimeout) {
        this.fReadTotalTimeout = readTotalTimeout;
    }

    protected void setStopBits(String stopBits) {
        this.fStopBits = stopBits;
    }

    protected void setSwFlowControl(String swFlowControl) {
        this.fSwFlowControl = swFlowControl;
    }

    protected void setWriteTotalTimeout(String writeTotalTimeout) {
        this.fWriteTotalTimeout = writeTotalTimeout;
    }
}

