/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import org.eclipse.soda.devicekit.generator.model.elements.SpecElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class SpecReferenceElement
extends TagElement {
    private String specSection;
    private String specId;

    public SpecReferenceElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public String getSpecReferenceComment() {
        if (this.specId != null) {
            SpecElement element = (SpecElement)collection.getSpec(this.specId);
            String title = element.getSpecTitle();
            StringBuffer buffer = new StringBuffer(128);
            buffer.append("<p>See specification section <b>");
            buffer.append(this.getSpecSection());
            buffer.append("</b> in <i>");
            buffer.append(title);
            buffer.append("</i></p>.");
            return buffer.toString();
        }
        return new String();
    }

    public String getSpecSection() {
        return this.specSection;
    }

    public int getTagCode() {
        return 65;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("spec".equals(childNodeName)) {
            this.handleSpec(childNode);
        } else if ("specsection".equals(childNodeName)) {
            this.handleSpecSection(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    private void handleSpec(Node node) {
        SpecElement se = new SpecElement(node, this);
        this.addChild(se);
        if (se.getId() != null) {
            try {
                TagElement.collection.addSpec(se.getId(), se);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
            this.specId = se.getId();
        } else if (se.getAttribute("idref") != null) {
            this.specId = se.getAttribute("idref");
        }
    }

    private void handleSpecSection(Node node) {
        String text = ParserUtilities.extractData(node);
        this.setSpecSection(text);
    }

    private void setSpecSection(String specSection) {
        this.specSection = specSection;
    }
}

