/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.Vector;
import org.eclipse.soda.devicekit.generator.model.elements.RootElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;

public class TagCollection {
    protected Vector controlRefs;
    private Vector fCommands;
    private Vector fFilters;
    private Vector fIds = new Vector(256);
    private Vector fMeasurements;
    private Vector fMessages;
    private Vector fParameters;
    private Vector fPids;
    private RootElement fRoot;
    private Vector fSends;
    private Vector fSignals;
    private Vector fTransforms;
    private Vector fUnits;
    private Vector specs;
    private Vector enums;
    private Vector datas;
    private Vector specReferences;

    public TagCollection() {
        this.fCommands = new Vector(32);
        this.fFilters = new Vector(32);
        this.fMeasurements = new Vector(32);
        this.fMessages = new Vector(32);
        this.fParameters = new Vector(32);
        this.fPids = new Vector(256);
        this.fSignals = new Vector(32);
        this.fTransforms = new Vector();
        this.fUnits = new Vector();
        this.fSends = new Vector();
        this.specs = new Vector();
        this.specReferences = new Vector();
        this.enums = new Vector();
        this.datas = new Vector();
        this.controlRefs = new Vector(32);
    }

    public void addCommand(String id, Object command) throws Exception {
        if (!this.fCommands.contains(command)) {
            this.fCommands.addElement(command);
        }
        this.addElement(id, command);
    }

    public void addControlRef(String id, Object command) throws Exception {
        if (!this.controlRefs.contains(command)) {
            this.controlRefs.addElement(command);
        }
        this.addElement(id, command);
    }

    public void addData(String id, Object filter) throws Exception {
        if (!this.datas.contains(filter)) {
            this.datas.addElement(filter);
        }
        this.addElement(id, filter);
    }

    public void addElement(String id, Object element) throws Exception {
        if (!this.idAlreadyExists(id)) {
            this.fIds.addElement(element);
        }
    }

    public void addEnum(String id, Object filter) throws Exception {
        if (!this.enums.contains(filter)) {
            this.enums.addElement(filter);
        }
        this.addElement(id, filter);
    }

    public void addFilter(String id, Object filter) throws Exception {
        if (!this.fFilters.contains(filter)) {
            this.fFilters.addElement(filter);
        }
        this.addElement(id, filter);
    }

    public void addMeasurement(String id, Object measurement) throws Exception {
        if (!this.fMeasurements.contains(measurement)) {
            this.fMeasurements.addElement(measurement);
        }
        this.addElement(id, measurement);
    }

    public void addMessage(String id, Object message) throws Exception {
        if (!this.fMessages.contains(message)) {
            this.fMessages.addElement(message);
        }
        this.addElement(id, message);
    }

    public void addParameter(String id, Object parameter) throws Exception {
        if (!this.fParameters.contains(parameter)) {
            this.fParameters.addElement(parameter);
        }
        this.addElement(id, parameter);
    }

    public void addPid(String id, Object pid) throws Exception {
        if (!this.fPids.contains(pid)) {
            this.fPids.addElement(pid);
        }
        this.addElement(id, pid);
    }

    public void addSend(String id, Object send) throws Exception {
        if (!this.fSends.contains(send)) {
            this.fSends.addElement(send);
        }
        this.addElement(id, send);
    }

    public void addSignal(String id, Object signal) throws Exception {
        if (!this.fSignals.contains(signal)) {
            this.fSignals.addElement(signal);
        }
        this.addElement(id, signal);
    }

    public void addSpec(String id, Object spec) throws Exception {
        if (!this.specs.contains(spec)) {
            this.specs.addElement(spec);
        }
        this.addElement(id, spec);
    }

    public void addSpecReference(String id, Object ref) throws Exception {
        if (!this.specReferences.contains(ref)) {
            this.specReferences.addElement(ref);
        }
        this.addElement(id, ref);
    }

    public void addTransform(String id, Object transform) throws Exception {
        if (!this.fTransforms.contains(transform)) {
            this.fTransforms.addElement(transform);
        }
        this.addElement(id, transform);
    }

    public void addUnits(String id, Object unit) throws Exception {
        if (!this.fUnits.contains(unit)) {
            this.fUnits.addElement(unit);
        }
        this.addElement(id, unit);
    }

    public TagElement getCommand(String id) {
        int i = 0;
        while (i < this.fCommands.size()) {
            TagElement element = (TagElement)this.fCommands.elementAt(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public Vector getCommands() {
        return this.fCommands;
    }

    public Vector getControlRefs() {
        return this.controlRefs;
    }

    public Vector getDatas() {
        return this.datas;
    }

    public Vector getEnums() {
        return this.enums;
    }

    public TagElement getFilter(String id) {
        int i = 0;
        while (i < this.fFilters.size()) {
            TagElement element = (TagElement)this.fFilters.elementAt(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public Vector getFilters() {
        return this.fFilters;
    }

    public Vector getIds() {
        return this.fIds;
    }

    public TagElement getMeasurement(String id) {
        int i = 0;
        while (i < this.fMeasurements.size()) {
            TagElement element = (TagElement)this.fMeasurements.elementAt(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public Vector getMeasurements() {
        return this.fMeasurements;
    }

    public TagElement getMessage(String id) {
        int i = 0;
        while (i < this.fMessages.size()) {
            TagElement element = (TagElement)this.fMessages.elementAt(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public Vector getMessages() {
        return this.fMessages;
    }

    public TagElement getParameter(String id) {
        int i = 0;
        while (i < this.fParameters.size()) {
            TagElement element = (TagElement)this.fParameters.elementAt(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public Vector getParameters() {
        return this.fParameters;
    }

    public TagElement getPid(String id) {
        int i = 0;
        while (i < this.fPids.size()) {
            TagElement element = (TagElement)this.fPids.elementAt(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public Vector getPids() {
        return this.fPids;
    }

    public RootElement getRootElement() {
        return this.fRoot;
    }

    public TagElement getSend(String id) {
        int i = 0;
        while (i < this.fSends.size()) {
            TagElement element = (TagElement)this.fSends.elementAt(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public Vector getSends() {
        return this.fSends;
    }

    public TagElement getSignal(String id) {
        int i = 0;
        while (i < this.fSignals.size()) {
            TagElement element = (TagElement)this.fSignals.elementAt(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public Vector getSignals() {
        return this.fSignals;
    }

    public TagElement getSpec(String id) {
        int i = 0;
        while (i < this.specs.size()) {
            TagElement element = (TagElement)this.specs.elementAt(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public TagElement getSpecReference(String id) {
        int i = 0;
        while (i < this.specReferences.size()) {
            TagElement element = (TagElement)this.specReferences.elementAt(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public Vector getSpecs() {
        return this.specs;
    }

    public TagElement getTransform(String id) {
        int i = 0;
        while (i < this.fTransforms.size()) {
            TagElement element = (TagElement)this.fTransforms.elementAt(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public Vector getTransforms() {
        return this.fTransforms;
    }

    public TagElement getUnit(String id) {
        int i = 0;
        while (i < this.fUnits.size()) {
            TagElement element = (TagElement)this.fUnits.elementAt(i);
            if (element.getId().equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public Vector getUnits() {
        return this.fUnits;
    }

    public boolean idAlreadyExists(String id) {
        int i = 0;
        while (i < this.getIds().size()) {
            TagElement element = (TagElement)this.getIds().elementAt(i);
            if (id.equals(element.getAttribute("id"))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setControlRefs(Vector controlRefs) {
        this.controlRefs = controlRefs;
    }

    public void setDatas(Vector datas) {
        this.datas = datas;
    }

    public void setEnums(Vector enums) {
        this.enums = enums;
    }

    public void setRootElement(RootElement root) {
        this.fRoot = root;
    }
}

