/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.IConnectionItem;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class TcpipElement
extends TagElement
implements IConnectionItem {
    private String fHost;
    private String fLocalPort;
    private String fReadTimeout;
    private String readSize = "-1";
    private String writeSize = "-1";
    private String fRemotePort;
    private String fLinger;

    public TcpipElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        return DeviceKitGenerationConstants.CLASS_CONNECTION_TCPIP;
    }

    public ConfigurationField[] getConfigurationOptions() {
        ArrayList<ConfigurationField> list = new ArrayList<ConfigurationField>();
        list.add(new ConfigurationField("String", "DEFAULT_HOST", DeviceKitUtilities.quote(this.getHost())));
        list.add(new ConfigurationField("int", "DEFAULT_LINGER", this.getLinger()));
        list.add(new ConfigurationField("int", "DEFAULT_LOCALPORT", this.getLocalPort()));
        list.add(new ConfigurationField("int", "DEFAULT_REMOTEPORT", this.getRemotePort()));
        list.add(new ConfigurationField("int", "DEFAULT_READTIMEOUT", this.getReadTimeout()));
        list.add(new ConfigurationField("int", "DEFAULT_READSIZE", this.getReadSize()));
        list.add(new ConfigurationField("int", "DEFAULT_WRITESIZE", this.getWriteSize()));
        ConfigurationField[] pairs = new ConfigurationField[list.size()];
        list.toArray(pairs);
        return pairs;
    }

    public String getConnectionConstant() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_TCPIP_SERVICE));
        buffer.append('.');
        buffer.append("CONNECTION_TYPE");
        return buffer.toString();
    }

    public String getConnectionTag() {
        return "tcpip";
    }

    public String[] getExtraImports() {
        return new String[0];
    }

    public String getHost() {
        if (this.fHost == null) {
            this.fHost = "localhost";
        }
        return this.fHost;
    }

    public String getLinger() {
        if (this.fLinger == null) {
            this.fLinger = "-1";
        }
        return this.fLinger;
    }

    public String getLocalPort() {
        if (this.fLocalPort == null) {
            this.fLocalPort = "-1";
        }
        return this.fLocalPort;
    }

    public Hashtable getProperties() {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("host", this.getHost());
        table.put("localport", this.getLocalPort());
        table.put("readtimeout", this.getReadTimeout());
        table.put("remoteport", this.getRemotePort());
        table.put("linger", this.getLinger());
        table.put("readsize", "-1");
        table.put("writesize", "-1");
        return table;
    }

    public String getReadSize() {
        return this.readSize;
    }

    public String getReadTimeout() {
        if (this.fReadTimeout == null) {
            this.fReadTimeout = "1000";
        }
        return this.fReadTimeout;
    }

    public String getRemotePort() {
        if (this.fRemotePort == null) {
            this.fRemotePort = "1024";
        }
        return this.fRemotePort;
    }

    public int getTagCode() {
        return 37;
    }

    public String getWriteSize() {
        return this.writeSize;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("host".equals(childNodeName)) {
            this.setHost(ParserUtilities.extractData(childNode));
        } else if ("localport".equals(childNodeName)) {
            this.setLocalPort(ParserUtilities.extractData(childNode));
        } else if ("readtimeout".equals(childNodeName)) {
            this.setReadTimeout(ParserUtilities.extractData(childNode));
        } else if ("remoteport".equals(childNodeName)) {
            this.setRemotePort(ParserUtilities.extractData(childNode));
        } else if ("linger".equals(childNodeName)) {
            this.setLinger(ParserUtilities.extractData(childNode));
        } else {
            super.handleChild(childNode);
        }
    }

    protected void setHost(String host) {
        this.fHost = host;
    }

    protected void setLinger(String linger) {
        this.fLinger = linger;
    }

    protected void setLocalPort(String localPort) {
        this.fLocalPort = localPort;
    }

    protected void setReadTimeout(String readTimeout) {
        this.fReadTimeout = readTimeout;
    }

    protected void setRemotePort(String remotePort) {
        this.fRemotePort = remotePort;
    }
}

