/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.BundleElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.ManagedBundleElement;
import org.eclipse.soda.devicekit.generator.model.elements.ManagedFactoryBundleElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestCaseElement;
import org.w3c.dom.Node;

public class TestAgentElement
extends MainTagElement {
    private boolean bundle;
    private boolean managedBundle;
    private boolean managedFactoryBundle;

    public TestAgentElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public TestAgentElement(Node node, TagElement parent, Vector references) {
        super(node, parent, references);
    }

    public String getServiceType() {
        return DeviceKitGenerationConstants.CLASS_TEST_AGENT_SERVICE;
    }

    public String getSuperClass() {
        if (this.getAttribute("superclass") != null) {
            return this.getAttribute("superclass");
        }
        return DeviceKitGenerationConstants.CLASS_TEST_AGENT;
    }

    public int getTagCode() {
        return 87;
    }

    private void handleBundle(Node node) {
        BundleElement element = new BundleElement(node, this);
        this.addChild(element);
        this.setBundle(true);
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("bundle".equals(childNodeName)) {
            this.handleBundle(childNode);
        } else if ("managedbundle".equals(childNodeName)) {
            this.handleManagedBundle(childNode);
        } else if ("managedfactorybundle".equals(childNodeName)) {
            this.handleManagedFactoryBundle(childNode);
        } else if ("testcase".equals(childNodeName)) {
            this.handleTestCase(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    private void handleManagedBundle(Node node) {
        ManagedBundleElement element = new ManagedBundleElement(node, this);
        this.addChild(element);
        this.setManagedBundle(true);
    }

    private void handleManagedFactoryBundle(Node node) {
        ManagedFactoryBundleElement element = new ManagedFactoryBundleElement(node, this);
        this.addChild(element);
        this.setManagedFactoryBundle(true);
    }

    protected void handleTestCase(Node childNode) {
        TestCaseElement element = new TestCaseElement(childNode, this);
        this.addChild(element);
    }

    public boolean isBundle() {
        return this.bundle;
    }

    public boolean isManagedBundle() {
        return this.managedBundle;
    }

    public boolean isManagedFactoryBundle() {
        return this.managedFactoryBundle;
    }

    public void setBundle(boolean bundle) {
        this.bundle = bundle;
    }

    public void setManagedBundle(boolean managedBundle) {
        this.managedBundle = managedBundle;
    }

    public void setManagedFactoryBundle(boolean managedFactoryBundle) {
        this.managedFactoryBundle = managedFactoryBundle;
    }
}

