/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.AdapterElement;
import org.eclipse.soda.devicekit.generator.model.elements.BundleElement;
import org.eclipse.soda.devicekit.generator.model.elements.ConcreteElement;
import org.eclipse.soda.devicekit.generator.model.elements.DeviceElement;
import org.eclipse.soda.devicekit.generator.model.elements.JunitElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.ManagedBundleElement;
import org.eclipse.soda.devicekit.generator.model.elements.ManagedFactoryBundleElement;
import org.eclipse.soda.devicekit.generator.model.elements.MonitorElement;
import org.eclipse.soda.devicekit.generator.model.elements.PlayBackElement;
import org.eclipse.soda.devicekit.generator.model.elements.ProfileElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestCaseElement;
import org.eclipse.soda.devicekit.generator.model.elements.TransportElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class TestElement
extends MainTagElement {
    private boolean bundle;
    private boolean managedBundle;
    private boolean managedFactoryBundle;
    private String fTestCount;
    private String fTestDelay;
    private String fTestExecute;
    private String fTestExecuteRead;
    private String fTestExecuteWrite;
    private String fTestRead;
    private String fTestTrigger;

    public TestElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public String[] getImplementedInterfaces() {
        return new String[0];
    }

    public String getSuperClass() {
        return DeviceKitGenerationConstants.CLASS_CORE_ESC_OBJECT;
    }

    public int getTagCode() {
        return 10;
    }

    public String getTargetClass() {
        Vector target = this.getAllChildrenWithTagCode(8);
        String result = this.getTargetClass(target, 8);
        if (result != null) {
            return result;
        }
        target = this.getAllChildrenWithTagCode(9);
        result = this.getTargetClass(target, 9);
        if (result != null) {
            return result;
        }
        target = this.getAllChildrenWithTagCode(18);
        result = this.getTargetClass(target, 18);
        if (result != null) {
            return result;
        }
        target = this.getAllChildrenWithTagCode(72);
        result = this.getTargetClass(target, 72);
        if (result != null) {
            return result;
        }
        target = this.getAllChildrenWithTagCode(74);
        result = this.getTargetClass(target, 74);
        if (result != null) {
            return result;
        }
        return result;
    }

    private String getTargetClass(Vector target, int targetCode) {
        if (target.size() > 0) {
            TagElement firstElement = (TagElement)target.elementAt(0);
            String implementation = firstElement.getImplementation();
            if (implementation != null) {
                return implementation;
            }
            String idref = firstElement.getAttribute("idref");
            if (idref != null) {
                Vector devs = this.getParent().getAllChildrenWithTagCode(targetCode);
                int i = 0;
                while (i < devs.size()) {
                    TagElement element = (TagElement)devs.elementAt(i);
                    if (idref.equals(element.getId())) {
                        String className = element.getImplementation();
                        return className;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public String getTestCount() {
        return this.fTestCount;
    }

    public String getTestDelay() {
        return this.fTestDelay;
    }

    public String getTestExecute() {
        if (this.fTestExecute != null && this.fTestExecute.equals("0")) {
            return "false";
        }
        if (this.fTestExecute != null && this.fTestExecute.equals("1")) {
            return "true";
        }
        return this.fTestExecute;
    }

    public String getTestExecuteRead() {
        if (this.fTestExecuteRead != null && this.fTestExecuteRead.equals("0")) {
            return "false";
        }
        if (this.fTestExecuteRead != null && this.fTestExecuteRead.equals("1")) {
            return "true";
        }
        return this.fTestExecuteRead;
    }

    public String getTestExecuteWrite() {
        if (this.fTestExecuteWrite != null && this.fTestExecuteWrite.equals("0")) {
            return "false";
        }
        if (this.fTestExecuteWrite != null && this.fTestExecuteWrite.equals("1")) {
            return "true";
        }
        return this.fTestExecuteWrite;
    }

    public String getTestRead() {
        if (this.fTestRead != null && this.fTestRead.equals("0")) {
            return "false";
        }
        if (this.fTestRead != null && this.fTestRead.equals("1")) {
            return "true";
        }
        return this.fTestRead;
    }

    public String getTestTrigger() {
        if (this.fTestTrigger != null && this.fTestTrigger.equals("0")) {
            return "false";
        }
        if (this.fTestTrigger != null && this.fTestTrigger.equals("1")) {
            return "true";
        }
        return this.fTestTrigger;
    }

    protected void handleAdapter(Node childNode) {
        AdapterElement element = new AdapterElement(childNode, this);
        this.addChild(element);
    }

    private void handleBundle(Node node) {
        BundleElement element = new BundleElement(node, this);
        this.addChild(element);
        this.setBundle(true);
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("device".equals(childNodeName)) {
            this.handleDevice(childNode);
        } else if ("transport".equals(childNodeName)) {
            this.handleTransport(childNode);
        } else if ("testcount".equals(childNodeName)) {
            this.setTestCount(ParserUtilities.extractData(childNode));
        } else if ("testdelay".equals(childNodeName)) {
            this.setTestDelay(ParserUtilities.extractData(childNode));
        } else if ("testexecute".equals(childNodeName)) {
            this.setTestExecute(ParserUtilities.extractData(childNode));
        } else if ("testexecuteread".equals(childNodeName)) {
            this.setTestExecuteRead(ParserUtilities.extractData(childNode));
        } else if ("testexecutewrite".equals(childNodeName)) {
            this.setTestExecuteWrite(ParserUtilities.extractData(childNode));
        } else if ("testread".equals(childNodeName)) {
            this.setTestRead(ParserUtilities.extractData(childNode));
        } else if ("testtrigger".equals(childNodeName)) {
            this.setTestTrigger(ParserUtilities.extractData(childNode));
        } else if ("monitor".equals(childNodeName)) {
            this.handleRecord(childNode);
        } else if ("playback".equals(childNodeName)) {
            this.handlePlayBack(childNode);
        } else if ("junit".equals(childNodeName)) {
            this.handleJunit(childNode);
        } else if ("concrete".equals(childNodeName)) {
            this.handleConcrete(childNode);
        } else if ("adapter".equals(childNodeName)) {
            this.handleAdapter(childNode);
        } else if ("profile".equals(childNodeName)) {
            this.handleProfile(childNode);
        } else if ("testcase".equals(childNodeName)) {
            this.handleTestCase(childNode);
        } else if ("bundle".equals(childNodeName)) {
            this.handleBundle(childNode);
        } else if ("managedbundle".equals(childNodeName)) {
            this.handleManagedBundle(childNode);
        } else if ("managedfactorybundle".equals(childNodeName)) {
            this.handleManagedFactoryBundle(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    protected void handleConcrete(Node childNode) {
        ConcreteElement element = new ConcreteElement(childNode, this);
        this.addChild(element);
    }

    private void handleDevice(Node childNode) {
        DeviceElement element = new DeviceElement(childNode, this);
        this.addChild(element);
    }

    private void handleJunit(Node childNode) {
        JunitElement element = new JunitElement(childNode, this);
        this.addChild(element);
    }

    private void handleManagedBundle(Node node) {
        ManagedBundleElement element = new ManagedBundleElement(node, this);
        this.addChild(element);
        this.setManagedBundle(true);
    }

    private void handleManagedFactoryBundle(Node node) {
        ManagedFactoryBundleElement element = new ManagedFactoryBundleElement(node, this);
        this.addChild(element);
        this.setManagedFactoryBundle(true);
    }

    private void handlePlayBack(Node childNode) {
        PlayBackElement element = new PlayBackElement(childNode, this);
        this.addChild(element);
    }

    protected void handleProfile(Node childNode) {
        ProfileElement element = new ProfileElement(childNode, this);
        this.addChild(element);
    }

    private void handleRecord(Node childNode) {
        MonitorElement element = new MonitorElement(childNode, this);
        this.addChild(element);
    }

    protected void handleTestCase(Node childNode) {
        TestCaseElement element = new TestCaseElement(childNode, this);
        this.addChild(element);
    }

    private void handleTransport(Node childNode) {
        TransportElement element = new TransportElement(childNode, this);
        this.addChild(element);
    }

    public boolean isBundle() {
        return this.bundle;
    }

    public boolean isManagedBundle() {
        return this.managedBundle;
    }

    public boolean isManagedFactoryBundle() {
        return this.managedFactoryBundle;
    }

    public void setBundle(boolean bundle) {
        this.bundle = bundle;
    }

    public void setManagedBundle(boolean managedBundle) {
        this.managedBundle = managedBundle;
    }

    public void setManagedFactoryBundle(boolean managedFactoryBundle) {
        this.managedFactoryBundle = managedFactoryBundle;
    }

    protected void setTestCount(String testCount) {
        this.fTestCount = testCount;
    }

    protected void setTestDelay(String testDelay) {
        this.fTestDelay = testDelay;
    }

    protected void setTestExecute(String testExecute) {
        this.fTestExecute = testExecute;
    }

    protected void setTestExecuteRead(String testExecuteRead) {
        this.fTestExecuteRead = testExecuteRead;
    }

    protected void setTestExecuteWrite(String testExecuteWrite) {
        this.fTestExecuteWrite = testExecuteWrite;
    }

    protected void setTestRead(String testRead) {
        this.fTestRead = testRead;
    }

    protected void setTestTrigger(String testTrigger) {
        this.fTestTrigger = testTrigger;
    }
}

