/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.IConnectionItem;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class UdpElement
extends TagElement
implements IConnectionItem {
    private String fRemoteHost;
    private String fRemotePort;
    private String fLocalHost;
    private String fLocalPort;
    private String fPacketSize;

    public UdpElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        return DeviceKitGenerationConstants.CLASS_CONNECTION_UDP;
    }

    public ConfigurationField[] getConfigurationOptions() {
        ArrayList<ConfigurationField> list = new ArrayList<ConfigurationField>();
        list.add(new ConfigurationField("String", "DEFAULT_LOCALHOST", DeviceKitUtilities.quote(this.getLocalHost())));
        list.add(new ConfigurationField("int", "DEFAULT_LOCALPORT", this.getLocalPort()));
        list.add(new ConfigurationField("int", "DEFAULT_PACKETSIZE", this.getPacketSize()));
        list.add(new ConfigurationField("String", "DEFAULT_REMOTEHOST", DeviceKitUtilities.quote(this.getRemoteHost())));
        list.add(new ConfigurationField("int", "DEFAULT_REMOTEPORT", this.getRemotePort()));
        ConfigurationField[] pairs = new ConfigurationField[list.size()];
        list.toArray(pairs);
        return pairs;
    }

    public String getConnectionConstant() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_UDP_SERVICE));
        buffer.append('.');
        buffer.append("CONNECTION_TYPE");
        return buffer.toString();
    }

    public String getConnectionTag() {
        return "udp";
    }

    public String[] getExtraImports() {
        return new String[0];
    }

    public String getLocalHost() {
        if (this.fLocalHost == null) {
            this.fLocalHost = "localhost";
        }
        return this.fLocalHost;
    }

    public String getLocalPort() {
        if (this.fLocalPort == null) {
            this.fLocalPort = "1";
        }
        return this.fLocalPort;
    }

    public String getPacketSize() {
        if (this.fPacketSize == null) {
            this.fPacketSize = "1";
        }
        return this.fPacketSize;
    }

    public Hashtable getProperties() {
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (this.getLocalHost() != null) {
            table.put("localhost", this.getLocalHost());
        }
        if (this.getLocalPort() != null) {
            table.put("localport", this.getLocalPort());
        }
        if (this.getPacketSize() != null) {
            table.put("packetsize", this.getPacketSize());
        }
        if (this.getRemoteHost() != null) {
            table.put("remotehost", this.getRemoteHost());
        }
        if (this.getRemotePort() != null) {
            table.put("remoteport", this.getRemotePort());
        }
        return table;
    }

    public String getRemoteHost() {
        if (this.fRemoteHost == null) {
            this.fRemoteHost = "remotehost";
        }
        return this.fRemoteHost;
    }

    public String getRemotePort() {
        if (this.fRemotePort == null) {
            this.fRemotePort = "1";
        }
        return this.fRemotePort;
    }

    public int getTagCode() {
        return 14;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("remoteport".equals(childNodeName)) {
            this.setRemotePort(ParserUtilities.extractData(childNode));
        } else if ("remotehost".equals(childNodeName)) {
            this.setRemoteHost(ParserUtilities.extractData(childNode));
        } else if ("localhost".equals(childNodeName)) {
            this.setLocalHost(ParserUtilities.extractData(childNode));
        } else if ("localport".equals(childNodeName)) {
            this.setLocalPort(ParserUtilities.extractData(childNode));
        } else if ("packetsize".equals(childNodeName)) {
            this.setPacketSize(ParserUtilities.extractData(childNode));
        } else {
            super.handleChild(childNode);
        }
    }

    protected void setLocalHost(String localHost) {
        this.fLocalHost = localHost;
    }

    protected void setLocalPort(String localPort) {
        this.fLocalPort = localPort;
    }

    protected void setPacketSize(String packetSize) {
        this.fPacketSize = packetSize;
    }

    protected void setRemoteHost(String remoteHost) {
        this.fRemoteHost = remoteHost;
    }

    protected void setRemotePort(String remotePort) {
        this.fRemotePort = remotePort;
    }
}

